/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.UserProfile;
import org.millenaire.common.building.Building;
import org.millenaire.common.building.BuildingPlan;
import org.millenaire.common.building.BuildingProject;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;

public class GuiVillageHead
extends GuiText {
    public static final int ACTION_ICON_LENGTH = 15;
    public static final int ACTION_ICON_HEIGHT = 13;
    private final MillVillager chief;
    private final EntityPlayer player;
    ResourceLocation background = new ResourceLocation("millenaire", "textures/gui/ML_village_chief.png");

    public GuiVillageHead(EntityPlayer player, MillVillager chief) {
        this.chief = chief;
        this.player = player;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton instanceof GuiButtonChief) {
            GuiButtonChief gb = (GuiButtonChief)guibutton;
            boolean close = false;
            if (gb.key == "PRAISE") {
                ClientSender.villageChiefPerformDiplomacy(this.player, this.chief, gb.village, true);
            } else if (gb.key == "SLANDER") {
                ClientSender.villageChiefPerformDiplomacy(this.player, this.chief, gb.village, false);
            } else if (gb.key == "VILLAGE_SCROLL") {
                ClientSender.villageChiefPerformVillageScroll(this.player, this.chief);
                close = true;
            } else if (gb.key == "CULTURE_CONTROL") {
                ClientSender.villageChiefPerformCultureControl(this.player, this.chief);
                close = true;
            } else if (gb.key == "BUILDING") {
                ClientSender.villageChiefPerformBuilding(this.player, this.chief, gb.value);
                close = true;
            } else if (gb.key == "CROP") {
                ClientSender.villageChiefPerformCrop(this.player, this.chief, gb.value);
                close = true;
            }
            if (close) {
                this.closeWindow();
            } else {
                this.descText = this.getData();
                this.buttonPagination();
            }
        }
        super.func_146284_a(guibutton);
    }

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    protected void customDrawScreen(int i, int j, float f) {
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    private List<List<GuiText.Line>> getData() {
        Building b;
        ArrayList<GuiText.Line> text = new ArrayList<GuiText.Line>();
        String game = "";
        if (this.chief.getGameOccupationName(this.player.getDisplayName()).length() > 0) {
            game = " (" + this.chief.getGameOccupationName(this.player.getDisplayName()) + ")";
        }
        text.add(new GuiText.Line(this.chief.getName() + ", " + this.chief.getNativeOccupationName() + game, false));
        text.add(new GuiText.Line(MLN.string("ui.villagechief").replace("<0>", this.chief.getTownHall().getVillageQualifiedName())));
        text.add(new GuiText.Line());
        String col = "";
        if (this.chief.getTownHall().getReputation(this.player.getDisplayName()) >= 32768) {
            col = "<darkgreen>";
        } else if (this.chief.getTownHall().getReputation(this.player.getDisplayName()) >= 4096) {
            col = "<darkblue>";
        } else if (this.chief.getTownHall().getReputation(this.player.getDisplayName()) < -256) {
            col = "<darkred>";
        } else if (this.chief.getTownHall().getReputation(this.player.getDisplayName()) < 0) {
            col = "<lightred>";
        }
        text.add(new GuiText.Line(col + MLN.string("ui.yourstatus") + ": " + this.chief.getTownHall().getReputationLevelLabel(this.player.getDisplayName()), false));
        text.add(new GuiText.Line(col + this.chief.getTownHall().getReputationLevelDesc(this.player.getDisplayName()).replaceAll("\\$name", this.player.getDisplayName())));
        text.add(new GuiText.Line());
        text.add(new GuiText.Line(MLN.string("ui.possiblehousing") + ":"));
        text.add(new GuiText.Line());
        UserProfile profile = Mill.proxy.getClientProfile();
        int reputation = this.chief.getTownHall().getReputation(this.player.getDisplayName());
        for (BuildingProject.EnumProjects ep : BuildingProject.EnumProjects.values()) {
            if (!this.chief.getTownHall().buildingProjects.containsKey((Object)ep)) continue;
            List<BuildingProject> projectsLevel = this.chief.getTownHall().buildingProjects.get((Object)ep);
            for (BuildingProject project : projectsLevel) {
                boolean buyButton;
                String status;
                if (project.planSet == null) continue;
                BuildingPlan plan = project.planSet.getRandomStartingPlan();
                if (plan != null && plan.price > 0 && !plan.isgift) {
                    status = "";
                    buyButton = false;
                    if (project.location != null) {
                        status = MLN.string("ui.alreadybuilt") + ".";
                    } else if (this.chief.getTownHall().buildingsBought.contains(project.key)) {
                        status = MLN.string("ui.alreadyrequested") + ".";
                    } else if (plan.reputation > reputation) {
                        status = MLN.string("ui.notavailableyet") + ".";
                    } else if (plan.price > MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by)) {
                        status = MLN.string("ui.youaremissing", "" + MillCommonUtilities.getShortPrice(plan.price - MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by)));
                    } else {
                        status = MLN.string("ui.available") + ".";
                        buyButton = true;
                    }
                    text.add(new GuiText.Line(plan.nativeName + ": " + status, false));
                    if (!buyButton) continue;
                    text.add(new GuiText.Line(new GuiButtonChief("BUILDING", MLN.string("ui.buybuilding", plan.nativeName, MillCommonUtilities.getShortPrice(plan.price)), plan.buildingKey)));
                    text.add(new GuiText.Line(false));
                    text.add(new GuiText.Line());
                    continue;
                }
                if (!plan.isgift || !MLN.bonusEnabled || Mill.proxy.isTrueClient()) continue;
                status = "";
                buyButton = false;
                if (project.location != null) {
                    status = MLN.string("ui.alreadybuilt") + ".";
                } else if (this.chief.getTownHall().buildingsBought.contains(project.key)) {
                    status = MLN.string("ui.alreadyrequested") + ".";
                } else {
                    status = MLN.string("ui.bonusavailable") + ".";
                    buyButton = true;
                }
                text.add(new GuiText.Line(plan.nativeName + ": " + status, false));
                if (!buyButton) continue;
                text.add(new GuiText.Line(new GuiButtonChief("BUILDING", MLN.string("ui.buybonusbuilding", plan.nativeName), plan.buildingKey)));
                text.add(new GuiText.Line(false));
                text.add(new GuiText.Line());
            }
        }
        if (8192 > reputation) {
            text.add(new GuiText.Line(MLN.string("ui.scrollsnoreputation")));
        } else if (128 > MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by)) {
            text.add(new GuiText.Line(MLN.string("ui.scrollsnotenoughmoney", "" + MillCommonUtilities.getShortPrice(128 - MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by)))));
        } else {
            text.add(new GuiText.Line(MLN.string("ui.scrollsok"), false));
            text.add(new GuiText.Line(new GuiButtonChief("VILLAGE_SCROLL", MLN.string("ui.buyscroll"), MillCommonUtilities.getShortPrice(128))));
            text.add(new GuiText.Line());
            text.add(new GuiText.Line());
        }
        if (this.chief.getCulture().knownCrops.size() > 0) {
            text.add(new GuiText.Line(MLN.string("ui.cropsknown")));
            text.add(new GuiText.Line());
            for (String crop : this.chief.getCulture().knownCrops) {
                if (profile.isTagSet("cropplanting_" + crop)) {
                    text.add(new GuiText.Line(MLN.string("ui.cropknown", MLN.string("item." + crop))));
                    continue;
                }
                if (8192 > reputation) {
                    text.add(new GuiText.Line(MLN.string("ui.cropinsufficientreputation", MLN.string("item." + crop))));
                    continue;
                }
                if (512 > MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by)) {
                    text.add(new GuiText.Line(MLN.string("ui.cropnotenoughmoney", MLN.string("item." + crop), "" + MillCommonUtilities.getShortPrice(512 - MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by)))));
                    continue;
                }
                text.add(new GuiText.Line(MLN.string("ui.cropoktolearn", MLN.string("item." + crop)), false));
                text.add(new GuiText.Line(new GuiButtonChief("CROP", MLN.string("ui.croplearn", "" + MillCommonUtilities.getShortPrice(512)), crop)));
                text.add(new GuiText.Line(false));
                text.add(new GuiText.Line());
            }
            text.add(new GuiText.Line());
        }
        if (profile.isTagSet("culturecontrol_" + this.chief.getCulture().key)) {
            text.add(new GuiText.Line(MLN.string("ui.control_alreadydone", this.chief.getCulture().getCultureGameName())));
        } else if (131072 > reputation) {
            text.add(new GuiText.Line(MLN.string("ui.control_noreputation", this.chief.getCulture().getCultureGameName())));
        } else {
            text.add(new GuiText.Line(MLN.string("ui.control_ok", this.chief.getCulture().getCultureGameName()), false));
            text.add(new GuiText.Line(new GuiButtonChief("CULTURE_CONTROL", MLN.string("ui.control_get"))));
            text.add(new GuiText.Line(false));
            text.add(new GuiText.Line());
        }
        ArrayList<List<GuiText.Line>> pages = new ArrayList<List<GuiText.Line>>();
        pages.add(text);
        text = new ArrayList();
        text.add(new GuiText.Line(MLN.string("ui.relationlist")));
        text.add(new GuiText.Line());
        text.add(new GuiText.Line(MLN.string("ui.relationpoints", "" + profile.getDiplomacyPoints(this.chief.getTownHall()))));
        text.add(new GuiText.Line());
        ArrayList<VillageRelation> relations = new ArrayList<VillageRelation>();
        for (Point p : this.chief.getTownHall().getKnownVillages()) {
            b = this.chief.getTownHall().mw.getBuilding(p);
            if (b == null) continue;
            relations.add(new VillageRelation(p, this.chief.getTownHall().getRelationWithVillage(p), b.getVillageQualifiedName()));
        }
        Collections.sort(relations);
        for (VillageRelation vr : relations) {
            b = this.chief.getTownHall().mw.getBuilding(vr.pos);
            if (b == null) continue;
            col = "";
            if (vr.relation > 70) {
                col = "<darkgreen>";
            } else if (vr.relation > 30) {
                col = "<darkblue>";
            } else if (vr.relation <= -90) {
                col = "<darkred>";
            } else if (vr.relation <= -30) {
                col = "<lightred>";
            }
            text.add(new GuiText.Line(col + MLN.string("ui.villagerelations", b.getVillageQualifiedName(), b.villageType.name, b.culture.getCultureGameName(), MLN.string(MillCommonUtilities.getRelationName(vr.relation)) + " (" + vr.relation + ")"), false));
            GuiButtonChief praise = null;
            GuiButtonChief slander = null;
            if (profile.getDiplomacyPoints(this.chief.getTownHall()) > 0 && reputation > 0) {
                if (vr.relation < 100) {
                    praise = new GuiButtonChief("PRAISE", MLN.string("ui.relationpraise"), vr.pos);
                }
                if (vr.relation > -100) {
                    slander = new GuiButtonChief("SLANDER", MLN.string("ui.relationslander"), vr.pos);
                }
                text.add(new GuiText.Line(praise, slander));
                text.add(new GuiText.Line(false));
                text.add(new GuiText.Line());
                text.add(new GuiText.Line());
                continue;
            }
            text.add(new GuiText.Line("<darkred>" + MLN.string("ui.villagerelationsnobutton")));
            text.add(new GuiText.Line());
        }
        pages.add(text);
        text = new ArrayList();
        text.add(new GuiText.Line(MLN.string("ui.relationhelp")));
        pages.add(text);
        return this.adjustText(pages);
    }

    @Override
    public int getLineSizeInPx() {
        return 240;
    }

    @Override
    public int getPageSize() {
        return 16;
    }

    @Override
    public ResourceLocation getPNGPath() {
        return this.background;
    }

    @Override
    public int getXSize() {
        return 256;
    }

    @Override
    public int getYSize() {
        return 200;
    }

    @Override
    public void initData() {
        this.descText = this.getData();
    }

    private class VillageRelation
    implements Comparable<VillageRelation> {
        int relation;
        Point pos;
        String name;

        VillageRelation(Point p, int r, String name) {
            this.relation = r;
            this.pos = p;
            this.name = name;
        }

        @Override
        public int compareTo(VillageRelation arg0) {
            return this.name.compareTo(arg0.name);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof VillageRelation)) {
                return false;
            }
            return this.pos.equals(((VillageRelation)o).pos);
        }

        public int hashCode() {
            return this.pos.hashCode();
        }
    }

    public static class GuiButtonChief
    extends GuiText.MillGuiButton {
        public static final String PRAISE = "PRAISE";
        public static final String SLANDER = "SLANDER";
        public static final String BUILDING = "BUILDING";
        public static final String VILLAGE_SCROLL = "VILLAGE_SCROLL";
        public static final String CULTURE_CONTROL = "CULTURE_CONTROL";
        public static final String CROP = "CROP";
        public Point village;
        public String value;
        public String key;

        public GuiButtonChief(String key, String label) {
            super(0, 0, 0, 0, 0, label);
            this.key = key;
        }

        public GuiButtonChief(String key, String label, Point v) {
            super(0, 0, 0, 0, 0, label);
            this.village = v;
            this.key = key;
        }

        public GuiButtonChief(String key, String label, String plan) {
            super(0, 0, 0, 0, 0, label);
            this.key = key;
            this.value = plan;
        }
    }
}

