/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.millenaire.common.Culture;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.UserProfile;
import org.millenaire.common.VillageType;
import org.millenaire.common.VillagerRecord;
import org.millenaire.common.VillagerType;
import org.millenaire.common.WorldGenVillage;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.forge.MillAchievements;
import org.millenaire.common.item.Goods;
import org.millenaire.common.network.ServerSender;

public class Quest {
    public static HashMap<String, Quest> quests = new HashMap();
    private static final String REL_NEARBYVILLAGE = "nearbyvillage";
    private static final String REL_ANYVILLAGE = "anyvillage";
    private static final String REL_SAMEHOUSE = "samehouse";
    private static final String REL_SAMEVILLAGE = "samevillage";
    public static final int[] WORLD_MISSION_NB = new int[]{15, 13, 10};
    public static final String[] WORLD_MISSION_KEYS = new String[]{"sadhu", "alchemist", "fallenking"};
    public double chanceperhour = 0.0;
    public String key;
    public int maxsimultaneous = 5;
    public int minreputation = 0;
    public List<QuestStep> steps = new ArrayList<QuestStep>();
    public List<String> globalTagsForbidden = new ArrayList<String>();
    public List<String> globalTagsRequired = new ArrayList<String>();
    public List<String> profileTagsForbidden = new ArrayList<String>();
    public List<String> profileTagsRequired = new ArrayList<String>();
    public HashMap<String, QuestVillager> villagers = new HashMap();
    public List<QuestVillager> villagersOrdered = new ArrayList<QuestVillager>();

    private static Quest loadQuest(File file) {
        Quest q = new Quest();
        q.key = file.getName().split("\\.")[0];
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            QuestStep step = null;
            while ((line = reader.readLine()) != null) {
                InvItem iv;
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                String[] temp = line.split(":");
                if (temp.length != 2) {
                    MLN.error(null, "Invalid line when loading quest " + file.getName() + ": " + line);
                    continue;
                }
                String key = temp[0].toLowerCase();
                String value = temp[1];
                if (key.equals("step")) {
                    Quest quest = q;
                    quest.getClass();
                    step = quest.new QuestStep(q.steps.size());
                    q.steps.add(step);
                    continue;
                }
                if (key.equals("minreputation")) {
                    q.minreputation = MillCommonUtilities.readInteger(value);
                    continue;
                }
                if (key.equals("chanceperhour")) {
                    q.chanceperhour = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("maxsimultaneous")) {
                    q.maxsimultaneous = MillCommonUtilities.readInteger(value);
                    continue;
                }
                if (key.equals("definevillager")) {
                    QuestVillager v = q.loadQVillager(value);
                    if (v == null) continue;
                    q.villagers.put(v.key, v);
                    q.villagersOrdered.add(v);
                    continue;
                }
                if (key.equals("requiredglobaltag")) {
                    q.globalTagsRequired.add(value.trim().toLowerCase());
                    continue;
                }
                if (key.equals("forbiddenglobaltag")) {
                    q.globalTagsForbidden.add(value.trim().toLowerCase());
                    continue;
                }
                if (key.equals("requiredplayertag")) {
                    q.profileTagsRequired.add(value.trim().toLowerCase());
                    continue;
                }
                if (key.equals("forbiddenplayertag")) {
                    q.profileTagsForbidden.add(value.trim().toLowerCase());
                    continue;
                }
                if (step == null) {
                    MLN.error(q, "Reached line while not in a step: " + line);
                    continue;
                }
                if (key.equals("villager")) {
                    step.villager = value;
                    continue;
                }
                if (key.equals("duration")) {
                    step.duration = MillCommonUtilities.readInteger(value);
                    continue;
                }
                if (key.equals("showrequiredgoods")) {
                    step.showRequiredGoods = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.startsWith("label_")) {
                    step.labels.put(key, value);
                    continue;
                }
                if (key.startsWith("description_success_")) {
                    step.descriptionsSuccess.put(key, value);
                    continue;
                }
                if (key.startsWith("description_refuse_")) {
                    step.descriptionsRefuse.put(key, value);
                    continue;
                }
                if (key.startsWith("description_timeup_")) {
                    step.descriptionsTimeUp.put(key, value);
                    continue;
                }
                if (key.startsWith("description_")) {
                    step.descriptions.put(key, value);
                    continue;
                }
                if (key.startsWith("listing_")) {
                    step.listings.put(key, value);
                    continue;
                }
                if (key.equals("requiredgood")) {
                    if (Goods.goodsName.containsKey(value.split(",")[0].toLowerCase())) {
                        iv = Goods.goodsName.get(value.split(",")[0].toLowerCase());
                        step.requiredGood.put(iv, MillCommonUtilities.readInteger(value.split(",")[1]));
                        continue;
                    }
                    MLN.error(null, "Unknown requiredgood found when loading quest " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("rewardgood")) {
                    if (Goods.goodsName.containsKey(value.split(",")[0].toLowerCase())) {
                        iv = Goods.goodsName.get(value.split(",")[0].toLowerCase());
                        step.rewardGoods.put(iv, MillCommonUtilities.readInteger(value.split(",")[1]));
                        continue;
                    }
                    MLN.error(null, "Unknown rewardGood found when loading quest " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("rewardmoney")) {
                    step.rewardMoney = MillCommonUtilities.readInteger(value);
                    continue;
                }
                if (key.equals("rewardreputation")) {
                    step.rewardReputation = MillCommonUtilities.readInteger(value);
                    continue;
                }
                if (key.equals("penaltyreputation")) {
                    step.penaltyReputation = MillCommonUtilities.readInteger(value);
                    continue;
                }
                if (key.equals("setactiondatasuccess")) {
                    step.setActionDataSuccess.add(value.split(","));
                    continue;
                }
                if (key.equals("settagsuccess")) {
                    step.setVillagerTagsSuccess.add(value.split(","));
                    continue;
                }
                if (key.equals("cleartagsuccess")) {
                    step.clearTagsSuccess.add(value.split(","));
                    continue;
                }
                if (key.equals("settagfailure")) {
                    step.setVillagerTagsFailure.add(value.split(","));
                    continue;
                }
                if (key.equals("cleartagfailure")) {
                    step.clearTagsFailure.add(value.split(","));
                    continue;
                }
                if (key.equals("setglobaltagsuccess")) {
                    step.setGlobalTagsSuccess.add(value);
                    continue;
                }
                if (key.equals("clearglobaltagsuccess")) {
                    step.clearGlobalTagsSuccess.add(value);
                    continue;
                }
                if (key.equals("setglobaltagfailure")) {
                    step.setGlobalTagsFailure.add(value);
                    continue;
                }
                if (key.equals("clearglobaltagfailure")) {
                    step.clearGlobalTagsFailure.add(value);
                    continue;
                }
                if (key.equals("setplayertagsuccess")) {
                    step.setPlayerTagsSuccess.add(value);
                    continue;
                }
                if (key.equals("clearplayertagsuccess")) {
                    step.clearPlayerTagsSuccess.add(value);
                    continue;
                }
                if (key.equals("setplayertagfailure")) {
                    step.setPlayerTagsFailure.add(value);
                    continue;
                }
                if (key.equals("clearplayertagfailure")) {
                    step.clearPlayerTagsFailure.add(value);
                    continue;
                }
                if (key.equals("steprequiredglobaltag")) {
                    step.stepRequiredGlobalTag.add(value);
                    continue;
                }
                if (key.equals("stepforbiddenglobaltag")) {
                    step.forbiddenGlobalTag.add(value);
                    continue;
                }
                if (key.equals("steprequiredplayertag")) {
                    step.stepRequiredPlayerTag.add(value);
                    continue;
                }
                if (key.equals("stepforbiddenplayertag")) {
                    step.forbiddenPlayerTag.add(value);
                    continue;
                }
                if (key.equals("bedrockbuilding")) {
                    step.bedrockbuildings.add(value.trim().toLowerCase());
                    continue;
                }
                MLN.error(null, "Unknow parameter when loading quest " + file.getName() + ": " + line);
            }
            reader.close();
            if (q.steps.size() == 0) {
                MLN.error(q, "No steps found in " + file.getName() + ".");
                return null;
            }
            if (q.villagersOrdered.size() == 0) {
                MLN.error(q, "No villagers defined in " + file.getName() + ".");
                return null;
            }
            if (MLN.LogQuest >= 1) {
                MLN.major(q, "Loaded quest type: " + q.key);
            }
            return q;
        }
        catch (Exception e) {
            MLN.printException(e);
            return null;
        }
    }

    public static void loadQuests() {
        ArrayList<File> questDirs = new ArrayList<File>();
        for (File dir : Mill.loadingDirs) {
            File questDir = new File(dir, "quests");
            if (!questDir.exists()) continue;
            questDirs.add(questDir);
        }
        File customQuestDir = new File(Mill.proxy.getCustomDir(), "quests");
        if (customQuestDir.exists()) {
            questDirs.add(customQuestDir);
        }
        for (File questdir : questDirs) {
            for (File dir : questdir.listFiles()) {
                if (!dir.isDirectory()) continue;
                for (File file : dir.listFiles(new MillCommonUtilities.ExtFileFilter("txt"))) {
                    Quest quest = Quest.loadQuest(file);
                    if (quest == null) continue;
                    quests.put(quest.key, quest);
                }
            }
        }
        if (MLN.LogQuest >= 1) {
            MLN.major(null, "Loaded " + quests.size() + " quests.");
        }
    }

    private QuestVillager loadQVillager(String line) {
        QuestVillager v = new QuestVillager();
        for (String s : line.split(",")) {
            String key = s.split("=")[0].toLowerCase();
            String val = s.split("=")[1];
            if (key.equals("key")) {
                v.key = val;
                continue;
            }
            if (key.equals("type")) {
                Culture c = Culture.getCultureByName(val.split("/")[0]);
                if (c == null) {
                    MLN.error(this, "Unknow culture when loading definevillager: " + line);
                    return null;
                }
                VillagerType vtype = c.getVillagerType(val.split("/")[1]);
                if (vtype == null) {
                    MLN.error(this, "Unknow vilager type when loading definevillager: " + line);
                    return null;
                }
                v.types.add(vtype.key);
                continue;
            }
            if (key.equals("relatedto")) {
                v.relatedto = val;
                continue;
            }
            if (key.equals("relation")) {
                v.relation = val;
                continue;
            }
            if (key.equals("forbiddentag")) {
                v.forbiddenTags.add(val);
                continue;
            }
            if (!key.equals("requiredtag")) continue;
            v.requiredTags.add(val);
        }
        if (v.key == null) {
            MLN.error(this, "No key found when loading definevillager: " + line);
            return null;
        }
        return v;
    }

    public QuestInstance testQuest(MillWorld mw, UserProfile profile) {
        if (!MillCommonUtilities.probability(this.chanceperhour)) {
            return null;
        }
        int nb = 0;
        for (QuestInstance qi : profile.questInstances) {
            if (qi.quest != this) continue;
            ++nb;
        }
        if (nb >= this.maxsimultaneous) {
            return null;
        }
        for (String tag : this.globalTagsRequired) {
            if (mw.isGlobalTagSet(tag)) continue;
            return null;
        }
        for (String tag : this.profileTagsRequired) {
            if (profile.isTagSet(tag)) continue;
            return null;
        }
        for (String tag : this.globalTagsForbidden) {
            if (!mw.isGlobalTagSet(tag)) continue;
            return null;
        }
        for (String tag : this.profileTagsForbidden) {
            if (!profile.isTagSet(tag)) continue;
            return null;
        }
        if (MLN.LogQuest >= 3) {
            MLN.debug(this, "Testing quest " + this.key);
        }
        QuestVillager startingVillager = this.villagersOrdered.get(0);
        ArrayList possibleVillagers = new ArrayList();
        for (Point p : mw.getCombinedVillagesLoneBuildings()) {
            Building th = mw.getBuilding(p);
            if (th == null || !th.isActive || th.getReputation(profile.key) < this.minreputation) continue;
            if (MLN.LogQuest >= 3) {
                MLN.debug(this, "Loooking for starting villager in: " + th.getVillageQualifiedName());
            }
            for (VillagerRecord vr : th.vrecords) {
                if (!startingVillager.testVillager(profile, vr)) continue;
                HashMap<String, QuestInstanceVillager> villagers = new HashMap<String, QuestInstanceVillager>();
                villagers.put(startingVillager.key, new QuestInstanceVillager(mw, p, vr.id, vr));
                boolean error = false;
                if (MLN.LogQuest >= 3) {
                    MLN.debug(this, "Found possible starting villager: " + vr);
                }
                for (QuestVillager qv : this.villagersOrdered) {
                    Object chosen;
                    ArrayList<Object> newVillagers;
                    VillagerRecord relatedVillager;
                    if (error || qv == startingVillager) continue;
                    if (MLN.LogQuest >= 3) {
                        MLN.debug(this, "Trying to find villager type: " + qv.relation + "/" + qv.relatedto);
                    }
                    if ((relatedVillager = ((QuestInstanceVillager)villagers.get(qv.relatedto)).getVillagerRecord(mw.world)) == null) {
                        error = true;
                        break;
                    }
                    if (REL_SAMEVILLAGE.equals(qv.relation)) {
                        newVillagers = new ArrayList<Object>();
                        for (VillagerRecord vr2 : mw.getBuilding((Point)relatedVillager.townHallPos).vrecords) {
                            if (vr2.housePos.equals(relatedVillager.housePos) || !qv.testVillager(profile, vr2)) continue;
                            newVillagers.add(vr2);
                        }
                        if (newVillagers.size() > 0) {
                            chosen = (VillagerRecord)newVillagers.get(MillCommonUtilities.randomInt(newVillagers.size()));
                            villagers.put(qv.key, new QuestInstanceVillager(mw, p, ((VillagerRecord)chosen).id, (VillagerRecord)chosen));
                            continue;
                        }
                        error = true;
                        continue;
                    }
                    if (REL_NEARBYVILLAGE.equals(qv.relation) || REL_ANYVILLAGE.equals(qv.relation)) {
                        newVillagers = new ArrayList();
                        for (Point p2 : mw.getCombinedVillagesLoneBuildings()) {
                            Building th2 = mw.getBuilding(p2);
                            if (th2 == null || th2 == th || !REL_ANYVILLAGE.equals(qv.relation) && !(th.getPos().distanceTo(th2.getPos()) < 2000.0)) continue;
                            if (MLN.LogQuest >= 3) {
                                MLN.debug(this, "Trying to find villager type: " + qv.relation + "/" + qv.relatedto + " in " + th2.getVillageQualifiedName());
                            }
                            for (VillagerRecord vr2 : th2.vrecords) {
                                if (MLN.LogQuest >= 3) {
                                    MLN.debug(this, "Testing: " + vr2);
                                }
                                if (!qv.testVillager(profile, vr2)) continue;
                                newVillagers.add(new QuestInstanceVillager(mw, p2, vr2.id, vr2));
                            }
                        }
                        if (newVillagers.size() > 0) {
                            villagers.put(qv.key, (QuestInstanceVillager)newVillagers.get(MillCommonUtilities.randomInt(newVillagers.size())));
                            continue;
                        }
                        error = true;
                        continue;
                    }
                    if (REL_SAMEHOUSE.equals(qv.relation)) {
                        newVillagers = new ArrayList();
                        for (VillagerRecord vr2 : mw.getBuilding((Point)relatedVillager.townHallPos).vrecords) {
                            if (!vr2.housePos.equals(relatedVillager.housePos) || !qv.testVillager(profile, vr2)) continue;
                            newVillagers.add(vr2);
                        }
                        if (newVillagers.size() > 0) {
                            chosen = (VillagerRecord)newVillagers.get(MillCommonUtilities.randomInt(newVillagers.size()));
                            villagers.put(qv.key, new QuestInstanceVillager(mw, p, ((VillagerRecord)chosen).id, (VillagerRecord)chosen));
                            continue;
                        }
                        error = true;
                        continue;
                    }
                    MLN.error(this, "Unknown relation: " + qv.relation);
                }
                if (error) continue;
                possibleVillagers.add(villagers);
                if (MLN.LogQuest < 3) continue;
                MLN.debug(this, "Found all the villagers needed: " + villagers.size());
            }
        }
        if (possibleVillagers.isEmpty()) {
            return null;
        }
        HashMap selectedOption = (HashMap)possibleVillagers.get(MillCommonUtilities.randomInt(possibleVillagers.size()));
        QuestInstance qi = new QuestInstance(mw, this, profile, selectedOption, mw.world.func_72820_D());
        profile.questInstances.add(qi);
        for (QuestInstanceVillager qiv : selectedOption.values()) {
            profile.villagersInQuests.put(qiv.id, qi);
        }
        return qi;
    }

    public String toString() {
        return "QT: " + this.key;
    }

    public class QuestVillager {
        List<String> forbiddenTags = new ArrayList<String>();
        String key = null;
        String relatedto = null;
        String relation = null;
        List<String> requiredTags = new ArrayList<String>();
        List<String> types = new ArrayList<String>();

        public boolean testVillager(UserProfile profile, VillagerRecord vr) {
            String tagPlayer;
            if (profile.villagersInQuests.containsKey(vr.id)) {
                return false;
            }
            if (!this.types.isEmpty() && !this.types.contains(vr.type)) {
                return false;
            }
            for (String tag : this.requiredTags) {
                tagPlayer = profile.key + "_" + tag;
                if (vr.questTags.contains(tagPlayer)) continue;
                return false;
            }
            for (String tag : this.forbiddenTags) {
                tagPlayer = profile.key + "_" + tag;
                if (!vr.questTags.contains(tagPlayer)) continue;
                return false;
            }
            for (String tag : vr.questTags) {
                tagPlayer = profile.key + "_" + tag;
                if (!this.forbiddenTags.contains(tagPlayer)) continue;
                return false;
            }
            return true;
        }
    }

    public class QuestStep {
        int pos;
        public List<String> clearGlobalTagsFailure = new ArrayList<String>();
        public List<String> clearGlobalTagsSuccess = new ArrayList<String>();
        public List<String> clearPlayerTagsFailure = new ArrayList<String>();
        public List<String> clearPlayerTagsSuccess = new ArrayList<String>();
        public List<String[]> clearTagsFailure = new ArrayList<String[]>();
        public List<String[]> clearTagsSuccess = new ArrayList<String[]>();
        public final HashMap<String, String> descriptions = new HashMap();
        public final HashMap<String, String> descriptionsRefuse = new HashMap();
        public final HashMap<String, String> descriptionsSuccess = new HashMap();
        public final HashMap<String, String> descriptionsTimeUp = new HashMap();
        public final HashMap<String, String> labels = new HashMap();
        public final HashMap<String, String> listings = new HashMap();
        public int duration = 1;
        public List<String> forbiddenGlobalTag = new ArrayList<String>();
        public List<String> forbiddenPlayerTag = new ArrayList<String>();
        public int penaltyReputation = 0;
        public HashMap<InvItem, Integer> requiredGood = new HashMap();
        public List<String> stepRequiredGlobalTag = new ArrayList<String>();
        public List<String> stepRequiredPlayerTag = new ArrayList<String>();
        public HashMap<InvItem, Integer> rewardGoods = new HashMap();
        public int rewardMoney = 0;
        public int rewardReputation = 0;
        public List<String> bedrockbuildings = new ArrayList<String>();
        public List<String> setGlobalTagsFailure = new ArrayList<String>();
        public List<String> setGlobalTagsSuccess = new ArrayList<String>();
        public List<String> setPlayerTagsFailure = new ArrayList<String>();
        public List<String> setPlayerTagsSuccess = new ArrayList<String>();
        public List<String[]> setVillagerTagsFailure = new ArrayList<String[]>();
        public List<String[]> setVillagerTagsSuccess = new ArrayList<String[]>();
        public List<String[]> setActionDataSuccess = new ArrayList<String[]>();
        public boolean showRequiredGoods = true;
        public String villager;

        public QuestStep(int pos) {
            this.pos = pos;
        }

        public String getDescription() {
            return MLN.questString(this.getStringKey() + "description", true);
        }

        public String getDescriptionRefuse() {
            return MLN.questString(this.getStringKey() + "description_refuse", true);
        }

        public String getDescriptionSuccess() {
            return MLN.questString(this.getStringKey() + "description_success", true);
        }

        public String getDescriptionTimeUp() {
            return MLN.questString(this.getStringKey() + "description_timeup", false);
        }

        public String getLabel() {
            return MLN.questString(this.getStringKey() + "label", true);
        }

        public String getListing() {
            return MLN.questString(this.getStringKey() + "listing", false);
        }

        public String getStringKey() {
            return Quest.this.key + "_" + this.pos + "_";
        }

        public String lackingConditions(EntityPlayer player) {
            MillWorld mw = Mill.getMillWorld(player.field_70170_p);
            UserProfile profile = mw.getProfile(player.getDisplayName());
            String lackingGoods = null;
            for (InvItem item : this.requiredGood.keySet()) {
                int diff;
                ItemStack stack;
                int i;
                int nbenchanted;
                if (item.special == 1) {
                    nbenchanted = 0;
                    for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        stack = player.field_71071_by.func_70301_a(i);
                        if (stack == null || !stack.func_77948_v()) continue;
                        ++nbenchanted;
                    }
                    diff = this.requiredGood.get(item) - nbenchanted;
                } else if (item.special == 2) {
                    nbenchanted = 0;
                    for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        stack = player.field_71071_by.func_70301_a(i);
                        if (stack == null || !stack.func_77948_v() || !(stack.func_77973_b() instanceof ItemSword)) continue;
                        ++nbenchanted;
                    }
                    diff = this.requiredGood.get(item) - nbenchanted;
                } else {
                    diff = this.requiredGood.get(item) - MillCommonUtilities.countChestItems((IInventory)player.field_71071_by, item.getItem(), item.meta);
                }
                if (diff <= 0) continue;
                lackingGoods = lackingGoods != null ? lackingGoods + ", " : "";
                lackingGoods = lackingGoods + diff + " " + item.getName();
            }
            if (lackingGoods != null) {
                lackingGoods = this.showRequiredGoods ? MLN.string("quest.lackingcondition") + " " + lackingGoods : MLN.string("quest.lackinghiddengoods");
            }
            boolean tagsOk = true;
            for (String tag : this.stepRequiredGlobalTag) {
                if (mw.isGlobalTagSet(tag)) continue;
                tagsOk = false;
            }
            for (String tag : this.forbiddenGlobalTag) {
                if (!mw.isGlobalTagSet(tag)) continue;
                tagsOk = false;
            }
            for (String tag : this.stepRequiredPlayerTag) {
                if (profile.isTagSet(tag)) continue;
                tagsOk = false;
            }
            for (String tag : this.forbiddenPlayerTag) {
                if (!profile.isTagSet(tag)) continue;
                tagsOk = false;
            }
            if (!tagsOk) {
                lackingGoods = lackingGoods != null ? lackingGoods + ". " : "";
                lackingGoods = lackingGoods + MLN.string("quest.conditionsnotmet");
            }
            return lackingGoods;
        }
    }

    public static class QuestInstanceVillager {
        public long id;
        public Point townHall;
        private MillVillager villager = null;
        private VillagerRecord vr = null;
        public MillWorld mw;

        public QuestInstanceVillager(MillWorld mw, Point p, long vid) {
            this.townHall = p;
            this.id = vid;
            this.mw = mw;
        }

        public QuestInstanceVillager(MillWorld mw, Point p, long vid, MillVillager v) {
            this.townHall = p;
            this.id = vid;
            this.villager = v;
            this.mw = mw;
        }

        public QuestInstanceVillager(MillWorld mw, Point p, long vid, VillagerRecord v) {
            this.townHall = p;
            this.id = vid;
            this.vr = v;
            this.mw = mw;
        }

        public Building getTownHall(World world) {
            return this.mw.getBuilding(this.townHall);
        }

        public MillVillager getVillager(World world) {
            Building th;
            if (this.villager == null && (th = this.mw.getBuilding(this.townHall)) != null) {
                this.villager = th.getVillagerById(this.id);
            }
            return this.villager;
        }

        public VillagerRecord getVillagerRecord(World world) {
            Building th;
            if (this.vr == null && (th = this.mw.getBuilding(this.townHall)) != null) {
                this.vr = th.getVillagerRecordById(this.id);
            }
            return this.vr;
        }
    }

    public static class QuestInstance {
        private static final int QUEST_LANGUAGE_BONUS = 50;
        public int currentStep = 0;
        public long currentStepStart;
        public Quest quest;
        public long startTime;
        public HashMap<String, QuestInstanceVillager> villagers;
        public UserProfile profile = null;
        public MillWorld mw;
        public World world;
        public long uniqueid;

        public static QuestInstance loadFromString(MillWorld mw, String line, UserProfile profile) {
            Quest q = null;
            int step = 0;
            long startTime = 0L;
            long stepStartTime = 0L;
            HashMap<String, QuestInstanceVillager> villagers = new HashMap<String, QuestInstanceVillager>();
            for (String s : line.split(";")) {
                if (s.split(":").length != 2) continue;
                String key = s.split(":")[0];
                String value = s.split(":")[1];
                if (key.equals("quest")) {
                    if (quests.containsKey(value)) {
                        q = quests.get(value);
                        continue;
                    }
                    MLN.error(null, "Could not find quest '" + value + "'.");
                    continue;
                }
                if (key.equals("startTime")) {
                    startTime = Long.parseLong(value);
                    continue;
                }
                if (key.equals("currentStepStartTime")) {
                    stepStartTime = Long.parseLong(value);
                    continue;
                }
                if (key.equals("step")) {
                    step = Integer.parseInt(value);
                    continue;
                }
                if (!key.equals("villager")) continue;
                String[] vals = value.split(",");
                QuestInstanceVillager qiv = new QuestInstanceVillager(mw, new Point(vals[2]), Long.parseLong(vals[1]));
                villagers.put(vals[0], qiv);
            }
            if (q != null && villagers.size() > 0) {
                return new QuestInstance(mw, q, profile, villagers, startTime, step, stepStartTime);
            }
            return null;
        }

        public QuestInstance(MillWorld mw, Quest quest, UserProfile profile, HashMap<String, QuestInstanceVillager> villagers, long startTime) {
            this(mw, quest, profile, villagers, startTime, 0, startTime);
        }

        public QuestInstance(MillWorld mw, Quest quest, UserProfile profile, HashMap<String, QuestInstanceVillager> villagers, long startTime, int step, long stepStartTime) {
            this.mw = mw;
            this.world = mw.world;
            this.villagers = villagers;
            this.quest = quest;
            this.currentStep = step;
            this.startTime = startTime;
            this.profile = profile;
            this.currentStepStart = stepStartTime;
            this.uniqueid = (long)(Math.random() * 9.223372036854776E18);
        }

        private void applyActionData(List<String[]> data) {
            for (String[] val : data) {
                this.profile.setActionData(val[0], val[1]);
            }
        }

        private void applyGlobalTags(List<String> set, List<String> clear) {
            if (MLN.LogQuest >= 3) {
                MLN.debug(this, "Applying " + set.size() + " global tags, clearing " + clear.size() + " global tags.");
            }
            for (String val : set) {
                this.mw.setGlobalTag(val);
            }
            for (String val : clear) {
                this.mw.clearGlobalTag(val);
            }
        }

        private void applyPlayerTags(List<String> set, List<String> clear) {
            if (MLN.LogQuest >= 3) {
                MLN.debug(this, "Applying " + set.size() + " player tags, clearing " + clear.size() + " player tags.");
            }
            for (String val : set) {
                this.profile.setTag(val);
            }
            for (String val : clear) {
                this.profile.clearTag(val);
            }
        }

        private void applyTags(List<String[]> set, List<String[]> clear) {
            String tag;
            if (MLN.LogQuest >= 3) {
                MLN.debug(this, "Applying " + set.size() + " tags, clearing " + clear.size() + " tags.");
            }
            for (String[] val : set) {
                tag = this.profile.key + "_" + val[1];
                if (MLN.LogQuest >= 3) {
                    MLN.debug(this, "Applying tag: " + val[0] + "/" + tag);
                }
                if (this.villagers.get((Object)val[0]).getVillagerRecord((World)this.world).questTags.contains(tag)) continue;
                this.villagers.get((Object)val[0]).getVillagerRecord((World)this.world).questTags.add(tag);
                this.villagers.get(val[0]).getVillagerRecord(this.world).getTownHall().requestSave("quest tag");
                if (MLN.LogQuest < 2) continue;
                MLN.minor(this, "Setting tag: " + tag + " on villager: " + val[0] + " (" + this.villagers.get(val[0]).getVillagerRecord(this.world).getName() + ") Now present: " + this.villagers.get((Object)val[0]).getVillagerRecord((World)this.world).questTags.size());
            }
            for (String[] val : clear) {
                tag = this.profile.key + "_" + val[1];
                if (MLN.LogQuest >= 3) {
                    MLN.debug(this, "Clearing tag: " + val[0] + "/" + tag);
                }
                this.villagers.get((Object)val[0]).getVillagerRecord((World)this.world).questTags.remove(tag);
                this.villagers.get(val[0]).getVillagerRecord(this.world).getTownHall().requestSave("quest tag");
                if (MLN.LogQuest < 2) continue;
                MLN.minor(this, "Clearing tag: " + tag + " on villager: " + val[0] + " (" + this.villagers.get(val[0]).getVillagerRecord(this.world).getName() + ")");
            }
        }

        public boolean checkStatus(World world) {
            if (this.currentStepStart + (long)(this.getCurrentStep().duration * 1000) <= world.func_72820_D()) {
                MillVillager cv = this.getCurrentVillager().getVillager(world);
                if (cv != null && this.getCurrentStep().penaltyReputation > 0) {
                    this.profile.adjustReputation(cv.getTownHall(), -this.getCurrentStep().penaltyReputation);
                }
                this.applyTags(this.getCurrentStep().setVillagerTagsFailure, this.getCurrentStep().clearTagsFailure);
                this.applyGlobalTags(this.getCurrentStep().setGlobalTagsFailure, this.getCurrentStep().clearGlobalTagsFailure);
                this.applyPlayerTags(this.getCurrentStep().setPlayerTagsFailure, this.getCurrentStep().clearPlayerTagsFailure);
                if (this.getCurrentStep().getDescriptionTimeUp() != null) {
                    ServerSender.sendChat(this.profile.getPlayer(), EnumChatFormatting.RED, this.getDescriptionTimeUp(this.profile) + " (" + MLN.string("quest.reputationlost") + ": " + this.getCurrentStep().penaltyReputation + ")");
                }
                this.destroySelf();
                return true;
            }
            return false;
        }

        public String completeStep(EntityPlayer player, MillVillager villager) {
            String reward = "";
            for (InvItem item : this.getCurrentStep().requiredGood.keySet()) {
                if (item.special != 0) continue;
                villager.addToInv(item.getItem(), item.meta, (int)this.getCurrentStep().requiredGood.get(item));
                MillCommonUtilities.getItemsFromChest((IInventory)player.field_71071_by, item.getItem(), item.meta, (int)this.getCurrentStep().requiredGood.get(item));
            }
            for (InvItem item : this.getCurrentStep().rewardGoods.keySet()) {
                EntityItem entItem;
                int nbLeft = this.getCurrentStep().rewardGoods.get(item) - MillCommonUtilities.putItemsInChest((IInventory)player.field_71071_by, item.getItem(), item.meta, (int)this.getCurrentStep().rewardGoods.get(item));
                if (nbLeft > 0 && (entItem = MillCommonUtilities.spawnItem(this.world, villager.getPos(), new ItemStack(item.getItem(), nbLeft, item.meta), 0.0f)).func_92059_d().func_77973_b() instanceof Goods.IItemInitialEnchantmens) {
                    ((Goods.IItemInitialEnchantmens)entItem.func_92059_d().func_77973_b()).applyEnchantments(entItem.func_92059_d());
                }
                reward = reward + " " + this.getCurrentStep().rewardGoods.get(item) + " " + item.getName();
            }
            if (this.getCurrentStep().rewardMoney > 0) {
                MillCommonUtilities.changeMoney((IInventory)player.field_71071_by, this.getCurrentStep().rewardMoney, player);
                reward = reward + " " + this.getCurrentStep().rewardMoney + " deniers";
            }
            if (this.getCurrentStep().rewardReputation > 0) {
                this.mw.getProfile(player.getDisplayName()).adjustReputation(villager.getTownHall(), this.getCurrentStep().rewardReputation);
                reward = reward + " " + this.getCurrentStep().rewardReputation + " reputation";
                int experience = this.getCurrentStep().rewardReputation / 32;
                if (experience > 16) {
                    experience = 16;
                }
                if (experience > 0) {
                    reward = reward + " " + experience + " experience";
                    MillCommonUtilities.spawnExp(this.world, villager.getPos().getRelative(0.0, 2.0, 0.0), experience);
                }
            }
            this.mw.getProfile(player.getDisplayName()).adjustLanguage(villager.getCulture().key, 50);
            if (!this.world.field_72995_K) {
                this.applyTags(this.getCurrentStep().setVillagerTagsSuccess, this.getCurrentStep().clearTagsSuccess);
                this.applyGlobalTags(this.getCurrentStep().setGlobalTagsSuccess, this.getCurrentStep().clearGlobalTagsSuccess);
                this.applyPlayerTags(this.getCurrentStep().setPlayerTagsSuccess, this.getCurrentStep().clearPlayerTagsSuccess);
                this.applyActionData(this.getCurrentStep().setActionDataSuccess);
                for (String s : this.getCurrentStep().bedrockbuildings) {
                    String culture = s.split(",")[0];
                    String village = s.split(",")[1];
                    VillageType vt = Culture.getCultureByName(culture).getLoneBuildingType(village);
                    try {
                        WorldGenVillage.generateBedrockLoneBuilding(new Point((Entity)player), this.world, vt, MillCommonUtilities.random, 50, 120, player);
                    }
                    catch (MLN.MillenaireException e) {
                        MLN.printException(e);
                    }
                }
            }
            String res = this.getDescriptionSuccess(this.mw.getProfile(player.getDisplayName()));
            if (reward.length() > 0) {
                res = res + "<ret><ret>" + MLN.string("quest.obtained") + ":" + reward;
            }
            ++this.currentStep;
            if (this.currentStep >= this.quest.steps.size()) {
                player.func_71064_a((StatBase)MillAchievements.thequest, 1);
                if (this.mw.getProfile(player.getDisplayName()).isWorldQuestFinished()) {
                    player.func_71064_a((StatBase)MillAchievements.forbiddenknwoledge, 1);
                }
                this.destroySelf();
            } else {
                this.currentStepStart = villager.field_70170_p.func_72820_D();
                this.profile.sendQuestInstancePacket(this);
                this.profile.saveQuestInstances();
            }
            return res;
        }

        private void destroySelf() {
            this.profile.questInstances.remove(this);
            for (QuestInstanceVillager qiv : this.villagers.values()) {
                this.profile.villagersInQuests.remove(qiv.id);
            }
            this.profile.saveQuestInstances();
        }

        public QuestStep getCurrentStep() {
            return this.quest.steps.get(this.currentStep);
        }

        public QuestInstanceVillager getCurrentVillager() {
            return this.villagers.get(this.getCurrentStep().villager);
        }

        public String getDescription(UserProfile profile) {
            return this.handleString(profile, this.getCurrentStep().getDescription());
        }

        public String getDescriptionRefuse(UserProfile profile) {
            return this.handleString(profile, this.getCurrentStep().getDescriptionRefuse());
        }

        public String getDescriptionSuccess(UserProfile profile) {
            return this.handleString(profile, this.getCurrentStep().getDescriptionSuccess());
        }

        public String getDescriptionTimeUp(UserProfile profile) {
            return this.handleString(profile, this.getCurrentStep().getDescriptionTimeUp());
        }

        public String getLabel(UserProfile profile) {
            return this.handleString(profile, this.getCurrentStep().getLabel());
        }

        public String getListing(UserProfile profile) {
            return this.handleString(profile, this.getCurrentStep().getListing());
        }

        public QuestStep getNextStep() {
            if (this.currentStep + 1 < this.quest.steps.size()) {
                return this.quest.steps.get(this.currentStep + 1);
            }
            return null;
        }

        public QuestStep getPreviousStep() {
            if (this.currentStep > 0) {
                return this.quest.steps.get(this.currentStep - 1);
            }
            return null;
        }

        private String handleString(UserProfile profile, String s) {
            if (s == null) {
                return null;
            }
            Building giverTH = this.villagers.get(this.getCurrentStep().villager).getTownHall(this.world);
            if (giverTH == null) {
                return s;
            }
            for (String key : this.villagers.keySet()) {
                QuestInstanceVillager qiv = this.villagers.get(key);
                Building th = qiv.getTownHall(this.world);
                if (th == null) continue;
                s = s.replaceAll("\\$" + key + "_villagename\\$", th.getVillageQualifiedName());
                s = s.replaceAll("\\$" + key + "_direction\\$", MLN.string(giverTH.getPos().directionTo(th.getPos())));
                s = s.replaceAll("\\$" + key + "_tothedirection\\$", MLN.string(giverTH.getPos().directionTo(th.getPos(), true)));
                s = s.replaceAll("\\$" + key + "_directionshort\\$", MLN.string(giverTH.getPos().directionToShort(th.getPos())));
                s = s.replaceAll("\\$" + key + "_distance\\$", MLN.string(giverTH.getPos().approximateDistanceLongString(th.getPos())));
                s = s.replaceAll("\\$" + key + "_distanceshort\\$", MLN.string(giverTH.getPos().approximateDistanceShortString(th.getPos())));
                VillagerRecord villager = qiv.getVillagerRecord(this.world);
                if (villager != null) {
                    s = s.replaceAll("\\$" + key + "_villagername\\$", villager.getName());
                    s = s.replaceAll("\\$" + key + "_villagerrole\\$", villager.getGameOccupation(profile.key));
                }
                for (String key2 : this.villagers.keySet()) {
                    QuestInstanceVillager qiv2 = this.villagers.get(key2);
                    Building th2 = qiv2.getTownHall(this.world);
                    if (th2 != null) {
                        s = s.replaceAll("\\$" + key + "_" + key2 + "_direction\\$", MLN.string(th.getPos().directionTo(th2.getPos())));
                        s = s.replaceAll("\\$" + key + "_" + key2 + "_directionshort\\$", MLN.string(th.getPos().directionToShort(th2.getPos())));
                        s = s.replaceAll("\\$" + key + "_" + key2 + "_distance\\$", MLN.string(th.getPos().approximateDistanceLongString(th2.getPos())));
                        s = s.replaceAll("\\$" + key + "_" + key2 + "_distanceshort\\$", MLN.string(th.getPos().approximateDistanceShortString(th2.getPos())));
                        continue;
                    }
                    s = s.replaceAll("\\$" + key + "_" + key2 + "_direction\\$", "");
                    s = s.replaceAll("\\$" + key + "_" + key2 + "_directionshort\\$", "");
                    s = s.replaceAll("\\$" + key + "_" + key2 + "_distance\\$", "");
                    s = s.replaceAll("\\$" + key + "_" + key2 + "_distanceshort\\$", "");
                }
            }
            s = s.replaceAll("\\$name", profile.playerName);
            return s;
        }

        public String refuseQuest(EntityPlayer player, MillVillager villager) {
            String replost = "";
            MillVillager cv = this.getCurrentVillager().getVillager(this.world);
            if (cv != null && this.getCurrentStep().penaltyReputation > 0) {
                this.mw.getProfile(player.getDisplayName()).adjustReputation(cv.getTownHall(), -this.getCurrentStep().penaltyReputation);
                replost = " (Reputation lost: " + this.getCurrentStep().penaltyReputation + ")";
            }
            this.applyTags(this.getCurrentStep().setVillagerTagsFailure, this.getCurrentStep().clearTagsFailure);
            this.applyPlayerTags(this.getCurrentStep().setPlayerTagsFailure, this.getCurrentStep().clearPlayerTagsFailure);
            this.applyGlobalTags(this.getCurrentStep().setGlobalTagsFailure, this.getCurrentStep().clearGlobalTagsFailure);
            String s = this.getDescriptionRefuse(this.mw.getProfile(player.getDisplayName())) + replost;
            this.destroySelf();
            return s;
        }

        public String toString() {
            return "QI:" + this.quest.key;
        }

        public String writeToString() {
            String s = "quest:" + this.quest.key + ";step:" + this.currentStep + ";startTime:" + this.startTime + ";currentStepStartTime:" + this.currentStepStart;
            for (String key : this.villagers.keySet()) {
                QuestInstanceVillager qiv = this.villagers.get(key);
                s = s + ";villager:" + key + "," + qiv.id + "," + qiv.townHall;
            }
            return s;
        }
    }
}

