/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import org.millenaire.common.Culture;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.item.Goods;
import org.millenaire.common.network.StreamReadWrite;

public class VillagerType
implements MillCommonUtilities.WeightedChoice {
    private static final String TAG_LOCALMERCHANT = "localmerchant";
    private static final String TAG_FOREIGNMERCHANT = "foreignmerchant";
    private static final String TAG_CHILD = "child";
    private static final String TAG_RELIGIOUS = "religious";
    private static final String TAG_CHIEF = "chief";
    private static final String TAG_DRINKER = "heavydrinker";
    private static final String TAG_SELLER = "seller";
    private static final String TAG_MEDITATES = "meditates";
    private static final String TAG_SACRIFICES = "performssacrifices";
    private static final String TAG_VISITOR = "visitor";
    private static final String TAG_HELPSINATTACKS = "helpinattacks";
    private static final String TAG_GATHERSAPPLES = "gathersapples";
    private static final String TAG_HOSTILE = "hostile";
    private static final String TAG_NOLEAFCLEARING = "noleafclearing";
    private static final String TAG_ARCHER = "archer";
    private static final String TAG_RAIDER = "raider";
    private static final String TAG_NOTELEPORT = "noteleport";
    private static final String TAG_HIDENAME = "hidename";
    private static final String TAG_SHOWHEALTH = "showhealth";
    private static final String TAG_DEFENSIVE = "defensive";
    private static final String TAG_NORESURRECT = "noresurrect";
    public Culture culture;
    public String name;
    public String key;
    public String altname;
    public String altkey;
    public String model = null;
    public int baseAttackStrength = -1;
    public int health = -1;
    public boolean isChild = false;
    public boolean isReligious = false;
    public boolean isChief = false;
    public boolean isHeavyDrinker = false;
    public boolean canSell = false;
    public boolean canMeditate = false;
    public boolean canPerformSacrifices = false;
    public boolean visitor = false;
    public boolean helpInAttacks = false;
    public boolean isLocalMerchant = false;
    public boolean isForeignMerchant = false;
    public boolean gathersApples = false;
    public boolean hostile = false;
    public boolean noleafclearing = false;
    public boolean isArcher = false;
    public boolean isRaider = false;
    public boolean noTeleport = false;
    public boolean hideName = false;
    public boolean showHealth = false;
    public boolean isDefensive = false;
    public boolean noResurrect = false;
    public float baseScale = 1.0f;
    public String familyNameList;
    public String firstNameList;
    public int chanceWeight = 0;
    public int expgiven = 0;
    public Goal[] goals;
    public String[] textures;
    public HashMap<InvItem, Integer> requiredGoods = new HashMap();
    public HashMap<InvItem, Integer> requiredFoodAndGoods = new HashMap();
    public HashMap<InvItem, Integer> startingInv = new HashMap();
    public HashMap<InvItem, Integer> foreignMerchantStock = new HashMap();
    public HashMap<String, List<String>> clothes = new HashMap();
    public InvItem[] bringBackHomeGoods;
    public InvItem[] collectGoods;
    public InvItem startingWeapon;
    private final List<String> tags = new ArrayList<String>();
    public InvItem[] toolsNeeded;
    public int gender;
    public String maleChild = null;
    public String femaleChild = null;
    public int hireCost;

    public static VillagerType loadVillagerType(File file, Culture c) {
        VillagerType v = new VillagerType(c, file.getName().split("\\.")[0]);
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            ArrayList<Goal> goals = new ArrayList<Goal>();
            ArrayList<String> textures = new ArrayList<String>();
            ArrayList<InvItem> toolsNeeded = new ArrayList<InvItem>();
            ArrayList<InvItem> bringBackHomeGoods = new ArrayList<InvItem>();
            ArrayList<InvItem> collectGoods = new ArrayList<InvItem>();
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                String[] temp = line.split("=");
                if (temp.length != 2) {
                    MLN.error(null, "Invalid line when loading villager type " + file.getName() + ": " + line);
                    continue;
                }
                String key = temp[0].toLowerCase();
                String value = temp[1].trim();
                if (key.equals("native_name")) {
                    v.name = value;
                    continue;
                }
                if (key.equals("alt_native_name")) {
                    v.altname = value;
                    continue;
                }
                if (key.equals("alt_key")) {
                    v.altkey = value;
                    continue;
                }
                if (key.equals("model")) {
                    v.model = value.toLowerCase();
                    continue;
                }
                if (key.equals("goal")) {
                    if (Goal.goals.containsKey(value.toLowerCase())) {
                        goals.add(Goal.goals.get(value.toLowerCase()));
                        continue;
                    }
                    MLN.error(null, "Unknown goal found when loading villager type " + file.getName() + ": " + value + " amoung " + Goal.goals.size());
                    continue;
                }
                if (key.equals("texture")) {
                    textures.add(value);
                    continue;
                }
                if (key.equals("requiredgood")) {
                    if (Goods.goodsName.containsKey(value.split(",")[0].toLowerCase())) {
                        InvItem invItem = Goods.goodsName.get(value.split(",")[0].toLowerCase());
                        v.requiredGoods.put(invItem, Integer.parseInt(value.split(",")[1]));
                        v.requiredFoodAndGoods.put(invItem, Integer.parseInt(value.split(",")[1]));
                        continue;
                    }
                    MLN.error(null, "Unknown required good found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("requiredfood")) {
                    if (Goods.goodsName.containsKey(value.split(",")[0].toLowerCase())) {
                        InvItem invItem = Goods.goodsName.get(value.split(",")[0].toLowerCase());
                        v.requiredFoodAndGoods.put(invItem, Integer.parseInt(value.split(",")[1]));
                        continue;
                    }
                    MLN.error(null, "Unknown required good found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("startinginv")) {
                    if (Goods.goodsName.containsKey(value.split(",")[0].toLowerCase())) {
                        InvItem invItem = Goods.goodsName.get(value.split(",")[0].toLowerCase());
                        v.startingInv.put(invItem, Integer.parseInt(value.split(",")[1]));
                        continue;
                    }
                    MLN.error(null, "Unknown starting inv found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("merchantstock")) {
                    if (Goods.goodsName.containsKey(value.split(",")[0].toLowerCase())) {
                        InvItem invItem = Goods.goodsName.get(value.split(",")[0].toLowerCase());
                        v.foreignMerchantStock.put(invItem, Integer.parseInt(value.split(",")[1]));
                        continue;
                    }
                    MLN.error(null, "Unknown merchantstock found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("toolneeded")) {
                    if (Goods.goodsName.containsKey(value.toLowerCase())) {
                        InvItem invItem = Goods.goodsName.get(value.toLowerCase());
                        toolsNeeded.add(invItem);
                        continue;
                    }
                    MLN.error(null, "Unknown tool needed found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("toolneededclass")) {
                    Item item2;
                    int n;
                    if (value.equalsIgnoreCase("meleeweapons")) {
                        Item[] itemArray = MillVillager.weaponsSwords;
                        int n2 = itemArray.length;
                        for (n = 0; n < n2; ++n) {
                            Item item2 = itemArray[n];
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase("rangedweapons")) {
                        Item[] itemArray = MillVillager.weaponsRanged;
                        int n3 = itemArray.length;
                        for (n = 0; n < n3; ++n) {
                            item2 = itemArray[n];
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase("armour")) {
                        for (Item item2 : MillVillager.helmets) {
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        for (Item item2 : MillVillager.chestplates) {
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        for (Item item2 : MillVillager.legs) {
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        Item[] itemArray = MillVillager.boots;
                        int n4 = itemArray.length;
                        for (n = 0; n < n4; ++n) {
                            item2 = itemArray[n];
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase("pickaxes")) {
                        Item[] itemArray = MillVillager.pickaxes;
                        int n5 = itemArray.length;
                        for (n = 0; n < n5; ++n) {
                            item2 = itemArray[n];
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase("axes")) {
                        Item[] itemArray = MillVillager.axes;
                        int n6 = itemArray.length;
                        for (n = 0; n < n6; ++n) {
                            item2 = itemArray[n];
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase("shovels")) {
                        Item[] itemArray = MillVillager.shovels;
                        int n7 = itemArray.length;
                        for (n = 0; n < n7; ++n) {
                            item2 = itemArray[n];
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase("hoes")) {
                        Item[] itemArray = MillVillager.hoes;
                        int n8 = itemArray.length;
                        for (n = 0; n < n8; ++n) {
                            item2 = itemArray[n];
                            toolsNeeded.add(new InvItem(item2, 0));
                        }
                        continue;
                    }
                    MLN.error(null, "Unknown tool class found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("defaultweapon")) {
                    if (Goods.goodsName.containsKey(value.toLowerCase())) {
                        InvItem invItem;
                        v.startingWeapon = invItem = Goods.goodsName.get(value.toLowerCase());
                        continue;
                    }
                    MLN.error(null, "Unknown default weapon found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("bringbackhomegood")) {
                    if (Goods.goodsName.containsKey(value.toLowerCase())) {
                        InvItem invItem = Goods.goodsName.get(value.toLowerCase());
                        bringBackHomeGoods.add(invItem);
                        continue;
                    }
                    MLN.error(null, "Unknown bring back home good found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("collectgood")) {
                    if (Goods.goodsName.containsKey(value.toLowerCase())) {
                        InvItem invItem = Goods.goodsName.get(value.toLowerCase());
                        collectGoods.add(invItem);
                        continue;
                    }
                    MLN.error(null, "Unknown collect good found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("gender")) {
                    if (value.equals("male")) {
                        v.gender = 1;
                        continue;
                    }
                    if (value.equals("female")) {
                        v.gender = 2;
                        continue;
                    }
                    MLN.error(null, "Unknown gender found when loading villager type " + file.getName() + ": " + value);
                    continue;
                }
                if (key.equals("baseattackstrength")) {
                    v.baseAttackStrength = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("experiencegiven")) {
                    v.expgiven = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("familynamelist")) {
                    v.familyNameList = value;
                    continue;
                }
                if (key.equals("firstnamelist")) {
                    v.firstNameList = value;
                    continue;
                }
                if (key.equals("malechild")) {
                    v.maleChild = value;
                    continue;
                }
                if (key.equals("femalechild")) {
                    v.femaleChild = value;
                    continue;
                }
                if (key.equals("tag")) {
                    v.tags.add(value.toLowerCase());
                    continue;
                }
                if (key.equals("baseheight")) {
                    v.baseScale = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("health")) {
                    v.health = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("hiringcost")) {
                    v.hireCost = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("chanceweight")) {
                    v.chanceWeight = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("clothes")) {
                    if (value.split(",").length < 2) {
                        MLN.error(null, "Two values are required for all clothes tag (cloth name, then texture file).");
                        continue;
                    }
                    String string = value.split(",")[0];
                    String textpath = value.split(",")[1];
                    if (!v.clothes.containsKey(string)) {
                        v.clothes.put(string, new ArrayList());
                    }
                    v.clothes.get(string).add(textpath);
                    continue;
                }
                MLN.error(null, "Could not understand parameter when loading villager type " + file.getName() + ": " + line);
            }
            reader.close();
            v.isChild = v.tags.contains(TAG_CHILD);
            v.isChief = v.tags.contains(TAG_CHIEF);
            v.isHeavyDrinker = v.tags.contains(TAG_DRINKER);
            v.isReligious = v.tags.contains(TAG_RELIGIOUS);
            v.canSell = v.tags.contains(TAG_SELLER);
            v.canMeditate = v.tags.contains(TAG_MEDITATES);
            v.canPerformSacrifices = v.tags.contains(TAG_SACRIFICES);
            v.visitor = v.tags.contains(TAG_VISITOR);
            v.helpInAttacks = v.tags.contains(TAG_HELPSINATTACKS);
            v.isLocalMerchant = v.tags.contains(TAG_LOCALMERCHANT);
            v.isForeignMerchant = v.tags.contains(TAG_FOREIGNMERCHANT);
            v.gathersApples = v.tags.contains(TAG_GATHERSAPPLES);
            v.hostile = v.tags.contains(TAG_HOSTILE);
            v.noleafclearing = v.tags.contains(TAG_NOLEAFCLEARING);
            v.isArcher = v.tags.contains(TAG_ARCHER);
            v.isRaider = v.tags.contains(TAG_RAIDER);
            v.noTeleport = v.tags.contains(TAG_NOTELEPORT);
            v.hideName = v.tags.contains(TAG_HIDENAME);
            v.showHealth = v.tags.contains(TAG_SHOWHEALTH);
            v.isDefensive = v.tags.contains(TAG_DEFENSIVE);
            v.noResurrect = v.tags.contains(TAG_NORESURRECT);
            v.textures = textures.toArray(new String[0]);
            v.toolsNeeded = toolsNeeded.toArray(new InvItem[0]);
            v.bringBackHomeGoods = bringBackHomeGoods.toArray(new InvItem[0]);
            v.collectGoods = collectGoods.toArray(new InvItem[0]);
            goals.add(Goal.sleep);
            if (v.toolsNeeded.length > 0) {
                boolean foundToolFetchingGoal = false;
                for (Goal g : goals) {
                    if (g != Goal.gettool) continue;
                    foundToolFetchingGoal = true;
                }
                if (!foundToolFetchingGoal) {
                    goals.add(Goal.gettool);
                }
            }
            v.goals = goals.toArray(new Goal[0]);
            if (v.health == -1) {
                v.health = v.helpInAttacks ? 40 : 30;
            }
            if (v.baseAttackStrength == -1) {
                v.baseAttackStrength = v.helpInAttacks ? 2 : 1;
            }
            for (InvItem item : v.foreignMerchantStock.keySet()) {
                if (!c.goodsByItem.containsKey(item)) {
                    MLN.warning(v, "Starting inv of foreign merchant countains non-tradeable good: " + item);
                    continue;
                }
                if (c.goodsByItem.get((Object)item).foreignMerchantPrice >= 1) continue;
                MLN.warning(v, "Starting inv of foreign merchant countains good with null tradeable price: " + item);
            }
            if (MLN.LogVillager >= 1) {
                MLN.major(v, "Loaded villager type: " + v.key + " " + v.helpInAttacks);
            }
            return v;
        }
        catch (Exception e) {
            MLN.printException(e);
            return null;
        }
    }

    public VillagerType(Culture c, String key) {
        this.culture = c;
        this.key = key;
    }

    @Override
    public int getChoiceWeight(EntityPlayer player) {
        return this.chanceWeight;
    }

    public String getEntityName() {
        if ("femaleasymmetrical".equals(this.model)) {
            return "ml_GenericAsimmFemale";
        }
        if ("femalesymmetrical".equals(this.model)) {
            return "ml_GenericSimmFemale";
        }
        if ("zombie".equals(this.model)) {
            return "ml_GenericZombie";
        }
        return "ml_GenericVillager";
    }

    public String getRandomClothTexture(String clothType) {
        if (this.clothes.containsKey(clothType)) {
            return this.clothes.get(clothType).get(MillCommonUtilities.randomInt(this.clothes.get(clothType).size()));
        }
        return null;
    }

    public String getRandomFamilyName() {
        return this.culture.getRandomNameFromList(this.familyNameList);
    }

    public String getTexture() {
        return this.textures[MillCommonUtilities.randomInt(this.textures.length)];
    }

    public boolean isClothValid(String clothType, String texture) {
        if (!this.clothes.containsKey(clothType)) {
            return false;
        }
        for (String s : this.clothes.get(clothType)) {
            if (!s.equals(texture)) continue;
            return true;
        }
        return false;
    }

    public boolean isTextureValid(String texture) {
        for (String s : this.textures) {
            if (!s.equals(texture)) continue;
            return true;
        }
        return false;
    }

    public void readVillagerTypeInfoPacket(ByteBufInputStream ds) throws IOException {
        this.name = StreamReadWrite.readNullableString((DataInput)ds);
        this.altkey = StreamReadWrite.readNullableString((DataInput)ds);
        this.altname = StreamReadWrite.readNullableString((DataInput)ds);
        this.model = StreamReadWrite.readNullableString((DataInput)ds);
        this.gender = ds.read();
    }

    public String toString() {
        return "VT: " + this.culture.key + "/" + this.key;
    }

    public void writeVillagerTypeInfo(DataOutput data) throws IOException {
        data.writeUTF(this.key);
        StreamReadWrite.writeNullableString(this.name, data);
        StreamReadWrite.writeNullableString(this.altkey, data);
        StreamReadWrite.writeNullableString(this.altname, data);
        StreamReadWrite.writeNullableString(this.model, data);
        data.write(this.gender);
    }
}

