/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.forge;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.forge.Mill;

public class MillEventController {
    @SubscribeEvent
    public void entityCreated(EntityJoinWorldEvent event) {
        if (Mill.startupError) {
            return;
        }
        if (event.entity instanceof EntityZombie || event.entity instanceof EntitySkeleton) {
            EntityMob mob = (EntityMob)event.entity;
            mob.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)mob, MillVillager.class, (double)mob.func_70689_ay(), true));
            try {
                EntityAITasks targetTasks = mob.field_70715_bh;
                targetTasks.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, MillVillager.class, 10, false));
            }
            catch (Exception e) {
                MLN.printException("Error when trying to make new mob " + mob + " target villagers:", e);
            }
        }
    }

    @SubscribeEvent
    public void worldLoaded(WorldEvent.Load event) {
        Mill.proxy.loadLanguages();
        if (Mill.displayMillenaireLocationError && !Mill.proxy.isTrueServer()) {
            Mill.proxy.sendLocalChat(Mill.proxy.getTheSinglePlayer(), '4', "ERREUR: Impossible de trouver le fichier de configuration " + Mill.proxy.getConfigFile().getAbsolutePath() + ". V\u00e9rifiez que le dossier millenaire est bien dans minecraft/mods/");
            Mill.proxy.sendLocalChat(Mill.proxy.getTheSinglePlayer(), '4', "ERROR: Could not find the config file at " + Mill.proxy.getConfigFile().getAbsolutePath() + ". Check that the millenaire directory is in minecraft/mods/");
            return;
        }
        if (!(event.world instanceof WorldServer)) {
            MLN.temp(event.world, "Loading new client world");
            Mill.clientWorld = new MillWorld(event.world);
        } else if (!(event.world instanceof WorldServerMulti)) {
            MLN.temp(event.world, "Loading new world");
            MillWorld newWorld = new MillWorld(event.world);
            Mill.serverWorlds.add(newWorld);
            newWorld.loadData();
        }
    }

    @SubscribeEvent
    public void worldSaved(WorldEvent.Save event) {
        if (Mill.startupError) {
            return;
        }
        if (event.world.func_72912_H().func_76076_i() != 0) {
            return;
        }
        if (!(event.world instanceof WorldServer)) {
            Mill.clientWorld.saveEverything();
        } else {
            for (MillWorld mw : Mill.serverWorlds) {
                if (mw.world != event.world) continue;
                mw.saveEverything();
            }
        }
    }

    @SubscribeEvent
    public void worldUnloaded(WorldEvent.Unload event) {
        if (Mill.startupError) {
            return;
        }
        if (event.world.func_72912_H().func_76076_i() != 0) {
            return;
        }
        if (!(event.world instanceof WorldServer)) {
            if (Mill.clientWorld.world == event.world) {
                Mill.clientWorld = null;
                MLN.temp(null, "Unloaded client world.");
            } else {
                MLN.temp(null, "Skipped unloading client world as it's not current world.");
            }
        } else {
            ArrayList<MillWorld> toDelete = new ArrayList<MillWorld>();
            for (MillWorld mw : Mill.serverWorlds) {
                if (mw.world != event.world) continue;
                toDelete.add(mw);
            }
            for (MillWorld mw : toDelete) {
                Mill.serverWorlds.remove(mw);
            }
        }
    }
}

