/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.ArrayList;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;

public class GoalChildBecomeAdult
extends Goal {
    public GoalChildBecomeAdult() {
        this.maxSimultaneousInBuilding = 1;
    }

    @Override
    public boolean allowRandomMoves() {
        return true;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws MLN.MillenaireException {
        if (villager.size < 20) {
            return null;
        }
        ArrayList<Point> possibleDest = new ArrayList<Point>();
        ArrayList<Point> possibleDestBuilding = new ArrayList<Point>();
        int maxPriority = 0;
        for (Building house : villager.getTownHall().getBuildings()) {
            if (house == null || house.equals(villager.getHouse()) || !house.isHouse() || !house.canChildMoveIn(villager.gender, villager.familyName) || house.location.priorityMoveIn < maxPriority || !this.validateDest(villager, house)) continue;
            if (house.location.priorityMoveIn > maxPriority) {
                possibleDest.clear();
                possibleDestBuilding.clear();
                maxPriority = house.location.priorityMoveIn;
            }
            possibleDest.add(house.getResManager().getSleepingPos());
            possibleDestBuilding.add(house.getPos());
        }
        if (possibleDest.size() > 0) {
            int rand = MillCommonUtilities.randomInt(possibleDest.size());
            return this.packDest((Point)possibleDest.get(rand), (Point)possibleDestBuilding.get(rand));
        }
        return null;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws MLN.MillenaireException {
        return this.getDestination(villager) != null;
    }

    @Override
    public boolean performAction(MillVillager villager) throws MLN.MillenaireException {
        Building house = villager.getGoalBuildingDest();
        if (house != null && house.canChildMoveIn(villager.gender, villager.familyName)) {
            if (MLN.LogChildren >= 1) {
                MLN.major(this, "Adding new adult to house of type " + house.location + ". Gender: " + villager.gender);
            }
            house.addAdult(villager);
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) {
        return 100;
    }
}

