/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal.leasure;

import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;

public class GoalGoPray
extends Goal {
    @Override
    public int actionDuration(MillVillager villager) throws Exception {
        return 30000;
    }

    @Override
    public boolean allowRandomMoves() {
        return false;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        Building temple;
        if (villager.canMeditate() && (temple = villager.getTownHall().getFirstBuildingWithTag("pujas")) != null) {
            return this.packDest(temple.getResManager().getCraftingPos(), temple);
        }
        if (villager.canPerformSacrifices() && (temple = villager.getTownHall().getFirstBuildingWithTag("sacrifices")) != null) {
            return this.packDest(temple.getResManager().getCraftingPos(), temple);
        }
        return this.packDest(villager.getTownHall().getRandomLocationWithTag("Praying"));
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        if (villager.hasPrayedToday && !villager.canMeditate() && !villager.canPerformSacrifices()) {
            return false;
        }
        Point p = villager.getTownHall().getRandomLocationWithTag("Praying");
        if (p == null) {
            return false;
        }
        return villager.getPos().distanceTo(p) > 5.0;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        villager.hasPrayedToday = true;
        return true;
    }

    @Override
    public int priority(MillVillager villager) {
        if (villager.canMeditate() || villager.canPerformSacrifices()) {
            return 200;
        }
        if (villager.isPriest()) {
            return MillCommonUtilities.randomInt(50) - 25;
        }
        return MillCommonUtilities.randomInt(20) - 18;
    }
}

