/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.EntityMillDecoration;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.building.BuildingPlan;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.network.ServerSender;

public class Goods {
    public static final List<InvItem> freeGoods = new ArrayList<InvItem>();
    public static final HashMap<String, InvItem> goodsName = new HashMap();
    public static final String BOUDIN = "boudin";
    public static final String TRIPES = "tripes";
    public static final String CALVA = "calva";
    public InvItem item;
    public String name;
    private final int sellingPrice;
    private final int buyingPrice;
    public int reservedQuantity;
    public int targetQuantity;
    public int foreignMerchantPrice;
    public String requiredTag;
    public boolean autoGenerate = false;
    public int minReputation;
    public String desc = null;

    public static void generateGoodsList() {
        File file = new File(Mill.proxy.getBaseDir(), "goods.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(file);
            writer.write("//Item key;item id;item meta;label (indicative only)" + MLN.EOL);
            writer.write("//This file is auto-generated and indicative only. Don't edit it." + MLN.EOL + MLN.EOL);
            ArrayList<String> names = new ArrayList<String>(goodsName.keySet());
            Collections.sort(names);
            for (String name : names) {
                InvItem iv = goodsName.get(name);
                writer.write(name + ";" + Item.field_150901_e.func_148750_c((Object)iv.item) + ";" + iv.meta + ";" + iv.getName() + MLN.EOL);
            }
            writer.close();
        }
        catch (Exception e) {
            MLN.error(null, "Error when writing goods list: ");
            MLN.printException(e);
        }
    }

    private static void loadGoodList(File file) {
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                try {
                    String[] temp;
                    if (line.trim().length() <= 0 || line.startsWith("//") || (temp = line.trim().split(";")).length <= 2) continue;
                    Item item = (Item)Item.field_150901_e.func_82594_a(temp[1]);
                    if (item != null) {
                        goodsName.put(temp[0], new InvItem(item, Integer.parseInt(temp[2])));
                        continue;
                    }
                    Block block = (Block)Block.field_149771_c.func_82594_a(temp[1]);
                    if (block == null) {
                        MLN.error(null, "Could not load good: " + temp[1]);
                        continue;
                    }
                    if (Item.func_150898_a((Block)block) == null) {
                        MLN.error(null, "Tried to create good from block with no item: " + line);
                        continue;
                    }
                    goodsName.put(temp[0], new InvItem(block, Integer.parseInt(temp[2])));
                }
                catch (Exception e) {
                    MLN.printException("Exception while reading line: " + line, e);
                }
            }
        }
        catch (IOException e) {
            MLN.printException(e);
            return;
        }
    }

    public static void loadGoods() {
        for (File loadDir : Mill.loadingDirs) {
            File mainList = new File(loadDir, "itemlist.txt");
            if (!mainList.exists()) continue;
            Goods.loadGoodList(mainList);
        }
        Goods.generateGoodsList();
        try {
            goodsName.put("anyenchanted", new InvItem(1));
            goodsName.put("enchantedsword", new InvItem(2));
        }
        catch (MLN.MillenaireException e) {
            MLN.printException(e);
        }
    }

    public Goods(InvItem iv) {
        this.item = iv;
        this.name = this.item.getName();
        this.sellingPrice = 0;
        this.buyingPrice = 1;
        this.requiredTag = null;
    }

    public Goods(String name, InvItem item, int sellingPrice, int buyingPrice, int reservedQuantity, int targetQuantity, int foreignMerchantPrice, boolean autoGenerate, String tag, int minReputation, String desc) {
        this.name = name;
        this.item = item;
        this.sellingPrice = sellingPrice;
        this.buyingPrice = buyingPrice;
        this.requiredTag = tag;
        this.autoGenerate = autoGenerate;
        this.reservedQuantity = reservedQuantity;
        this.targetQuantity = targetQuantity;
        this.foreignMerchantPrice = foreignMerchantPrice;
        this.minReputation = minReputation;
        this.desc = desc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Goods)) {
            return false;
        }
        Goods g = (Goods)obj;
        return g.item.equals(obj);
    }

    public int getBasicBuyingPrice(Building shop) {
        if (shop == null) {
            return this.buyingPrice;
        }
        if (shop.getTownHall().villageType.buyingPrices.containsKey(this.item)) {
            return shop.getTownHall().villageType.buyingPrices.get(this.item);
        }
        return this.buyingPrice;
    }

    public int getBasicSellingPrice(Building shop) {
        if (shop == null) {
            return this.sellingPrice;
        }
        if (shop.getTownHall().villageType.sellingPrices.containsKey(this.item)) {
            return shop.getTownHall().villageType.sellingPrices.get(this.item);
        }
        return this.sellingPrice;
    }

    public int getCalculatedBuyingPrice(Building shop, EntityPlayer player) {
        if (shop == null) {
            return this.buyingPrice;
        }
        return shop.getBuyingPrice(this, player);
    }

    public int getCalculatedSellingPrice(Building shop, EntityPlayer player) {
        if (shop == null) {
            return this.sellingPrice;
        }
        return shop.getSellingPrice(this, player);
    }

    public int getCalculatedSellingPrice(MillVillager merchant) {
        if (merchant == null) {
            return this.foreignMerchantPrice;
        }
        if (merchant.merchantSells.containsKey(this)) {
            return merchant.merchantSells.get(this);
        }
        return this.foreignMerchantPrice;
    }

    public String getName() {
        return Mill.proxy.getItemName(this.item.getItem(), this.item.meta);
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public String toString() {
        return "Goods@" + this.item.getItemStack().func_77977_a();
    }

    static {
        try {
            freeGoods.add(new InvItem(Blocks.field_150346_d, 0));
            freeGoods.add(new InvItem(Mill.earth_decoration, 1));
            freeGoods.add(new InvItem(Blocks.field_150355_j, 0));
            freeGoods.add(new InvItem(Blocks.field_150345_g, 0));
            freeGoods.add(new InvItem((Block)Blocks.field_150327_N, 0));
            freeGoods.add(new InvItem((Block)Blocks.field_150328_O, 0));
            freeGoods.add(new InvItem((Block)Blocks.field_150329_H, 0));
            freeGoods.add(new InvItem(Blocks.field_150435_aG, 0));
            freeGoods.add(new InvItem(Blocks.field_150382_bo, 0));
            freeGoods.add(new InvItem((Block)Blocks.field_150362_t, -1));
            freeGoods.add(new InvItem(Blocks.field_150345_g, -1));
            freeGoods.add(new InvItem(Blocks.field_150414_aQ, 0));
            freeGoods.add(new InvItem((Block)Mill.path, -1));
            freeGoods.add(new InvItem((Block)Mill.pathSlab, -1));
        }
        catch (MLN.MillenaireException e) {
            MLN.printException(e);
        }
    }

    public static class ItemText
    extends Item {
        public final String iconName;

        public ItemText(String iconName) {
            this.func_77637_a(Mill.tabMillenaire);
            this.iconName = iconName;
            this.func_111206_d("millenaire:" + iconName);
        }
    }

    public static class ItemTapestry
    extends ItemText {
        public int type;

        public ItemTapestry(String iconName, int type) {
            super(iconName);
            this.type = type;
            this.func_77637_a(Mill.tabMillenaire);
        }

        public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float par8, float par9, float par10) {
            if (side == 0) {
                return false;
            }
            if (side == 1) {
                return false;
            }
            int orientation = Direction.field_71579_d[side];
            EntityMillDecoration entitypainting = new EntityMillDecoration(world, i, j, k, orientation, this.type, false);
            if (entitypainting.func_70518_d()) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)entitypainting);
                }
                --itemstack.field_77994_a;
            }
            return true;
        }
    }

    public static class ItemSummoningWand
    extends ItemText {
        public ItemSummoningWand(String iconName) {
            super(iconName);
            this.func_77637_a(Mill.tabMillenaire);
        }

        public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, float hitX, float hitY, float hitZ) {
            Point pos = new Point(i, j, k);
            Block block = world.func_147439_a(i, j, k);
            if (block == Blocks.field_150472_an) {
                ClientSender.importBuilding(entityplayer, pos);
                return true;
            }
            if (block == Mill.lockedChest) {
                return false;
            }
            ClientSender.summoningWandUse(entityplayer, pos);
            return true;
        }
    }

    public static class ItemNegationWand
    extends ItemText {
        public ItemNegationWand(String iconName) {
            super(iconName);
            this.func_77637_a(Mill.tabMillenaire);
        }

        public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int l, float hitX, float hitY, float hitZ) {
            Point pos = new Point(x, y, z);
            Block block = world.func_147439_a(x, y, z);
            if (block == Blocks.field_150472_an && world.field_72995_K) {
                BuildingPlan.exportBuilding(entityplayer, world, pos);
                return true;
            }
            if (world.field_72995_K) {
                return false;
            }
            MillWorld mw = Mill.getMillWorld(world);
            for (int i = 0; i < 2; ++i) {
                MillCommonUtilities.VillageList list = i == 0 ? mw.loneBuildingsList : mw.villagesList;
                for (int j = 0; j < list.names.size(); ++j) {
                    Building th;
                    Point p = list.pos.get(j);
                    int distance = MathHelper.func_76128_c((double)p.horizontalDistanceTo(pos));
                    if (distance > 30 || (th = mw.getBuilding(p)) == null || !th.isTownhall) continue;
                    if (th.chestLocked) {
                        ServerSender.sendTranslatedSentence(entityplayer, '6', "negationwand.villagelocked", th.villageType.name);
                        return true;
                    }
                    ServerSender.displayNegationWandGUI(entityplayer, th);
                }
            }
            return false;
        }
    }

    public static class ItemMillenaireSword
    extends ItemSword
    implements IItemInitialEnchantmens {
        float criticalChance;
        int criticalMultiple;
        public final String iconName;
        boolean knockback;

        public ItemMillenaireSword(String iconName, Item.ToolMaterial material, float criticalChance, int criticalMultiple, boolean knockback) {
            super(material);
            this.criticalChance = criticalChance;
            this.criticalMultiple = criticalMultiple;
            this.knockback = knockback;
            this.iconName = iconName;
            this.func_77637_a(Mill.tabMillenaire);
        }

        @Override
        public void applyEnchantments(ItemStack stack) {
            if (this.knockback && EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)stack) == 0) {
                stack.func_77966_a(Enchantment.field_77337_m, 2);
            }
        }

        public void func_77622_d(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
            this.applyEnchantments(stack);
        }

        public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
            this.applyEnchantments(par1ItemStack);
            return super.func_77648_a(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
        }

        public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
            this.applyEnchantments(stack);
            return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }

        public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
            this.applyEnchantments(stack);
            return super.onLeftClickEntity(stack, player, entity);
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.field_77791_bV = MillCommonUtilities.getIcon(iconRegister, this.iconName);
        }
    }

    public static class ItemMillenaireShovel
    extends ItemSpade {
        public final String iconName;

        public ItemMillenaireShovel(String iconName, Item.ToolMaterial material) {
            super(material);
            this.iconName = iconName;
            this.func_77637_a(Mill.tabMillenaire);
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.field_77791_bV = MillCommonUtilities.getIcon(iconRegister, this.iconName);
        }
    }

    public static class ItemMillenairePickaxe
    extends ItemPickaxe {
        public final String iconName;

        public ItemMillenairePickaxe(String iconName, Item.ToolMaterial material) {
            super(material);
            this.iconName = iconName;
            this.func_77637_a(Mill.tabMillenaire);
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.field_77791_bV = MillCommonUtilities.getIcon(iconRegister, this.iconName);
        }
    }

    public static class ItemMillenaireHoe
    extends ItemHoe {
        public final String iconName;

        public ItemMillenaireHoe(String iconName, Item.ToolMaterial material) {
            super(material);
            this.func_77637_a(Mill.tabMillenaire);
            this.iconName = iconName;
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.field_77791_bV = MillCommonUtilities.getIcon(iconRegister, this.iconName);
        }
    }

    public static class ItemMillenaireBow
    extends ItemBow {
        public float speedFactor = 1.0f;
        public float damageBonus = 0.0f;
        public int iconPos;
        public final String[] iconNames;
        public IIcon[] icons;

        public ItemMillenaireBow(float speedFactor, float damageBonus, String ... iconNames) {
            this.speedFactor = speedFactor;
            this.damageBonus = damageBonus;
            this.iconNames = iconNames;
            this.func_77637_a(Mill.tabMillenaire);
        }

        public IIcon func_77617_a(int par1) {
            return this.icons[this.iconPos];
        }

        public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
            boolean var5;
            int var6 = this.func_77626_a(par1ItemStack) - par4;
            ArrowLooseEvent event = new ArrowLooseEvent(par3EntityPlayer, par1ItemStack, var6);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            var6 = event.charge;
            boolean bl = var5 = par3EntityPlayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)par1ItemStack) > 0;
            if (var5 || par3EntityPlayer.field_71071_by.func_146028_b(Items.field_151032_g)) {
                int var10;
                int var9;
                float var7 = (float)var6 / 20.0f;
                if ((double)(var7 = (var7 * var7 + var7 * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                if (var7 > 1.0f) {
                    var7 = 1.0f;
                }
                EntityArrow var8 = new EntityArrow(par2World, (EntityLivingBase)par3EntityPlayer, var7 * 2.0f);
                if (var7 == 1.0f) {
                    var8.func_70243_d(true);
                }
                if ((var9 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)par1ItemStack)) > 0) {
                    var8.func_70239_b(var8.func_70242_d() + (double)var9 * 0.5 + 0.5);
                }
                if ((var10 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)par1ItemStack)) > 0) {
                    var8.func_70240_a(var10);
                }
                if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)par1ItemStack) > 0) {
                    var8.func_70015_d(100);
                }
                par1ItemStack.func_77972_a(1, (EntityLivingBase)par3EntityPlayer);
                par2World.func_72956_a((Entity)par3EntityPlayer, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + var7 * 0.5f);
                if (var5) {
                    var8.field_70251_a = 2;
                } else {
                    par3EntityPlayer.field_71071_by.func_146026_a(Items.field_151032_g);
                }
                var8.field_70159_w *= (double)this.speedFactor;
                var8.field_70181_x *= (double)this.speedFactor;
                var8.field_70179_y *= (double)this.speedFactor;
                var8.func_70239_b(var8.func_70242_d() + (double)this.damageBonus);
                if (!par2World.field_72995_K) {
                    par2World.func_72838_d((Entity)var8);
                }
            }
        }

        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            Mill.proxy.updateBowIcon(this, entityplayer);
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.field_77791_bV = MillCommonUtilities.getIcon(iconRegister, this.iconNames[0]);
            this.icons = new IIcon[this.iconNames.length];
            for (int i = 0; i < this.iconNames.length; ++i) {
                this.icons[i] = MillCommonUtilities.getIcon(iconRegister, this.iconNames[i]);
            }
        }

        public void setBowIcon(int pos) {
            this.iconPos = pos;
        }
    }

    public static class ItemMillenaireAxe
    extends ItemAxe {
        public final String iconName;

        public ItemMillenaireAxe(String iconName, Item.ToolMaterial material) {
            super(material);
            this.iconName = iconName;
            this.func_77637_a(Mill.tabMillenaire);
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.field_77791_bV = MillCommonUtilities.getIcon(iconRegister, this.iconName);
        }
    }

    public static class ItemMillenaireArmour
    extends ItemArmor {
        private static final ResourceLocation norman1 = new ResourceLocation("millenaire", "textures/models/armor/ML_norman_1.png");
        private static final ResourceLocation norman2 = new ResourceLocation("millenaire", "textures/models/armor/ML_norman_2.png");
        private static final ResourceLocation japaneseGuard1 = new ResourceLocation("millenaire", "textures/models/armor/ML_japanese_guard_1.png");
        private static final ResourceLocation japaneseGuard2 = new ResourceLocation("millenaire", "textures/models/armor/ML_japanese_guard_2.png");
        private static final ResourceLocation japaneseWarriorBlue1 = new ResourceLocation("millenaire", "textures/models/armor/ML_japanese_warrior_blue_1.png");
        private static final ResourceLocation japaneseWarriorBlue2 = new ResourceLocation("millenaire", "textures/models/armor/ML_japanese_warrior_blue_2.png");
        private static final ResourceLocation japaneseWarriorRed1 = new ResourceLocation("millenaire", "textures/models/armor/ML_japanese_warrior_red_1.png");
        private static final ResourceLocation japaneseWarriorRed2 = new ResourceLocation("millenaire", "textures/models/armor/ML_japanese_warrior_red_2.png");
        private static final ResourceLocation byzantine1 = new ResourceLocation("millenaire", "textures/models/armor/ML_byzantine_1.png");
        private static final ResourceLocation byzantine2 = new ResourceLocation("millenaire", "textures/models/armor/ML_byzantine_2.png");
        public final String iconName;

        public ItemMillenaireArmour(String iconName, ItemArmor.ArmorMaterial material, int armourId, int type) {
            super(material, armourId, type);
            this.iconName = iconName;
            this.func_77637_a(Mill.tabMillenaire);
        }

        public String getArmorTexture(ItemStack par1, Entity entity, int slot, String type) {
            if (par1.func_77973_b() == Mill.normanHelmet || par1.func_77973_b() == Mill.normanPlate || par1.func_77973_b() == Mill.normanBoots) {
                return norman1.toString();
            }
            if (par1.func_77973_b() == Mill.normanLegs) {
                return norman2.toString();
            }
            if (par1.func_77973_b() == Mill.japaneseGuardHelmet || par1.func_77973_b() == Mill.japaneseGuardPlate || par1.func_77973_b() == Mill.japaneseGuardBoots) {
                return japaneseGuard1.toString();
            }
            if (par1.func_77973_b() == Mill.japaneseGuardLegs) {
                return japaneseGuard2.toString();
            }
            if (par1.func_77973_b() == Mill.japaneseWarriorBlueHelmet || par1.func_77973_b() == Mill.japaneseWarriorBluePlate || par1.func_77973_b() == Mill.japaneseWarriorBlueBoots) {
                return japaneseWarriorBlue1.toString();
            }
            if (par1.func_77973_b() == Mill.japaneseWarriorBlueLegs) {
                return japaneseWarriorBlue2.toString();
            }
            if (par1.func_77973_b() == Mill.japaneseWarriorRedHelmet || par1.func_77973_b() == Mill.japaneseWarriorRedPlate || par1.func_77973_b() == Mill.japaneseWarriorRedBoots) {
                return japaneseWarriorRed1.toString();
            }
            if (par1.func_77973_b() == Mill.japaneseWarriorRedLegs) {
                return japaneseWarriorRed2.toString();
            }
            if (par1.func_77973_b() == Mill.byzantineHelmet || par1.func_77973_b() == Mill.byzantinePlate || par1.func_77973_b() == Mill.byzantineBoots) {
                return byzantine1.toString();
            }
            if (par1.func_77973_b() == Mill.byzantineLegs) {
                return byzantine2.toString();
            }
            return norman1.toString();
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.field_77791_bV = MillCommonUtilities.getIcon(iconRegister, this.iconName);
        }
    }

    public static class ItemMayanQuestCrown
    extends ItemArmor
    implements IItemInitialEnchantmens {
        private static final ResourceLocation mayan1 = new ResourceLocation("millenaire", "textures/models/armor/ML_mayan_quest_1.png");
        public final String iconName;

        public ItemMayanQuestCrown(String iconName, int armourId, int type) {
            super(ItemArmor.ArmorMaterial.DIAMOND, armourId, type);
            this.func_77656_e(0);
            this.iconName = iconName;
            this.func_77637_a(Mill.tabMillenaire);
        }

        @Override
        public void applyEnchantments(ItemStack stack) {
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77340_h.field_77352_x, (ItemStack)stack) == 0) {
                stack.func_77966_a(Enchantment.field_77340_h, 3);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77341_i.field_77352_x, (ItemStack)stack) == 0) {
                stack.func_77966_a(Enchantment.field_77341_i, 1);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77332_c.field_77352_x, (ItemStack)stack) == 0) {
                stack.func_77966_a(Enchantment.field_77332_c, 4);
            }
        }

        public String getArmorTexture(ItemStack par1, Entity entity, int slot, String type) {
            return mayan1.toString();
        }

        public boolean func_77648_a(ItemStack stack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
            this.applyEnchantments(stack);
            return super.func_77648_a(stack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
        }

        public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
            this.applyEnchantments(stack);
            return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }

        public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
            this.applyEnchantments(par1ItemStack);
            super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.field_77791_bV = MillCommonUtilities.getIcon(iconRegister, this.iconName);
        }
    }

    public static class ItemClothes
    extends Item {
        public final String[] iconNames;
        public IIcon[] icons = null;

        public ItemClothes(String ... iconNames) {
            this.func_77627_a(true);
            this.func_77656_e(0);
            this.iconNames = iconNames;
            this.func_77637_a(Mill.tabMillenaire);
        }

        public String getClothName(int meta) {
            if (meta == 0) {
                return "clothes_byz_wool";
            }
            return "clothes_byz_silk";
        }

        public int getClothPriority(int meta) {
            if (meta == 0) {
                return 1;
            }
            return 2;
        }

        public IIcon func_77617_a(int meta) {
            if (meta < this.iconNames.length) {
                return this.icons[meta];
            }
            return this.icons[0];
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
            for (int var4 = 0; var4 < 2; ++var4) {
                par3List.add(new ItemStack(item, 1, var4));
            }
        }

        public String func_77667_c(ItemStack par1ItemStack) {
            int meta = MathHelper.func_76125_a((int)par1ItemStack.func_77960_j(), (int)0, (int)15);
            return "item." + this.getClothName(meta);
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.icons = new IIcon[this.iconNames.length];
            for (int i = 0; i < this.iconNames.length; ++i) {
                this.icons[i] = MillCommonUtilities.getIcon(iconRegister, this.iconNames[i]);
            }
            this.field_77791_bV = MillCommonUtilities.getIcon(iconRegister, this.iconNames[0]);
        }
    }

    public static class ItemBrickMould
    extends ItemText {
        public ItemBrickMould(String iconName) {
            super(iconName);
            this.func_77637_a(Mill.tabMillenaire);
        }

        public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, float hitX, float hitY, float hitZ) {
            if (world.func_147439_a(i, j, k) == Blocks.field_150433_aE) {
                l = 0;
            } else {
                if (l == 0) {
                    --j;
                }
                if (l == 1) {
                    ++j;
                }
                if (l == 2) {
                    --k;
                }
                if (l == 3) {
                    ++k;
                }
                if (l == 4) {
                    --i;
                }
                if (l == 5) {
                    ++i;
                }
            }
            if (world.func_147439_a(i, j, k) != Blocks.field_150350_a) {
                return false;
            }
            if (MillCommonUtilities.countChestItems((IInventory)entityplayer.field_71071_by, Blocks.field_150346_d, 0) == 0 || MillCommonUtilities.countChestItems((IInventory)entityplayer.field_71071_by, (Block)Blocks.field_150354_m, 0) == 0) {
                if (!world.field_72995_K) {
                    ServerSender.sendTranslatedSentence(entityplayer, 'f', "ui.brickinstructions", new String[0]);
                }
                return false;
            }
            MillCommonUtilities.getItemsFromChest((IInventory)entityplayer.field_71071_by, Blocks.field_150346_d, 0, 1);
            MillCommonUtilities.getItemsFromChest((IInventory)entityplayer.field_71071_by, (Block)Blocks.field_150354_m, 0, 1);
            MillCommonUtilities.setBlockAndMetadata(world, i, j, k, Mill.earth_decoration, 0, true, false);
            itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
            return false;
        }
    }

    public static class ItemAmuletYddrasil
    extends Item {
        public final String baseIconName;

        public ItemAmuletYddrasil(String iconName) {
            this.func_77637_a(Mill.tabMillenaire);
            this.baseIconName = iconName;
        }

        public void func_94581_a(IIconRegister iconRegister) {
            Mill.proxy.declareAmuletTextures(iconRegister);
            this.field_77791_bV = iconRegister.func_94245_a("millenaire:" + this.baseIconName + MLN.getTextSuffix(iconRegister));
        }
    }

    public static class ItemAmuletVishnu
    extends Item {
        public final String baseIconName;

        public ItemAmuletVishnu(String iconName) {
            this.func_77637_a(Mill.tabMillenaire);
            this.baseIconName = iconName;
        }

        public void func_94581_a(IIconRegister iconRegister) {
            Mill.proxy.declareAmuletTextures(iconRegister);
            this.field_77791_bV = iconRegister.func_94245_a("millenaire:" + this.baseIconName + MLN.getTextSuffix(iconRegister));
        }
    }

    public static class ItemAmuletSkollHati
    extends ItemText {
        public ItemAmuletSkollHati(String iconName) {
            super(iconName);
        }

        public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
            if (MLN.LogOther >= 3) {
                MLN.debug((Object)this, "Using skoll amulet.");
            }
            if (world.field_72995_K) {
                return itemstack;
            }
            long time = world.func_72820_D() + 24000L;
            if (time % 24000L > 11000L && time % 24000L < 23500L) {
                world.func_72877_b(time - time % 24000L - 500L);
            } else {
                world.func_72877_b(time - time % 24000L + 13000L);
            }
            if (!MLN.infiniteAmulet) {
                itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
            }
            return itemstack;
        }
    }

    public static class ItemAmuletAlchemist
    extends Item {
        public final String baseIconName;

        public ItemAmuletAlchemist(String iconName) {
            this.func_77637_a(Mill.tabMillenaire);
            this.baseIconName = iconName;
        }

        public void func_94581_a(IIconRegister iconRegister) {
            Mill.proxy.declareAmuletTextures(iconRegister);
            this.field_77791_bV = iconRegister.func_94245_a("millenaire:" + this.baseIconName + MLN.getTextSuffix(iconRegister));
        }
    }

    public static interface IItemInitialEnchantmens {
        public void applyEnchantments(ItemStack var1);
    }
}

