/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.common.ai.ChunkPositionSorter;
import pneumaticCraft.common.ai.DroneClaimManager;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.item.ItemPneumaticArmor;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSpawnParticle;
import pneumaticCraft.common.progwidgets.IBlockOrdered;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.common.util.ThreadedSorter;

public abstract class DroneAIBlockInteraction<Widget extends ProgWidgetAreaItemBase>
extends EntityAIBase {
    protected final IDroneBase drone;
    protected final Widget widget;
    private final IBlockOrdered.EnumOrder order;
    protected ChunkPosition curPos;
    private final List<ChunkPosition> area;
    protected final IBlockAccess worldCache;
    private final List<ChunkPosition> blacklist = new ArrayList<ChunkPosition>();
    private int curY;
    private int lastSuccessfulY;
    private int minY;
    private int maxY;
    private ThreadedSorter<ChunkPosition> sorter;
    private boolean aborted;
    protected boolean searching;
    private int searchIndex;
    private static final int LOOKUPS_PER_SEARCH_TICK = 30;
    private int totalActions;
    private int maxActions = -1;

    public DroneAIBlockInteraction(IDroneBase drone, Widget widget) {
        this.drone = drone;
        this.func_75248_a(63);
        this.widget = widget;
        this.order = widget instanceof IBlockOrdered ? ((IBlockOrdered)widget).getOrder() : IBlockOrdered.EnumOrder.CLOSEST;
        this.area = ((ProgWidgetAreaItemBase)widget).getCachedAreaList();
        this.worldCache = ProgWidgetAreaItemBase.getCache(this.area, drone.getWorld());
        if (this.area.size() > 0) {
            Iterator<ChunkPosition> iterator = this.area.iterator();
            ChunkPosition pos = iterator.next();
            this.minY = this.maxY = pos.field_151327_b;
            while (iterator.hasNext()) {
                pos = iterator.next();
                this.minY = Math.min(this.minY, pos.field_151327_b);
                this.maxY = Math.max(this.maxY, pos.field_151327_b);
            }
            if (this.order == IBlockOrdered.EnumOrder.HIGH_TO_LOW) {
                this.curY = this.maxY;
            } else if (this.order == IBlockOrdered.EnumOrder.LOW_TO_HIGH) {
                this.curY = this.minY;
            }
        }
    }

    public boolean func_75250_a() {
        if (this.aborted || this.maxActions >= 0 && this.totalActions >= this.maxActions) {
            return false;
        }
        if (!this.searching) {
            this.searching = true;
            this.searchIndex = 0;
            this.curPos = null;
            this.lastSuccessfulY = this.curY;
            if (this.sorter == null || this.sorter.isDone()) {
                this.sorter = new ThreadedSorter<ChunkPosition>(this.area, new ChunkPositionSorter(this.drone));
            }
            return true;
        }
        return false;
    }

    private void updateY() {
        this.searchIndex = 0;
        if (this.order == IBlockOrdered.EnumOrder.LOW_TO_HIGH) {
            if (++this.curY > this.maxY) {
                this.curY = this.minY;
            }
        } else if (this.order == IBlockOrdered.EnumOrder.HIGH_TO_LOW && --this.curY < this.minY) {
            this.curY = this.maxY;
        }
    }

    private boolean isYValid(int y) {
        return this.order == IBlockOrdered.EnumOrder.CLOSEST || y == this.curY;
    }

    public DroneAIBlockInteraction setMaxActions(int maxActions) {
        this.maxActions = maxActions;
        return this;
    }

    protected abstract boolean isValidPosition(ChunkPosition var1);

    protected abstract boolean doBlockInteraction(ChunkPosition var1, double var2);

    public boolean func_75253_b() {
        double dist;
        if (this.aborted) {
            return false;
        }
        if (this.searching) {
            if (!this.sorter.isDone()) {
                return true;
            }
            boolean firstRun = true;
            int searchedBlocks = 0;
            while (this.curPos == null && this.curY != this.lastSuccessfulY && this.order != IBlockOrdered.EnumOrder.CLOSEST || firstRun) {
                firstRun = false;
                while (!this.shouldAbort() && this.searchIndex < this.area.size()) {
                    ChunkPosition pos = this.area.get(this.searchIndex);
                    if (!(!this.isYValid(pos.field_151327_b) || this.blacklist.contains(pos) || this.respectClaims() && DroneClaimManager.getInstance(this.drone.getWorld()).isClaimed(pos))) {
                        this.indicateToListeningPlayers(pos);
                        if (this.isValidPosition(pos)) {
                            this.curPos = pos;
                            if (this.moveToPositions()) {
                                if (this.moveIntoBlock()) {
                                    if (this.drone.getPathNavigator().moveToXYZ(this.curPos.field_151329_a, (double)this.curPos.field_151327_b + 0.5, this.curPos.field_151328_c)) {
                                        this.searching = false;
                                        ++this.totalActions;
                                        if (this.respectClaims()) {
                                            DroneClaimManager.getInstance(this.drone.getWorld()).claim(pos);
                                        }
                                        this.blacklist.clear();
                                        return true;
                                    }
                                } else {
                                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                                        if (!this.drone.getPathNavigator().moveToXYZ(this.curPos.field_151329_a + dir.offsetX, (double)(this.curPos.field_151327_b + dir.offsetY) + 0.5, this.curPos.field_151328_c + dir.offsetZ)) continue;
                                        this.searching = false;
                                        ++this.totalActions;
                                        if (this.respectClaims()) {
                                            DroneClaimManager.getInstance(this.drone.getWorld()).claim(pos);
                                        }
                                        this.blacklist.clear();
                                        return true;
                                    }
                                }
                                if (this.drone.getPathNavigator().isGoingToTeleport()) {
                                    this.searching = false;
                                    ++this.totalActions;
                                    if (this.respectClaims()) {
                                        DroneClaimManager.getInstance(this.drone.getWorld()).claim(pos);
                                    }
                                    this.blacklist.clear();
                                    return true;
                                }
                                this.drone.addDebugEntry("gui.progWidget.general.debug.cantNavigate", pos);
                            } else {
                                this.searching = false;
                                ++this.totalActions;
                                return true;
                            }
                        }
                        ++searchedBlocks;
                    }
                    ++this.searchIndex;
                    if (searchedBlocks < this.lookupsPerSearch()) continue;
                    return true;
                }
                if (this.curPos != null) continue;
                this.updateY();
            }
            if (!this.shouldAbort()) {
                this.addEndingDebugEntry();
            }
            return false;
        }
        Vec3 dronePos = this.drone.getPosition();
        double d = dist = this.curPos != null ? PneumaticCraftUtils.distBetween((double)this.curPos.field_151329_a + 0.5, (double)this.curPos.field_151327_b + 0.5, (double)this.curPos.field_151328_c + 0.5, dronePos.field_72450_a, dronePos.field_72448_b, dronePos.field_72449_c) : 0.0;
        if (this.curPos != null) {
            if (!this.moveToPositions()) {
                return this.doBlockInteraction(this.curPos, dist);
            }
            if (this.respectClaims()) {
                DroneClaimManager.getInstance(this.drone.getWorld()).claim(this.curPos);
            }
            int n = this.moveIntoBlock() ? 1 : 2;
            if (dist < (double)n) {
                return this.doBlockInteraction(this.curPos, dist);
            }
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }

    protected void addEndingDebugEntry() {
        this.drone.addDebugEntry("gui.progWidget.blockInteraction.debug.noBlocksValid");
    }

    protected int lookupsPerSearch() {
        return 30;
    }

    protected boolean respectClaims() {
        return false;
    }

    protected boolean moveIntoBlock() {
        return false;
    }

    protected boolean shouldAbort() {
        return this.aborted;
    }

    public void abort() {
        this.aborted = true;
    }

    protected boolean moveToPositions() {
        return true;
    }

    protected void indicateToListeningPlayers(ChunkPosition pos) {
        for (EntityPlayer player : this.drone.getWorld().field_73010_i) {
            if (player.func_82169_q(3) == null || player.func_82169_q(3).func_77973_b() != Itemss.pneumaticHelmet || ItemPneumaticArmor.getUpgrades(3, player.func_82169_q(3)) <= 0 || !(((IPressurizable)Itemss.pneumaticHelmet).getPressure(player.func_82169_q(3)) > 0.0f)) continue;
            NetworkHandler.sendTo(new PacketSpawnParticle("reddust", (double)pos.field_151329_a + 0.5, (double)pos.field_151327_b + 0.5, (double)pos.field_151328_c + 0.5, 0.0, 0.0, 0.0), (EntityPlayerMP)player);
        }
    }

    protected void addToBlacklist(ChunkPosition coord) {
        this.blacklist.add(coord);
        this.drone.sendWireframeToClient(coord.field_151329_a, coord.field_151327_b, coord.field_151328_c);
    }
}

