/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.common.ai.DroneAIImExBase;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICountWidget;
import pneumaticCraft.common.progwidgets.ILiquidFiltered;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.util.FluidUtils;

public class DroneAILiquidImport
extends DroneAIImExBase {
    public DroneAILiquidImport(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(ChunkPosition pos) {
        return this.emptyTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(ChunkPosition pos, double distToBlock) {
        return this.emptyTank(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean emptyTank(ChunkPosition pos, boolean simulate) {
        Fluid fluid;
        if (this.drone.getTank().getFluidAmount() == this.drone.getTank().getCapacity()) {
            this.drone.addDebugEntry("gui.progWidget.liquidImport.debug.fullDroneTank");
            this.abort();
            return false;
        }
        TileEntity te = this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        if (te instanceof IFluidHandler) {
            IFluidHandler tank = (IFluidHandler)te;
            for (int i = 0; i < 6; ++i) {
                int filledAmount;
                FluidStack importedFluid;
                if (!((ISidedWidget)((Object)this.widget)).getSides()[i] || (importedFluid = tank.drain(ForgeDirection.getOrientation((int)i), Integer.MAX_VALUE, false)) == null || !((ILiquidFiltered)((Object)this.widget)).isFluidValid(importedFluid.getFluid()) || (filledAmount = this.drone.getTank().fill(importedFluid, false)) <= 0) continue;
                if (((ICountWidget)((Object)this.widget)).useCount()) {
                    filledAmount = Math.min(filledAmount, this.getRemainingCount());
                }
                if (!simulate) {
                    this.decreaseCount(this.drone.getTank().fill(tank.drain(ForgeDirection.getOrientation((int)i), filledAmount, true), true));
                }
                return true;
            }
            this.drone.addDebugEntry("gui.progWidget.liquidImport.debug.emptiedToMax", pos);
        } else if ((!((ICountWidget)((Object)this.widget)).useCount() || this.getRemainingCount() >= 1000) && (fluid = FluidRegistry.lookupFluidForBlock((Block)this.drone.getWorld().func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c))) != null && ((ILiquidFiltered)((Object)this.widget)).isFluidValid(fluid) && this.drone.getTank().fill(new FluidStack(fluid, 1000), false) == 1000 && FluidUtils.isSourceBlock(this.drone.getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) {
            if (!simulate) {
                this.decreaseCount(1000);
                this.drone.getTank().fill(new FluidStack(fluid, 1000), true);
                this.drone.getWorld().func_147468_f(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            }
            return true;
        }
        return false;
    }
}

