/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.common.block.BlockPneumaticCraft;
import pneumaticCraft.common.tileentity.TileEntityPressureChamberValve;
import pneumaticCraft.proxy.CommonProxy;

public class BlockPressureChamberValve
extends BlockPneumaticCraft {
    private IIcon[] textures;

    public BlockPressureChamberValve(Material par2Material) {
        super(par2Material);
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityPressureChamberValve.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.textures = new IIcon[4];
        String s = "pneumaticcraft:pressureChamber/";
        this.textures[0] = register.func_94245_a(s + "valve");
        this.textures[1] = register.func_94245_a(s + "valve_formed");
        this.textures[2] = register.func_94245_a(s + "valve_side");
        this.textures[3] = register.func_94245_a(s + "center");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        boolean formed;
        TileEntityPressureChamberValve valve = (TileEntityPressureChamberValve)world.func_147438_o(x, y, z);
        boolean bl = formed = valve.accessoryValves != null && valve.accessoryValves.size() > 0;
        if ((world.func_72805_g(x, y, z) | 1) == (side | 1)) {
            return this.textures[formed ? 1 : 0];
        }
        return this.textures[formed ? 3 : 2];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 2 || side == 3 ? this.textures[0] : this.textures[2];
    }

    @Override
    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack iStack) {
        super.func_149689_a(par1World, par2, par3, par4, par5EntityLiving, iStack);
        TileEntityPressureChamberValve.checkIfProperlyFormed(par1World, par2, par3, par4);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && te instanceof TileEntityPressureChamberValve) {
            if (((TileEntityPressureChamberValve)te).multiBlockSize > 0) {
                player.openGui((Object)PneumaticCraft.instance, CommonProxy.EnumGuiId.PRESSURE_CHAMBER.ordinal(), world, x, y, z);
            } else if (((TileEntityPressureChamberValve)te).accessoryValves.size() > 0) {
                for (TileEntityPressureChamberValve valve : ((TileEntityPressureChamberValve)te).accessoryValves) {
                    if (valve.multiBlockSize <= 0) continue;
                    player.openGui((Object)PneumaticCraft.instance, CommonProxy.EnumGuiId.PRESSURE_CHAMBER.ordinal(), world, valve.field_145851_c, valve.field_145848_d, valve.field_145849_e);
                    break;
                }
            } else {
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.invalidateMultiBlock(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    private void invalidateMultiBlock(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPressureChamberValve && !world.field_72995_K) {
            if (((TileEntityPressureChamberValve)te).multiBlockSize > 0) {
                ((TileEntityPressureChamberValve)te).onMultiBlockBreak();
            } else if (((TileEntityPressureChamberValve)te).accessoryValves.size() > 0) {
                for (TileEntityPressureChamberValve valve : ((TileEntityPressureChamberValve)te).accessoryValves) {
                    if (valve.multiBlockSize <= 0) continue;
                    valve.onMultiBlockBreak();
                    break;
                }
            }
        }
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, int x, int y, int z, ForgeDirection face) {
        if (player.func_70093_af()) {
            return super.rotateBlock(world, player, x, y, z, face);
        }
        int newMeta = (world.func_72805_g(x, y, z) / 2 + 1) * 2;
        if (newMeta == 6) {
            newMeta = 0;
        }
        world.func_72921_c(x, y, z, newMeta, 3);
        this.invalidateMultiBlock(world, x, y, z);
        TileEntityPressureChamberValve.checkIfProperlyFormed(world, x, y, z);
        return true;
    }
}

