/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetImportExport;
import pneumaticCraft.common.progwidgets.ICountWidget;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;

public abstract class ProgWidgetInventoryBase
extends ProgWidgetAreaItemBase
implements ISidedWidget,
ICountWidget {
    private boolean[] accessingSides = new boolean[]{true, true, true, true, true, true};
    private boolean useCount;
    private int count = 1;

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean sideActive = false;
        for (boolean bool : this.accessingSides) {
            sideActive |= bool;
        }
        if (!sideActive) {
            curInfo.add("gui.progWidget.general.error.noSideActive");
        }
    }

    @Override
    public void setSides(boolean[] sides) {
        this.accessingSides = sides;
    }

    @Override
    public boolean[] getSides() {
        return this.accessingSides;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.isUsingSides()) {
            curTooltip.add("Accessing sides:");
        }
        curTooltip.add(this.getExtraStringInfo());
        if (this.useCount) {
            curTooltip.add("Using count (" + this.count + ")");
        }
    }

    protected boolean isUsingSides() {
        return true;
    }

    @Override
    public String getExtraStringInfo() {
        boolean allSides = true;
        boolean noSides = true;
        for (boolean bool : this.accessingSides) {
            if (bool) {
                noSides = false;
                continue;
            }
            allSides = false;
        }
        if (allSides) {
            return "All sides";
        }
        if (noSides) {
            return "No Sides";
        }
        String tip = "";
        block9: for (int i = 0; i < 6; ++i) {
            if (!this.accessingSides[i]) continue;
            switch (ForgeDirection.getOrientation((int)i)) {
                case UP: {
                    tip = tip + "top, ";
                    continue block9;
                }
                case DOWN: {
                    tip = tip + "bottom, ";
                    continue block9;
                }
                case NORTH: {
                    tip = tip + "north, ";
                    continue block9;
                }
                case SOUTH: {
                    tip = tip + "south, ";
                    continue block9;
                }
                case EAST: {
                    tip = tip + "east, ";
                    continue block9;
                }
                case WEST: {
                    tip = tip + "west, ";
                }
            }
        }
        return tip.substring(0, tip.length() - 2);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a(ForgeDirection.getOrientation((int)i).name(), this.accessingSides[i]);
        }
        tag.func_74757_a("useCount", this.useCount);
        tag.func_74768_a("count", this.count);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = tag.func_74767_n(ForgeDirection.getOrientation((int)i).name());
        }
        this.useCount = tag.func_74767_n("useCount");
        this.count = tag.func_74762_e("count");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetImportExport<ProgWidgetInventoryBase>(this, guiProgrammer);
    }
}

