/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.remote;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.client.gui.GuiRemoteEditor;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.common.remote.GlobalVariableManager;
import pneumaticCraft.lib.Log;

public abstract class ActionWidget<Widget extends IGuiWidget> {
    protected Widget widget;
    private String enableVariable = "";
    private ChunkPosition enablingValue = new ChunkPosition(0, 0, 0);

    public ActionWidget(Widget widget) {
        this.widget = widget;
    }

    public ActionWidget() {
    }

    public void readFromNBT(NBTTagCompound tag, int guiLeft, int guiTop) {
        this.enableVariable = tag.func_74779_i("enableVariable");
        this.enablingValue = tag.func_74764_b("enablingX") ? new ChunkPosition(tag.func_74762_e("enablingX"), tag.func_74762_e("enablingY"), tag.func_74762_e("enablingZ")) : new ChunkPosition(1, 0, 0);
    }

    public NBTTagCompound toNBT(int guiLeft, int guitTop) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", this.getId());
        tag.func_74778_a("enableVariable", this.enableVariable);
        tag.func_74768_a("enablingX", this.enablingValue.field_151329_a);
        tag.func_74768_a("enablingY", this.enablingValue.field_151327_b);
        tag.func_74768_a("enablingZ", this.enablingValue.field_151328_c);
        return tag;
    }

    public ActionWidget copy() {
        try {
            ActionWidget widget = (ActionWidget)this.getClass().newInstance();
            widget.readFromNBT(this.toNBT(0, 0), 0, 0);
            return widget;
        }
        catch (Exception e) {
            Log.error("Error occured when trying to copy an " + this.getId() + " action widget.");
            e.printStackTrace();
            return null;
        }
    }

    public Widget getWidget() {
        return this.widget;
    }

    public abstract void setWidgetPos(int var1, int var2);

    public abstract String getId();

    public GuiScreen getGui(GuiRemoteEditor guiRemote) {
        return null;
    }

    public void setEnableVariable(String varName) {
        this.enableVariable = varName;
    }

    public String getEnableVariable() {
        return this.enableVariable;
    }

    public boolean isEnabled() {
        return this.enableVariable.equals("") || GlobalVariableManager.getInstance().getPos(this.enableVariable).equals((Object)this.enablingValue);
    }

    public void setEnablingValue(int x, int y, int z) {
        this.enablingValue = new ChunkPosition(x, y, z);
    }

    public ChunkPosition getEnablingValue() {
        return this.enablingValue;
    }
}

