/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.forestry;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.thirdparty.forestry.FarmablePlastic;

public class FarmLogicHelium
implements IFarmLogic {
    private final IFarmHousing housing;
    private IIcon icon;
    private final FarmablePlastic farmable = new FarmablePlastic(Blockss.heliumPlant);

    public FarmLogicHelium(IFarmHousing farmHousing) {
        this.housing = farmHousing;
    }

    public int getFertilizerConsumption() {
        return 5;
    }

    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    public boolean isAcceptedResource(ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof ItemBlock && Blocks.field_150424_aL == ((ItemBlock)itemstack.func_77973_b()).field_150939_a;
    }

    public boolean isAcceptedGermling(ItemStack itemstack) {
        return itemstack.func_77973_b() == Itemss.plasticPlant && itemstack.func_77960_j() == 11;
    }

    public Collection<ItemStack> collect() {
        ArrayList<ItemStack> col = new ArrayList<ItemStack>();
        int[] coords = this.housing.getCoords();
        int[] area = this.housing.getArea();
        int[] offset = this.housing.getOffset();
        AxisAlignedBB harvestBox = AxisAlignedBB.func_72330_a((double)(coords[0] + offset[0]), (double)(coords[1] + offset[1]), (double)(coords[2] + offset[2]), (double)(coords[0] + offset[0] + area[0]), (double)(coords[1] + offset[1] + area[1]), (double)(coords[2] + offset[2] + area[2]));
        List list = this.housing.getWorld().func_72872_a(EntityItem.class, harvestBox);
        for (EntityItem item : list) {
            ItemStack contained;
            if (item.field_70128_L || !this.isAcceptedGermling(contained = item.func_92059_d())) continue;
            col.add(contained.func_77946_l());
            item.func_70106_y();
        }
        return col;
    }

    public boolean cultivate(int x, int y, int z, ForgeDirection d, int extent) {
        int i;
        for (i = 0; i < extent; ++i) {
            if (!this.tryPlaceSoil(x + d.offsetX * i, y + d.offsetY * i - 2, z + d.offsetZ * i)) continue;
            return true;
        }
        for (i = 0; i < extent; ++i) {
            if (!this.manageCrops(x + d.offsetX * i, y + d.offsetY * i - 3, z + d.offsetZ * i)) continue;
            return true;
        }
        return false;
    }

    private boolean tryPlaceSoil(int x, int y, int z) {
        if (this.housing.getWorld().func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.housing.getWorld(), x, y, z) && this.housing.hasResources(new ItemStack[]{new ItemStack(Blocks.field_150424_aL)})) {
            this.housing.removeResources(new ItemStack[]{new ItemStack(Blocks.field_150424_aL)});
            this.housing.getWorld().func_147449_b(x, y, z, Blocks.field_150424_aL);
            return true;
        }
        return false;
    }

    private boolean manageCrops(int x, int y, int z) {
        if (this.housing.getWorld().func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.housing.getWorld(), x, y, z)) {
            return this.housing.plantGermling((IFarmable)this.farmable, this.housing.getWorld(), x, y, z);
        }
        return false;
    }

    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection d, int extent) {
        ArrayList<ICrop> crops = new ArrayList<ICrop>();
        for (int i = 0; i < extent; ++i) {
            ICrop crop = this.farmable.getCropAt(this.housing.getWorld(), x + d.offsetX * i, y + d.offsetY * i - 3, z + d.offsetZ * i);
            if (crop == null) continue;
            crops.add(crop);
        }
        return crops;
    }

    public IIcon getIcon() {
        if (this.icon == null) {
            ItemStack stack = new ItemStack(Itemss.plasticPlant, 1, 11);
            this.icon = stack.func_77954_c();
        }
        return this.icon;
    }

    public ResourceLocation getSpriteSheet() {
        return TextureMap.field_110576_c;
    }

    public String getName() {
        return new ItemStack(Itemss.plasticPlant, 1, 11).func_82833_r();
    }

    public IFarmLogic setManual(boolean manual) {
        return this;
    }
}

