/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.forestry;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FarmLogicWrapper
implements IFarmLogic {
    private final IFarmLogic logic;

    public FarmLogicWrapper(IFarmHousing housing) throws Throwable {
        this.logic = this.getFarmLogic(housing);
    }

    protected abstract IFarmLogic getFarmLogic(IFarmHousing var1) throws Throwable;

    protected Class<? extends IFarmLogic> getLogicClass(String name) throws Throwable {
        return Class.forName("forestry.farming.logic." + name);
    }

    public int getFertilizerConsumption() {
        return this.logic.getFertilizerConsumption();
    }

    public int getWaterConsumption(float hydrationModifier) {
        return this.logic.getWaterConsumption(hydrationModifier);
    }

    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.logic.isAcceptedResource(itemstack);
    }

    public boolean isAcceptedGermling(ItemStack itemstack) {
        return this.logic.isAcceptedGermling(itemstack);
    }

    public Collection<ItemStack> collect() {
        return this.logic.collect();
    }

    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        return this.logic.cultivate(x, y, z, direction, extent);
    }

    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        return this.logic.harvest(x, y, z, direction, extent);
    }

    public IIcon getIcon() {
        return this.logic.getIcon();
    }

    public ResourceLocation getSpriteSheet() {
        return this.logic.getSpriteSheet();
    }

    public String getName() {
        return this.logic.getName();
    }

    public IFarmLogic setManual(boolean manual) {
        return this.logic.setManual(manual);
    }
}

