/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.recipe.IThermopneumaticProcessingPlantRecipe;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.recipes.PneumaticRecipeRegistry;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;

public class TileEntityThermopneumaticProcessingPlant
extends TileEntityPneumaticBase
implements IFluidHandler,
IHeatExchanger,
IMinWorkingPressure,
IRedstoneControlled,
IInventory {
    @GuiSynced
    @DescSynced
    private final FluidTank inputTank = new FluidTank(16000);
    @GuiSynced
    @DescSynced
    private final FluidTank outputTank = new FluidTank(16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    @GuiSynced
    public int redstoneMode;
    @GuiSynced
    private int craftingProgress;
    @GuiSynced
    public boolean hasRecipe;
    @GuiSynced
    public float requiredPressure;
    @GuiSynced
    public double requiredTemperature;
    private final ItemStack[] inventory = new ItemStack[5];
    private static final int CRAFTING_TIME = 60;

    public TileEntityThermopneumaticProcessingPlant() {
        super(5.0f, 7.0f, 3000);
        this.heatExchanger.setThermalResistance(10.0);
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    @Override
    public boolean isConnectedTo(ForgeDirection dir) {
        return this.getRotation().getOpposite() != dir && dir != ForgeDirection.UP;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            IThermopneumaticProcessingPlantRecipe recipe = this.getValidRecipe();
            boolean bl = this.hasRecipe = recipe != null;
            if (this.hasRecipe) {
                this.requiredPressure = recipe.getRequiredPressure(this.inputTank.getFluid(), this.inventory[4]);
                this.requiredTemperature = recipe.getRequiredTemperature(this.inputTank.getFluid(), this.inventory[4]);
                if (this.redstoneAllows() && this.heatExchanger.getTemperature() >= this.requiredTemperature && this.getPressure(ForgeDirection.UNKNOWN) >= this.getMinWorkingPressure()) {
                    ++this.craftingProgress;
                    if (this.craftingProgress >= 60) {
                        this.outputTank.fill(recipe.getRecipeOutput(this.inputTank.getFluid(), this.inventory[4]).copy(), true);
                        recipe.useRecipeItems(this.inputTank.getFluid(), this.inventory[4]);
                        this.addAir(-recipe.airUsed(this.inputTank.getFluid(), this.inventory[4]), ForgeDirection.UNKNOWN);
                        this.heatExchanger.addHeat(-recipe.heatUsed(this.inputTank.getFluid(), this.inventory[4]));
                        if (this.inputTank.getFluid() != null && this.inputTank.getFluid().amount <= 0) {
                            this.inputTank.setFluid(null);
                        }
                        if (this.inventory[4] != null && this.inventory[4].field_77994_a <= 0) {
                            this.inventory[4] = null;
                        }
                        this.craftingProgress = 0;
                    }
                }
            } else {
                this.craftingProgress = 0;
                this.requiredTemperature = 273.0;
                this.requiredPressure = 0.0f;
            }
            if (this.getUpgrades(1) > 0) {
                this.autoExportLiquid();
            }
        }
    }

    private IThermopneumaticProcessingPlantRecipe getValidRecipe() {
        for (IThermopneumaticProcessingPlantRecipe recipe : PneumaticRecipeRegistry.getInstance().thermopneumaticProcessingPlantRecipes) {
            if (!recipe.isValidRecipe(this.inputTank.getFluid(), this.inventory[4])) continue;
            if (this.outputTank.getFluid() == null) {
                return recipe;
            }
            FluidStack output = recipe.getRecipeOutput(this.inputTank.getFluid(), this.inventory[4]);
            if (output.getFluid() != this.outputTank.getFluid().getFluid() || output.amount > this.outputTank.getCapacity() - this.outputTank.getFluidAmount()) continue;
            return recipe;
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.inputTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.outputTank.getFluid() != null && this.outputTank.getFluid().isFluidEqual(resource) ? this.outputTank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.outputTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.inputTank), new FluidTankInfo((IFluidTank)this.outputTank)};
    }

    @SideOnly(value=Side.CLIENT)
    public FluidTank getInputTank() {
        return this.inputTank;
    }

    @SideOnly(value=Side.CLIENT)
    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    @SideOnly(value=Side.CLIENT)
    public double getCraftingPercentage() {
        return (double)this.craftingProgress / 60.0;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        TileEntityThermopneumaticProcessingPlant.writeInventoryToNBT(tag, this.inventory);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74768_a("craftingProgress", this.craftingProgress);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.inputTank.writeToNBT(tankTag);
        tag.func_74782_a("inputTank", (NBTBase)tankTag);
        tankTag = new NBTTagCompound();
        this.outputTank.writeToNBT(tankTag);
        tag.func_74782_a("outputTank", (NBTBase)tankTag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        TileEntityThermopneumaticProcessingPlant.readInventoryFromNBT(tag, this.inventory);
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.craftingProgress = tag.func_74762_e("craftingProgress");
        this.inputTank.readFromNBT(tag.func_74775_l("inputTank"));
        this.outputTank.readFromNBT(tag.func_74775_l("outputTank"));
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        return this.heatExchanger;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return this.requiredPressure;
    }

    public String func_145825_b() {
        return Blockss.thermopneumaticProcessingPlant.func_149739_a();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_94041_b(int par1, ItemStack stack) {
        return par1 == 4 || stack != null && stack.func_77973_b() == Itemss.machineUpgrade;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.isGuiUseableByPlayer(p_70300_1_);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

