/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.api.universalSensor.IEventSensorSetting;
import pneumaticCraft.api.universalSensor.IPollSensorSetting;
import pneumaticCraft.api.universalSensor.ISensorSetting;
import pneumaticCraft.client.gui.GuiUniversalSensor;
import pneumaticCraft.client.render.RenderRangeLines;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.ItemGPSTool;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketRenderRangeLines;
import pneumaticCraft.common.sensor.SensorHandler;
import pneumaticCraft.common.thirdparty.ThirdPartyManager;
import pneumaticCraft.common.thirdparty.computercraft.LuaConstant;
import pneumaticCraft.common.thirdparty.computercraft.LuaMethod;
import pneumaticCraft.common.tileentity.IGUITextFieldSensitive;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRangeLineShower;
import pneumaticCraft.common.tileentity.IRedstoneControl;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;

public class TileEntityUniversalSensor
extends TileEntityPneumaticBase
implements IInventory,
IRangeLineShower,
IGUITextFieldSensitive,
IMinWorkingPressure,
IRedstoneControl {
    @DescSynced
    public boolean[] sidesConnected = new boolean[6];
    private ItemStack[] inventory = new ItemStack[5];
    public static final int UPGRADE_SLOT_1 = 0;
    public static final int UPGRADE_SLOT_4 = 3;
    public static final int INVENTORY_SIZE = 5;
    @GuiSynced
    private String sensorSetting = "";
    private int ticksExisted;
    public int redstoneStrength;
    private int eventTimer;
    public float dishRotation;
    public float oldDishRotation;
    public float dishSpeed;
    @GuiSynced
    public boolean invertedRedstone;
    @DescSynced
    public boolean isSensorActive;
    @GuiSynced
    private String sensorGuiText = "";
    private boolean requestPollPullEvent;
    private Set<ChunkPosition> positions;
    private int oldSensorRange;
    private final RenderRangeLines rangeLineRenderer = new RenderRangeLines(0x330000FF);
    private final List<IComputerAccess> attachedComputers = new ArrayList<IComputerAccess>();

    public TileEntityUniversalSensor() {
        super(5.0f, 7.0f, 5000);
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    @Override
    public void func_145845_h() {
        this.oldDishRotation = this.dishRotation;
        this.dishSpeed = this.isSensorActive ? Math.min(this.dishSpeed + 0.2f, 10.0f) : Math.max(this.dishSpeed - 0.2f, 0.0f);
        this.dishRotation += this.dishSpeed;
        if (this.field_145850_b.field_72995_K) {
            int sensorRange = this.getRange();
            if (this.oldSensorRange != sensorRange || this.oldSensorRange == 0) {
                this.oldSensorRange = sensorRange;
                if (!this.firstRun) {
                    this.rangeLineRenderer.resetRendering(sensorRange);
                }
            }
            this.rangeLineRenderer.update();
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticksExisted;
            ISensorSetting sensor = SensorHandler.instance().getSensorFromPath(this.sensorSetting);
            if (sensor != null && this.getPressure(ForgeDirection.UNKNOWN) > 0.5f) {
                this.isSensorActive = true;
                this.addAir(-1, ForgeDirection.UNKNOWN);
                if (sensor instanceof IPollSensorSetting) {
                    if (this.ticksExisted % ((IPollSensorSetting)sensor).getPollFrequency(this) == 0) {
                        int newRedstoneStrength = ((IPollSensorSetting)sensor).getRedstoneValue(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getRange(), this.sensorGuiText);
                        if (this.invertedRedstone) {
                            newRedstoneStrength = 15 - newRedstoneStrength;
                        }
                        if (newRedstoneStrength != this.redstoneStrength) {
                            this.redstoneStrength = newRedstoneStrength;
                            if (this.requestPollPullEvent) {
                                this.notifyComputers(this.redstoneStrength);
                            }
                            this.updateNeighbours();
                        }
                    }
                    this.eventTimer = 0;
                } else if (this.eventTimer > 0) {
                    --this.eventTimer;
                    if (this.eventTimer == 0 && this.redstoneStrength != (this.invertedRedstone ? 15 : 0)) {
                        this.redstoneStrength = this.invertedRedstone ? 15 : 0;
                        this.updateNeighbours();
                    }
                }
            } else {
                this.isSensorActive = false;
                if (this.redstoneStrength != (this.invertedRedstone ? 15 : 0)) {
                    this.redstoneStrength = this.invertedRedstone ? 15 : 0;
                    this.updateNeighbours();
                }
            }
        }
    }

    @Override
    public void showRangeLines() {
        if (this.field_145850_b.field_72995_K) {
            this.rangeLineRenderer.resetRendering(this.getRange());
        } else {
            NetworkHandler.sendToAllAround(new PacketRenderRangeLines(this), this.field_145850_b, 64.0 + (double)this.getRange());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRangeLines() {
        this.rangeLineRenderer.render();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.rangeLineRenderer.isCurrentlyRendering()) {
            return super.getRenderBoundingBox();
        }
        int range = this.getRange();
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + 1 + range), (double)(this.field_145848_d + 1 + range), (double)(this.field_145849_e + 1 + range));
    }

    public void onEvent(Event event) {
        ISensorSetting sensor = SensorHandler.instance().getSensorFromPath(this.sensorSetting);
        if (sensor != null && sensor instanceof IEventSensorSetting && this.getPressure(ForgeDirection.UNKNOWN) > 0.5f) {
            int newRedstoneStrength = ((IEventSensorSetting)sensor).emitRedstoneOnEvent(event, this, this.getRange(), this.sensorGuiText);
            if (newRedstoneStrength != 0) {
                this.eventTimer = ((IEventSensorSetting)sensor).getRedstonePulseLength();
            }
            if (this.invertedRedstone) {
                newRedstoneStrength = 15 - newRedstoneStrength;
            }
            if (this.eventTimer > 0 && ThirdPartyManager.computerCraftLoaded) {
                if (event instanceof PlayerInteractEvent) {
                    PlayerInteractEvent e = (PlayerInteractEvent)event;
                    this.notifyComputers(newRedstoneStrength, e.x, e.y, e.z);
                } else {
                    this.notifyComputers(newRedstoneStrength);
                }
            }
            if (newRedstoneStrength != this.redstoneStrength) {
                this.redstoneStrength = newRedstoneStrength;
                this.updateNeighbours();
            }
        }
    }

    public int getRange() {
        return this.getUpgrades(8, this.getUpgradeSlots()) + 2;
    }

    public void setSensorSetting(String sensorPath) {
        GuiScreen guiScreen;
        this.sensorSetting = sensorPath;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && (guiScreen = Minecraft.func_71410_x().field_71462_r) instanceof GuiUniversalSensor) {
            ((GuiUniversalSensor)guiScreen).updateButtons();
        }
    }

    private boolean setSensorSetting(ISensorSetting sensor) {
        if (this.areGivenUpgradesInserted(SensorHandler.instance().getRequiredStacksFromText(sensor.getSensorPath()))) {
            this.setSensorSetting(sensor.getSensorPath());
            return true;
        }
        return false;
    }

    public String getSensorSetting() {
        return this.sensorSetting;
    }

    @Override
    public void onGuiUpdate() {
        this.setSensorSetting(this.sensorSetting);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74778_a("sensorSetting", this.sensorSetting);
        tag.func_74757_a("invertedRedstone", this.invertedRedstone);
        tag.func_74776_a("dishSpeed", this.dishSpeed);
        tag.func_74778_a("sensorText", this.sensorGuiText);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setSensorSetting(tag.func_74779_i("sensorSetting"));
        this.invertedRedstone = tag.func_74767_n("invertedRedstone");
        this.dishSpeed = tag.func_74760_g("dishSpeed");
        this.sensorGuiText = tag.func_74779_i("sensorText");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.positions = TileEntityUniversalSensor.getGPSPositionsStatic(this, this.getRange());
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID >= 10 && buttonID % 10 == 0) {
            String[] directories = SensorHandler.instance().getDirectoriesAtLocation(this.getSensorSetting());
            if (buttonID / 10 <= directories.length) {
                if (this.getSensorSetting().equals("")) {
                    this.setSensorSetting(directories[buttonID / 10 - 1]);
                } else {
                    this.setSensorSetting(this.getSensorSetting() + "/" + directories[buttonID / 10 - 1]);
                }
            }
        } else if (buttonID == 1) {
            String[] folders = this.getSensorSetting().split("/");
            String newPath = this.getSensorSetting().replace(folders[folders.length - 1], "");
            if (newPath.endsWith("/")) {
                newPath = newPath.substring(0, newPath.length() - 1);
            }
            this.setSensorSetting(newPath);
        } else if (buttonID == 0) {
            this.invertedRedstone = !this.invertedRedstone;
            this.redstoneStrength = 15 - this.redstoneStrength;
            this.updateNeighbours();
        }
    }

    public boolean areGivenUpgradesInserted(ItemStack[] requiredStacks) {
        for (ItemStack requiredStack : requiredStacks) {
            if (!(requiredStack.func_77973_b() != Itemss.GPSTool ? this.getUpgrades(requiredStack.func_77960_j(), this.getUpgradeSlots()) <= 0 : this.getUpgrades(-1, this.getUpgradeSlots()) <= 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            this.sidesConnected[direction.ordinal()] = te instanceof IPneumaticMachine ? ((IPneumaticMachine)te).isConnectedTo(direction.getOpposite()) : false;
        }
    }

    @Override
    protected int getUpgrades(int upgradeDamage, int ... upgradeSlots) {
        int upgrades = 0;
        if (this instanceof IInventory) {
            TileEntityUniversalSensor inv = this;
            for (int i : upgradeSlots) {
                if (inv.func_70301_a(i) == null) continue;
                if (inv.func_70301_a(i).func_77973_b() == Itemss.machineUpgrade && inv.func_70301_a(i).func_77960_j() == upgradeDamage) {
                    upgrades += inv.func_70301_a((int)i).field_77994_a;
                    continue;
                }
                if (upgradeDamage != -1 || inv.func_70301_a(i).func_77973_b() != Itemss.GPSTool) continue;
                upgrades += inv.func_70301_a((int)i).field_77994_a;
            }
        }
        return upgrades;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        if (!(this.field_145850_b.field_72995_K || this.getSensorSetting().equals("") || this.areGivenUpgradesInserted(SensorHandler.instance().getRequiredStacksFromText(this.getSensorSetting())))) {
            this.setSensorSetting("");
        }
        this.positions = TileEntityUniversalSensor.getGPSPositionsStatic(this, this.getRange());
    }

    public Set<ChunkPosition> getGPSPositions() {
        return this.positions;
    }

    private static Set<ChunkPosition> getGPSPositionsStatic(TileEntityUniversalSensor teUs, int sensorRange) {
        ArrayList<ChunkPosition> gpsPositions = new ArrayList<ChunkPosition>();
        for (int i = 0; i <= 3; ++i) {
            ChunkPosition pos;
            ItemStack gps = teUs.func_70301_a(i);
            if (gps == null || gps.func_77973_b() != Itemss.GPSTool || (pos = ItemGPSTool.getGPSLocation(gps)) == null || Math.abs(pos.field_151329_a - teUs.field_145851_c) > sensorRange || Math.abs(pos.field_151327_b - teUs.field_145848_d) > sensorRange || Math.abs(pos.field_151328_c - teUs.field_145849_e) > sensorRange) continue;
            gpsPositions.add(pos);
        }
        if (gpsPositions.size() == 1) {
            return new HashSet<ChunkPosition>(gpsPositions);
        }
        if (gpsPositions.size() > 1) {
            int minX = Math.min(((ChunkPosition)gpsPositions.get((int)0)).field_151329_a, ((ChunkPosition)gpsPositions.get((int)1)).field_151329_a);
            int minY = Math.min(((ChunkPosition)gpsPositions.get((int)0)).field_151327_b, ((ChunkPosition)gpsPositions.get((int)1)).field_151327_b);
            int minZ = Math.min(((ChunkPosition)gpsPositions.get((int)0)).field_151328_c, ((ChunkPosition)gpsPositions.get((int)1)).field_151328_c);
            int maxX = Math.max(((ChunkPosition)gpsPositions.get((int)0)).field_151329_a, ((ChunkPosition)gpsPositions.get((int)1)).field_151329_a);
            int maxY = Math.max(((ChunkPosition)gpsPositions.get((int)0)).field_151327_b, ((ChunkPosition)gpsPositions.get((int)1)).field_151327_b);
            int maxZ = Math.max(((ChunkPosition)gpsPositions.get((int)0)).field_151328_c, ((ChunkPosition)gpsPositions.get((int)1)).field_151328_c);
            HashSet<ChunkPosition> positions = new HashSet<ChunkPosition>();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = Math.min(255, maxY); y >= minY && y >= 0; --y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        positions.add(new ChunkPosition(x, y, z));
                    }
                }
            }
            return positions;
        }
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return Blockss.universalSensor.func_149739_a();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.sensorGuiText = text;
        if (!this.field_145850_b.field_72995_K) {
            this.scheduleDescriptionPacket();
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.sensorGuiText;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public String getType() {
        return "universalSensor";
    }

    @Override
    public void addLuaMethods() {
        super.addLuaMethods();
        this.luaMethods.add(new LuaMethod("getSensorNames"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return SensorHandler.instance().getSensorNames();
                }
                throw new IllegalArgumentException("getSensorNames doesn't accept any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setSensor"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    ISensorSetting sensor = null;
                    sensor = args[0] instanceof String ? SensorHandler.instance().getSensorForName((String)args[0]) : SensorHandler.instance().getSensorByIndex(((Double)args[0]).intValue() - 1);
                    if (sensor != null) {
                        return new Object[]{TileEntityUniversalSensor.this.setSensorSetting(sensor)};
                    }
                    throw new IllegalArgumentException("Invalid sensor name/index: " + args[0]);
                }
                if (args.length == 0) {
                    TileEntityUniversalSensor.this.setSensorSetting("");
                    return new Object[]{true};
                }
                throw new IllegalArgumentException("setSensor needs one argument(a number as index, or a sensor name).");
            }
        });
        this.luaMethods.add(new LuaMethod("getSensor"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    Object[] objectArray;
                    ISensorSetting curSensor = SensorHandler.instance().getSensorFromPath(TileEntityUniversalSensor.this.getSensorSetting());
                    if (curSensor == null) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = TileEntityUniversalSensor.this.getSensorSetting().substring(TileEntityUniversalSensor.this.getSensorSetting().lastIndexOf(47) + 1);
                    }
                    return objectArray;
                }
                throw new IllegalArgumentException("getSensor doesn't take any arguments!");
            }
        });
        this.luaMethods.add(new LuaMethod("setTextfield"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityUniversalSensor.this.setText(0, (String)args[0]);
                    return null;
                }
                throw new IllegalArgumentException("setTextfield takes one argument (string)");
            }
        });
        this.luaMethods.add(new LuaMethod("getTextfield"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{TileEntityUniversalSensor.this.getText(0)};
                }
                throw new IllegalArgumentException("getTextfield takes no arguments");
            }
        });
        this.luaMethods.add(new LuaMethod("isSensorEventBased"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{SensorHandler.instance().getSensorFromPath(TileEntityUniversalSensor.this.getSensorSetting()) instanceof IEventSensorSetting};
                }
                throw new IllegalArgumentException("isSensorEventBased takes no arguments");
            }
        });
        this.luaMethods.add(new LuaMethod("getSensorValue"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    ISensorSetting s = SensorHandler.instance().getSensorFromPath(TileEntityUniversalSensor.this.getSensorSetting());
                    if (s instanceof IPollSensorSetting) {
                        TileEntityUniversalSensor.this.requestPollPullEvent = true;
                        return new Object[]{TileEntityUniversalSensor.this.redstoneStrength};
                    }
                    if (s != null) {
                        throw new IllegalArgumentException("The selected sensor is pull event based. You can't poll the value.");
                    }
                    throw new IllegalArgumentException("There's no sensor selected!");
                }
                throw new IllegalArgumentException("getSensorValue takes no arguments");
            }
        });
        this.luaMethods.add(new LuaConstant("getMinWorkingPressure", 0.5f));
        this.luaMethods.add(new LuaMethod("setGPSToolCoordinate"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 4) {
                    ItemStack stack = TileEntityUniversalSensor.this.func_70301_a(((Double)args[0]).intValue() - 1);
                    if (stack != null && stack.func_77973_b() == Itemss.GPSTool) {
                        ItemGPSTool.setGPSLocation(stack, ((Double)args[1]).intValue(), ((Double)args[2]).intValue(), ((Double)args[3]).intValue());
                        return new Object[]{true};
                    }
                    return new Object[]{false};
                }
                throw new IllegalArgumentException("setGPSToolCoordinate needs 4 arguments: slot, x, y, z");
            }
        });
        this.luaMethods.add(new LuaMethod("getGPSToolCoordinate"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    ItemStack stack = TileEntityUniversalSensor.this.func_70301_a(((Double)args[0]).intValue() - 1);
                    if (stack != null && stack.func_77973_b() == Itemss.GPSTool) {
                        ChunkPosition pos = ItemGPSTool.getGPSLocation(stack);
                        if (pos != null) {
                            return new Object[]{pos.field_151329_a, pos.field_151327_b, pos.field_151328_c};
                        }
                        return new Object[]{0, 0, 0};
                    }
                    return null;
                }
                throw new IllegalArgumentException("setGPSToolCoordinate needs 1 argument: slot");
            }
        });
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        this.attachedComputers.add(computer);
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        this.attachedComputers.remove(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    private void notifyComputers(Object ... arguments) {
        for (IComputerAccess computer : this.attachedComputers) {
            computer.queueEvent(this.getType(), arguments);
        }
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getRedstoneMode() {
        return this.invertedRedstone ? 1 : 0;
    }

    @Override
    public float getMinWorkingPressure() {
        return 0.5f;
    }
}

