/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.RegisterChestItem;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.block.BlockBannerStandTileEntity;
import com.chocolate.chocolateQuest.block.BlockMobSpawnerTileEntity;
import com.chocolate.chocolateQuest.builder.BlockData;
import com.chocolate.chocolateQuest.builder.Perlin3D;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.entity.EntityDecoration;
import com.chocolate.chocolateQuest.entity.mob.registry.RegisterDungeonMobs;
import com.chocolate.chocolateQuest.items.ItemArmorBase;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ReportedException;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;

public class BuilderHelper {
    public static BuilderHelper builderHelper = new BuilderHelper();
    static final byte DEFAULT = 0;
    static final byte FOOD = 1;
    static final byte WEAPONS = 2;
    static final byte MINERALS = 3;
    static final byte TREASURE = 4;
    List<BlockData> specialBlocks;
    List<TileEntity> tileEntities;
    public static int BLOCK_NOTIFICATION;
    private int structureGenerationAmmount;
    private int structureGenerationResetTimer = 0;

    public int getStructureGenerationAmmount() {
        return this.structureGenerationAmmount;
    }

    public void setStructureGenerationAmmount(int ammount) {
        this.structureGenerationAmmount = ammount;
    }

    public void resetStructureGenerationAmmount() {
        if (this.structureGenerationResetTimer > 0) {
            this.structureGenerationResetTimer = this.structureGenerationResetTimer--;
        } else {
            this.structureGenerationAmmount = 0;
        }
    }

    public void initialize(int blockNotify) {
        BLOCK_NOTIFICATION = blockNotify;
        if (this.specialBlocks == null) {
            this.specialBlocks = new ArrayList<BlockData>();
        }
        this.specialBlocks.clear();
        if (this.tileEntities == null) {
            this.tileEntities = new ArrayList<TileEntity>();
        }
        this.tileEntities.clear();
    }

    public void flush(World world) {
        this.copyTileEntities(world);
    }

    public void putSchematicInWorld(Random random, World world, Schematic schematic, int i, int j, int k, int idMob, boolean replaceFlags) {
        schematic.setPosition(i, j, k);
        int sx = schematic.width;
        int sy = schematic.height;
        int sz = schematic.length;
        for (int y = 0; y < sy; ++y) {
            for (int x = 0; x < sx; ++x) {
                for (int z = 0; z < sz; ++z) {
                    Block block = schematic.getBlock(x, y, z);
                    int metadata = schematic.getBlockMetadata(x, y, z);
                    int posX = i + x;
                    int posY = j + y;
                    int posZ = k + z;
                    if (!this.checkIfPlacedOnFirstPass(block)) {
                        this.specialBlocks.add(new BlockData(posX, posY, posZ, block, metadata));
                        continue;
                    }
                    if (block == ChocolateQuest.emptyBlock) continue;
                    this.putBlockWithLoot(random, world, posX, posY, posZ, block, metadata, idMob);
                }
            }
        }
        this.copySpecialBlocks(world);
        List<TileEntity> list = schematic.getTileEntities();
        NBTTagList tags = schematic.getTileEntitiesTag();
        int tagCount = 0;
        for (TileEntity te : list) {
            Block block = world.func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            if (block instanceof BlockContainer) {
                String name;
                BlockMobSpawnerTileEntity spawner;
                TileEntity tempEntity = ((BlockContainer)block).func_149915_a(world, world.func_72805_g(te.field_145851_c, te.field_145848_d, te.field_145849_e));
                NBTTagCompound tag = tags.func_150305_b(tagCount);
                tempEntity.func_145839_a(tag);
                boolean putTileEntity = true;
                if (tempEntity instanceof BlockMobSpawnerTileEntity) {
                    spawner = (BlockMobSpawnerTileEntity)tempEntity;
                    spawner.mob = idMob;
                }
                if (tempEntity instanceof BlockBannerStandTileEntity && replaceFlags) {
                    BlockBannerStandTileEntity stand = (BlockBannerStandTileEntity)tempEntity;
                    int id = RegisterDungeonMobs.mobList.get(idMob).getFlagId();
                    stand.item = new ItemStack(ChocolateQuest.banner, 1, id);
                }
                if (tempEntity instanceof TileEntityMobSpawner && (name = (spawner = (TileEntityMobSpawner)tempEntity).func_145881_a().func_98276_e()).equals("Pig")) {
                    BuilderHelper.setMobForSpawner((TileEntityMobSpawner)spawner, idMob, te.field_145851_c, te.field_145848_d, te.field_145849_e, random);
                }
                if (block == Blocks.field_150486_ae) {
                    putTileEntity = false;
                }
                if (block == Blocks.field_150460_al && this.isInventoryEmpty((IInventory)((TileEntityFurnace)tempEntity))) {
                    putTileEntity = false;
                }
                if (block == Blocks.field_150367_z && this.isInventoryEmpty((IInventory)((TileEntityDispenser)tempEntity))) {
                    putTileEntity = false;
                }
                if (putTileEntity) {
                    this.addTileEntity(te.field_145851_c, te.field_145848_d, te.field_145849_e, tempEntity);
                }
            }
            ++tagCount;
        }
        List<Entity> listEntity = schematic.getEntities(world);
        for (Entity e : listEntity) {
            world.func_72838_d(e);
        }
    }

    public void addTileEntity(int x, int y, int z, TileEntity tileEntity) {
        tileEntity.field_145851_c = x;
        tileEntity.field_145848_d = y;
        tileEntity.field_145849_e = z;
        this.tileEntities.add(tileEntity);
    }

    public void copyTileEntities(World world) {
        if (this.tileEntities.size() > 0) {
            for (TileEntity tempEntity : this.tileEntities) {
                world.func_147455_a(tempEntity.field_145851_c, tempEntity.field_145848_d, tempEntity.field_145849_e, tempEntity);
            }
        }
    }

    public boolean checkIfPlacedOnFirstPass(Block id) {
        return id != Blocks.field_150488_af && id != Blocks.field_150438_bZ && id != Blocks.field_150429_aA && id != Blocks.field_150437_az && id != Blocks.field_150430_aB && id != Blocks.field_150471_bO && id != Blocks.field_150324_C && id != Blocks.field_150478_aa && id != Blocks.field_150466_ao && id != Blocks.field_150454_av && id != Blocks.field_150442_at && id != Blocks.field_150478_aa && id != Blocks.field_150468_ap && id != Blocks.field_150324_C && id != Blocks.field_150479_bC && id != Blocks.field_150444_as && id != Blocks.field_150331_J && id != Blocks.field_150320_F && id != Blocks.field_150332_K && id != Blocks.field_150415_aT;
    }

    public void copySpecialBlocks(World world) {
        BlockData b2 = null;
        Random rand = new Random();
        if (this.specialBlocks.size() > 0) {
            for (BlockData b2 : this.specialBlocks) {
                this.putBlock(world, b2.x, b2.y, b2.z, b2.block, b2.blockMetadata);
            }
            this.specialBlocks.clear();
        }
    }

    public void putBlock(World world, int x, int y, int z, Block block, int metadata) {
        if (block == Blocks.field_150466_ao || block == Blocks.field_150454_av) {
            if (metadata < 8) {
                ItemDoor.func_150924_a((World)world, (int)x, (int)y, (int)z, (int)metadata, (Block)(block == Blocks.field_150466_ao ? Blocks.field_150466_ao : Blocks.field_150454_av));
            } else {
                world.func_147465_d(x, y, z, block, metadata, 0);
            }
        } else if (block == Blocks.field_150430_aB || block == Blocks.field_150471_bO) {
            world.func_147465_d(x, y, z, block, metadata, 2);
        } else if (block.func_149744_f() && !(block instanceof BlockPressurePlate) && !(block instanceof BlockButton)) {
            world.func_147465_d(x, y, z, block, metadata, 2);
        } else if (block == Blocks.field_150438_bZ) {
            world.func_147465_d(x, y, z, block, metadata, 1);
        } else if (block == Blocks.field_150332_K) {
            world.func_147465_d(x, y, z, block, metadata, 0);
        } else {
            world.func_147465_d(x, y, z, block, metadata, 2);
        }
    }

    public void putBlockWithLoot(Random random, World world, int posX, int posY, int posZ, Block block, int metadata, int mobType) {
        if (block == ChocolateQuest.exporterChest) {
            if (metadata == 4) {
                world.func_147468_f(posX, posY, posZ);
                Entity boss = RegisterDungeonMobs.mobList.get(mobType).getBoss(world, posX, posY, posZ);
                if (boss != null) {
                    boss.func_70107_b((double)posX, (double)posY, (double)posZ);
                    world.func_72838_d(boss);
                    if (boss.field_70154_o != null) {
                        boss.field_70154_o.func_70107_b((double)posX, (double)posY, (double)posZ);
                        world.func_72838_d(boss.field_70154_o);
                    }
                }
            } else if (metadata == 1) {
                int ammount = RegisterDungeonMobs.mobList.get(mobType).getDifficulty(world, posX, posY, posZ);
                BuilderHelper.addFoodChest(random, world, posX, posY, posZ, ammount);
            } else if (metadata == 0) {
                int ammount = RegisterDungeonMobs.mobList.get(mobType).getDifficulty(world, posX, posY, posZ);
                BuilderHelper.addTreasure(random, world, posX, posY, posZ, ammount);
            } else if (metadata == 3) {
                int ammount = RegisterDungeonMobs.mobList.get(mobType).getDifficulty(world, posX, posY, posZ);
                BuilderHelper.addMineralChest(random, world, posX, posY, posZ, ammount);
            } else if (metadata == 2) {
                int ammount = RegisterDungeonMobs.mobList.get(mobType).getDifficulty(world, posX, posY, posZ);
                BuilderHelper.addWeaponChest(random, world, posX, posY, posZ, ammount);
            }
        } else if (block == Blocks.field_150486_ae) {
            int ammount = RegisterDungeonMobs.mobList.get(mobType).getDifficulty(world, posX, posY, posZ);
            BuilderHelper.addChest(random, world, posX, posY, posZ, ammount);
        } else if (block == Blocks.field_150460_al) {
            world.func_147465_d(posX, posY, posZ, block, metadata, 3);
            TileEntityFurnace tef = (TileEntityFurnace)world.func_147438_o(posX, posY, posZ);
            if (random.nextInt(15) == 0) {
                tef.func_70299_a(0, new ItemStack(Items.field_151043_k, random.nextInt(3) + 1));
            }
            if (random.nextInt(3) == 0) {
                tef.func_70299_a(1, new ItemStack(Items.field_151044_h, random.nextInt(45) + 1));
            }
            world.func_72921_c(posX, posY, posZ, metadata, 3);
        } else if (block == Blocks.field_150367_z) {
            world.func_147465_d(posX, posY, posZ, block, metadata, 0);
            TileEntityDispenser ted = (TileEntityDispenser)world.func_147438_o(posX, posY, posZ);
            for (int v = 0; v < 9; ++v) {
                if (random.nextInt(20) == 0) {
                    if (random.nextInt(50) == 0) {
                        ted.func_70299_a(v, new ItemStack(Items.field_151062_by, random.nextInt(8) + 1));
                    }
                    ted.func_70299_a(v, new ItemStack(Items.field_151059_bz, random.nextInt(16) + 1));
                    continue;
                }
                ted.func_70299_a(v, new ItemStack(Items.field_151032_g, random.nextInt(32) + 1));
            }
            world.func_72921_c(posX, posY, posZ, metadata, 3);
        } else if (block == Blocks.field_150409_cd) {
            world.func_147465_d(posX, posY, posZ, block, metadata, 3);
            world.func_72921_c(posX, posY, posZ, metadata, 3);
        } else {
            this.putBlock(world, posX, posY, posZ, block, metadata);
        }
    }

    public void putTileEntityWithLoot(World world, TileEntity t, int idMob, boolean replaceFlags, Random random) {
        String name;
        BlockMobSpawnerTileEntity spawner;
        boolean putTileEntity = true;
        Block block = world.func_147439_a(t.field_145851_c, t.field_145848_d, t.field_145849_e);
        if (t instanceof BlockMobSpawnerTileEntity) {
            spawner = (BlockMobSpawnerTileEntity)t;
            spawner.mob = idMob;
        }
        if (t instanceof BlockBannerStandTileEntity && replaceFlags) {
            BlockBannerStandTileEntity stand = (BlockBannerStandTileEntity)t;
            int id = RegisterDungeonMobs.mobList.get(idMob).getFlagId();
            stand.item = new ItemStack(ChocolateQuest.banner, 1, id);
        }
        if (t instanceof TileEntityMobSpawner && (name = (spawner = (TileEntityMobSpawner)t).func_145881_a().func_98276_e()).equals("Pig")) {
            BuilderHelper.setMobForSpawner((TileEntityMobSpawner)spawner, idMob, t.field_145851_c, t.field_145848_d, t.field_145849_e, random);
        }
        if (block == Blocks.field_150486_ae) {
            putTileEntity = false;
        }
        if (block == Blocks.field_150460_al && this.isInventoryEmpty((IInventory)((TileEntityFurnace)t))) {
            putTileEntity = false;
        }
        if (block == Blocks.field_150367_z && this.isInventoryEmpty((IInventory)((TileEntityDispenser)t))) {
            putTileEntity = false;
        }
        if (putTileEntity) {
            world.func_147455_a(t.field_145851_c, t.field_145848_d, t.field_145849_e, t);
        }
    }

    public boolean buildStep(Random rng, World world, Schematic cachedSchematic, int step, boolean isFirstPass, int mobID, boolean replaceFlags, boolean addLoot) {
        boolean blockPlaced = false;
        int posX = cachedSchematic.posX;
        int posY = cachedSchematic.posY;
        int posZ = cachedSchematic.posZ;
        int x = step % cachedSchematic.width;
        int z = step / cachedSchematic.width % cachedSchematic.length;
        int y = step / (cachedSchematic.width * cachedSchematic.length);
        posX += x;
        posY += y;
        posZ += z;
        Block block = cachedSchematic.getBlock(x, y, z);
        if (block == ChocolateQuest.emptyBlock) {
            return false;
        }
        if (block == Blocks.field_150350_a && world.func_147439_a(posX, posY, posZ) == Blocks.field_150350_a) {
            return false;
        }
        int metadata = cachedSchematic.getBlockMetadata(x, y, z);
        if (isFirstPass) {
            if (this.checkIfPlacedOnFirstPass(block)) {
                blockPlaced = true;
            }
        } else if (!this.checkIfPlacedOnFirstPass(block)) {
            blockPlaced = true;
        }
        if (blockPlaced) {
            TileEntity t;
            if (addLoot) {
                this.putBlockWithLoot(rng, world, posX, posY, posZ, block, metadata, mobID);
            } else {
                this.putBlock(world, posX, posY, posZ, block, metadata);
            }
            if (block instanceof BlockContainer && (t = cachedSchematic.getTileEntity(posX, posY, posZ)) != null) {
                if (addLoot) {
                    this.putTileEntityWithLoot(world, t, mobID, replaceFlags, new Random());
                } else {
                    world.func_147455_a(t.field_145851_c, t.field_145848_d, t.field_145849_e, t);
                }
            }
        }
        return blockPlaced;
    }

    public boolean putEntities(World world, Schematic cachedSchematic, int step) {
        return this.putEntities(world, cachedSchematic, step, 0, false);
    }

    public boolean putEntities(World world, Schematic cachedSchematic, int step, int mobID, boolean replaceFlags) {
        List<Entity> list = cachedSchematic.getEntities(world);
        if (step >= list.size()) {
            return false;
        }
        Entity e = list.get(step);
        if (replaceFlags && e instanceof EntityDecoration) {
            int flagID;
            ((EntityDecoration)e).type = flagID = RegisterDungeonMobs.mobList.get(mobID).getFlagId();
        }
        world.func_72838_d(e);
        return true;
    }

    public boolean isInventoryEmpty(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    public static void clearArea(Random random, World world, int i, int j, int k, int sizeX, int sizeZ) {
        Perlin3D p = new Perlin3D(world.func_72905_C(), 8, random);
        Perlin3D p2 = new Perlin3D(world.func_72905_C(), 32, random);
        int wallSize = 8;
        int size = sizeX + wallSize * 2;
        int height = 32;
        i -= wallSize;
        k -= wallSize;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                int maxHeight = world.func_72825_h(x + i, z + k) - 1 - j;
                for (int y = 0; y <= maxHeight; ++y) {
                    if (x > wallSize && z > wallSize && x < size - wallSize && z < size - wallSize) {
                        world.func_147468_f(x + i, j + y, z + k);
                        continue;
                    }
                    float noiseVar = (float)(maxHeight - y) / ((float)Math.max(1, maxHeight) * 1.5f);
                    int tWallSize = wallSize;
                    noiseVar += Math.max(0.0f, (float)(tWallSize - x) / 8.0f);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - (size - x)) / 8.0f);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - z) / 8.0f);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - (size - z)) / 8.0f);
                    double value = (p.getNoiseAt(x + i, y, z + k) + p2.getNoiseAt(x + i, y, z + k) + (double)noiseVar) / 3.0;
                    if (!(value < 0.5)) continue;
                    world.func_147468_f(i + x, j + y, k + z);
                }
                maxHeight = world.func_72825_h(x + i, z + k);
                BiomeGenBase biome = world.func_72807_a(x + i, z + k);
                world.func_147449_b(i + x, maxHeight - 1, k + z, biome.field_76752_A);
            }
        }
    }

    public static void addSpawner(Random random, World world, int x, int y, int z, int idMob) {
        world.func_147465_d(x, y, z, Blocks.field_150474_ac, 0, 0);
        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
        if (tileentitymobspawner != null) {
            BuilderHelper.setMobForSpawner(tileentitymobspawner, idMob, x, y, z, random);
        }
    }

    public static void setMobForSpawner(TileEntityMobSpawner spawner, int idMob, int x, int y, int z, Random random) {
        String mob = RegisterDungeonMobs.mobList.get(idMob).getSpawnerName(x, y, z, random);
        if (mob != null) {
            spawner.func_145881_a().func_98272_a(mob);
        } else {
            spawner.func_145881_a().func_98272_a(DungeonHooks.getRandomDungeonMob((Random)random));
        }
    }

    public static void addItemToInventory(IInventory inventory, ItemStack itemstack, int slot) {
        WeightedRandomChestContent chestContent = itemstack.func_77973_b().getChestGenBase(ChestGenHooks.getInfo((String)"dungeonChest"), new Random(), new WeightedRandomChestContent(itemstack, 1, 1, 1));
        inventory.func_70299_a(slot, chestContent.field_76297_b);
    }

    public static boolean addTreasure(Random random, World world, int x, int y, int z, int amount) {
        int slot;
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 0);
        TileEntityChest tileentitychest = new TileEntityChest();
        int itemsCount = random.nextInt(5) + amount;
        ItemStack itemstack = null;
        for (int f = 1; f < itemsCount + 1; ++f) {
            itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.treasureList, random);
            slot = random.nextInt(tileentitychest.func_70302_i_());
            BuilderHelper.addItemToInventory((IInventory)tileentitychest, itemstack, slot);
        }
        if (random.nextInt(3) == 0) {
            Item record;
            switch (random.nextInt(10)) {
                case 0: {
                    record = Items.field_151094_cf;
                    break;
                }
                case 1: {
                    record = Items.field_151093_ce;
                    break;
                }
                case 2: {
                    record = Items.field_151091_cg;
                    break;
                }
                case 3: {
                    record = Items.field_151092_ch;
                    break;
                }
                case 4: {
                    record = Items.field_151089_ci;
                    break;
                }
                case 5: {
                    record = Items.field_151090_cj;
                    break;
                }
                case 6: {
                    record = Items.field_151087_ck;
                    break;
                }
                case 7: {
                    record = Items.field_151088_cl;
                    break;
                }
                case 8: {
                    record = Items.field_151084_co;
                    break;
                }
                case 9: {
                    record = Items.field_151085_cm;
                    break;
                }
                default: {
                    record = Items.field_151094_cf;
                }
            }
            slot = random.nextInt(tileentitychest.func_70302_i_());
            tileentitychest.func_70299_a(slot, new ItemStack(record));
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static boolean addFoodChest(Random random, World world, int x, int y, int z, int amount) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 0);
        TileEntityChest tileentitychest = new TileEntityChest();
        int itemsCount = random.nextInt(6) + amount;
        for (int f = 0; f < itemsCount; ++f) {
            ItemStack itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.foodList, random);
            int slot = random.nextInt(tileentitychest.func_70302_i_());
            BuilderHelper.addItemToInventory((IInventory)tileentitychest, itemstack, slot);
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static boolean addMineralChest(Random random, World world, int x, int y, int z, int amount) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 0);
        TileEntityChest tileentitychest = new TileEntityChest();
        int itemsCount = random.nextInt(6) + amount;
        ItemStack itemstack = null;
        for (int f = 0; f < itemsCount; ++f) {
            itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.mineralList, random);
            int slot = random.nextInt(tileentitychest.func_70302_i_());
            BuilderHelper.addItemToInventory((IInventory)tileentitychest, itemstack, slot);
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static boolean addWeaponChest(Random random, World world, int x, int y, int z, int amount) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 0);
        TileEntityChest tileentitychest = new TileEntityChest();
        int itemsCount = random.nextInt(6) + amount;
        ItemStack itemstack = null;
        for (int f = 0; f < itemsCount; ++f) {
            itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.weaponList, random);
            if (itemstack != null) {
                BDHelper.EnchantItemRandomly(itemstack, random);
                if (itemstack.func_77973_b() instanceof ItemArmor && !(itemstack.func_77973_b() instanceof ItemArmorBase)) {
                    int armorType = ((ItemArmor)itemstack.func_77973_b()).field_77881_a;
                    Item armorItem = ChocolateQuest.diamondBoots;
                    switch (armorType) {
                        case 0: {
                            armorItem = ChocolateQuest.diamondHelmet;
                            break;
                        }
                        case 1: {
                            armorItem = ChocolateQuest.diamondPlate;
                            break;
                        }
                        case 2: {
                            armorItem = ChocolateQuest.diamondPants;
                        }
                    }
                    itemstack = armorItem.getChestGenBase((ChestGenHooks)ChestGenHooks.getInfo((String)"dungeonChest"), (Random)random, (WeightedRandomChestContent)new WeightedRandomChestContent((ItemStack)itemstack, (int)1, (int)1, (int)1)).field_76297_b;
                }
            }
            int slot = random.nextInt(tileentitychest.func_70302_i_());
            BuilderHelper.addItemToInventory((IInventory)tileentitychest, itemstack, slot);
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static boolean addChest(Random random, World world, int x, int y, int z, int amount) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 3);
        int itemsCount = random.nextInt(8) + amount;
        TileEntityChest tileentitychest = new TileEntityChest();
        int f = 0;
        if (random.nextInt(150) == 0) {
            Item record = random.nextBoolean() ? Items.field_151086_cn : Items.field_151096_cd;
            tileentitychest.func_70299_a(f, new ItemStack(record));
            ++f;
            ++itemsCount;
        }
        while (f < itemsCount) {
            ItemStack itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.chestList, random);
            int slot = random.nextInt(tileentitychest.func_70302_i_());
            BuilderHelper.addItemToInventory((IInventory)tileentitychest, itemstack, slot);
            ++f;
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static Schematic getNBTMap(String mapDir) {
        File file = new File(BDHelper.getAppDir(), BDHelper.getInfoDir() + mapDir);
        if (!file.exists()) {
            return null;
        }
        return BuilderHelper.getNBTMap(file);
    }

    public static Schematic getRandomNBTMap(String d, Random random, String offendor) {
        File dir = new File(BDHelper.getAppDir(), BDHelper.getInfoDir() + d);
        File[] file = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        });
        int s = 0;
        try {
            if (file.length > 1) {
                s = random.nextInt(file.length);
            }
            File mapFile = file[s];
            return BuilderHelper.getNBTMap(mapFile);
        }
        catch (Throwable throwable1) {
            String type = dir.exists() ? "empty" : "missing";
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)("Error loading dungeon " + offendor + " from " + type + " folder: " + dir.getPath()));
            throw new ReportedException(crashreport);
        }
    }

    public static Schematic getNBTMap(File file) {
        return new Schematic(file);
    }
}

