/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder.decorator;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.block.BlockAltarTileEntity;
import com.chocolate.chocolateQuest.block.BlockArmorStandTileEntity;
import com.chocolate.chocolateQuest.block.BlockMobSpawnerTileEntity;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.decorator.BuildingProperties;
import com.chocolate.chocolateQuest.entity.mob.registry.DungeonMonstersBase;
import com.chocolate.chocolateQuest.entity.mob.registry.RegisterDungeonMobs;
import com.chocolate.chocolateQuest.misc.EquipementHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomBase {
    public static final int CENTER = 5;
    public static final int BEDROOM = 0;
    public static final int KITCHEN = 1;
    public static final int LIBRARY = 2;
    public static final int MONSTER_ROOM = 3;
    public static final int OTHER_MONSTER_ROOM = 4;
    public static final int BIG_LIBRARY = 200;
    public static final int ALCHEMY = 201;
    public static final int BLACKSMITH = 202;
    public static final int ENCHANTMENT_ROOM = 203;
    public static final int FLAG_ROOM = 204;
    public static final int MAGIC_ROOM = 205;
    public static final int STORAGE = 206;
    public static final int PORTAL = 208;
    public static final int STAIRS = 300;
    public static final int LADDERS = 301;
    public static final int FULL_MONSTER_ROOM = 302;
    public static final int BOSS_ROOM = 303;
    public static final int ARCHERS = 304;
    public static final int DINNING_ROOM = 400;
    public static final int JAIL = 401;
    public static final int SPIDER_NEST = 402;
    public static final int TREASURE = 403;
    public static final int GARDEN = 500;
    public int sizeX;
    public int sizeZ;
    public boolean wallNorth = true;
    public boolean wallSouth = true;
    public boolean wallEast = true;
    public boolean wallWest = true;
    public boolean doorNorth = false;
    public boolean doorSouth = false;
    public boolean doorEast = false;
    public boolean doorWest = false;
    public boolean decorateNorth = true;
    public boolean decorateSouth = true;
    public boolean decorateEast = true;
    public boolean decorateWest = true;
    public boolean doorSet = false;
    public int stairsHeight = 0;
    protected final int loot = 2;
    public BuildingProperties properties;

    public RoomBase() {
    }

    public RoomBase(int sizeX, int sizeZ, int height, int roomType, BuildingProperties data) {
        this.configure(sizeX, sizeZ, data);
    }

    public RoomBase copyDataFrom(RoomBase room) {
        this.configure(room.sizeX, room.sizeZ, room.properties);
        this.wallNorth = room.wallNorth;
        this.wallSouth = room.wallSouth;
        this.wallEast = room.wallEast;
        this.wallWest = room.wallWest;
        this.doorNorth = room.doorNorth;
        this.doorSouth = room.doorSouth;
        this.doorEast = room.doorEast;
        this.doorWest = room.doorWest;
        this.decorateNorth = room.decorateNorth;
        this.decorateSouth = room.decorateSouth;
        this.decorateEast = room.decorateEast;
        this.decorateWest = room.decorateWest;
        return this;
    }

    public void configure(int sizeX, int sizeZ, BuildingProperties data) {
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
        this.properties = data;
    }

    public int getType() {
        return -1;
    }

    public RoomBase clearWalls() {
        this.wallEast = false;
        this.decorateEast = false;
        this.wallNorth = false;
        this.decorateNorth = false;
        this.wallSouth = false;
        this.decorateSouth = false;
        this.wallWest = false;
        this.decorateWest = false;
        return this;
    }

    public void decorate(Random random, World world, int posX, int posY, int posZ) {
        int h;
        int roomPos;
        int roomCenterX = posX + this.sizeX / 2;
        int roomCenterZ = posZ + this.sizeZ / 2;
        int floorHeight = this.properties.floorHeight;
        for (roomPos = 0; roomPos <= this.sizeZ; ++roomPos) {
            if (this.wallEast) {
                for (h = 0; h < this.properties.floorHeight; ++h) {
                    this.properties.wallBlock.placeBlock(world, posX, posY + h, posZ + roomPos, random);
                }
            }
            if (!this.wallWest) continue;
            for (h = 0; h < this.properties.floorHeight; ++h) {
                this.properties.wallBlock.placeBlock(world, posX + this.sizeX, posY + h, posZ + roomPos, random);
            }
        }
        for (roomPos = 0; roomPos <= this.sizeX; ++roomPos) {
            if (this.wallNorth) {
                for (h = 0; h < this.properties.floorHeight; ++h) {
                    this.properties.wallBlock.placeBlock(world, posX + roomPos, posY + h, posZ, random);
                }
            }
            if (!this.wallSouth) continue;
            for (h = 0; h < this.properties.floorHeight; ++h) {
                this.properties.wallBlock.placeBlock(world, posX + roomPos, posY + h, posZ + this.sizeZ, random);
            }
        }
        this.addRoomDecoration(random, world, posX, posY, posZ);
        world.func_147449_b(roomCenterX, posY + floorHeight - 1, roomCenterZ, Blocks.field_150379_bu);
        world.func_147465_d(roomCenterX, posY + floorHeight - 2, roomCenterZ, Blocks.field_150442_at, 0, 3);
        this.decorateDoors(random, world, posX, posY, posZ);
        for (int i = 0; i < this.properties.mobRatio; ++i) {
            int z;
            int y;
            int x = posX + random.nextInt(this.sizeX);
            if (!world.func_147437_c(x, y = posY, z = posZ + random.nextInt(this.sizeZ))) continue;
            this.addMob(random, world, x, y, z);
        }
    }

    public void addRoomDecoration(Random random, World world, int posX, int posY, int posZ) {
        int roomPos;
        int roomCenterX = posX + this.sizeX / 2;
        int roomCenterZ = posZ + this.sizeZ / 2;
        for (roomPos = 1; roomPos < this.sizeZ; ++roomPos) {
            if (this.decorateEast) {
                this.placeDecorationBlock(random, world, posX + 1, posY, posZ + roomPos, 1);
            }
            if (!this.decorateWest) continue;
            this.placeDecorationBlock(random, world, posX + this.sizeX - 1, posY, posZ + roomPos, 2);
        }
        for (roomPos = 1; roomPos < this.sizeX; ++roomPos) {
            if (this.decorateNorth) {
                this.placeDecorationBlock(random, world, posX + roomPos, posY, posZ + 1, 3);
            }
            if (!this.decorateSouth) continue;
            this.placeDecorationBlock(random, world, posX + roomPos, posY, posZ + this.sizeZ - 1, 4);
        }
        this.placeDecorationBlock(random, world, roomCenterX, posY, roomCenterZ, 5);
    }

    public void decorateDoors(Random random, World world, int posX, int posY, int posZ) {
        if (this.wallWest && this.doorWest) {
            this.properties.doors.generate(random, world, posX + this.sizeX, posY, posZ + this.sizeZ / 2, ForgeDirection.WEST);
        }
        if (this.wallSouth && this.doorSouth) {
            this.properties.doors.generate(random, world, posX + this.sizeX / 2, posY, posZ + this.sizeZ, ForgeDirection.SOUTH);
        }
        if (this.wallEast && this.doorEast) {
            this.properties.doors.generate(random, world, posX, posY, posZ + this.sizeZ / 2, ForgeDirection.EAST);
        }
        if (this.wallNorth && this.doorNorth) {
            this.properties.doors.generate(random, world, posX + this.sizeX / 2, posY, posZ, ForgeDirection.NORTH);
        }
    }

    public void placeDecorationBlock(Random random, World world, int x, int y, int z, int side) {
        if (random.nextInt(100) == 0) {
            this.placePainting(random, world, x, y + 1, z, side);
        }
        if (side != 5) {
            this.placeRandomDecorationBlock(random, world, x, y, z, side);
        }
    }

    public void placeRandomDecorationBlock(Random random, World world, int x, int y, int z, int side) {
        if (random.nextInt(10) == 0) {
            if (random.nextInt(4000) == 0) {
                world.func_147449_b(x, y, z, Blocks.field_150477_bB);
            } else if (random.nextInt(2000) == 0) {
                world.func_147449_b(x, y, z, Blocks.field_150378_br);
            } else if (random.nextInt(800) == 0) {
                world.func_147449_b(x, y, z, Blocks.field_150467_bQ);
            } else if (random.nextInt(400) == 0) {
                world.func_147449_b(x, y, z, Blocks.field_150421_aI);
            } else if (random.nextInt(500) == 0) {
                world.func_147468_f(x, y, z);
                world.func_147465_d(x, y, z, Blocks.field_150382_bo, 0, 3);
            } else if (random.nextInt(400) == 0) {
                world.func_147449_b(x, y, z, Blocks.field_150381_bn);
            } else if (random.nextInt(100) == 0) {
                world.func_147449_b(x, y + random.nextInt(this.properties.floorHeight - 2) + 1, z, Blocks.field_150321_G);
            } else if (random.nextInt(100) == 0) {
                this.placeCake(random, world, x, y, z);
            } else if (random.nextInt(100) == 0) {
                this.placeBed(random, world, x, y, z, side);
            } else if (random.nextInt(50) == 0) {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150383_bp, random.nextInt(3), 3);
            } else if (random.nextInt(50) == 0) {
                this.placeFrame(random, world, x, y + 1, z, side, new ItemStack(Items.field_151113_aN));
            } else if (random.nextInt(50) == 0) {
                this.placeShied(random, world, x, y + 1, z, side);
            } else if (random.nextInt(50) == 0) {
                this.placeFurnace(random, world, x, y, z, side);
            } else if (random.nextInt(20) == 0) {
                world.func_147449_b(x, y, z, Blocks.field_150342_X);
            } else if (random.nextInt(15) == 0) {
                this.placeFlowerPot(random, world, x, y, z);
            } else if (random.nextInt(20) == 0) {
                world.func_147449_b(x, y, z, Blocks.field_150462_ai);
            }
        }
    }

    public void decorateFullMonsterRoom(Random random, World world, int x, int y, int z, int side) {
        if (side == 5) {
            this.addMob(random, world, x + 1, y, z + 1);
            if (random.nextInt(8) == 0) {
                this.addMob(random, world, x + 1, y, z);
            }
            if (random.nextInt(8) == 0) {
                this.addMob(random, world, x - 1, y, z);
            }
            if (random.nextInt(8) == 0) {
                this.addMob(random, world, x, y, z + 1);
            }
            if (random.nextInt(8) == 0) {
                this.addMob(random, world, x, y, z - 1);
            }
            if (random.nextInt(8) == 0) {
                this.addMob(random, world, x + 1, y, z + 1);
            }
            if (random.nextInt(8) == 0) {
                this.addMob(random, world, x - 1, y, z - 1);
            }
            if (random.nextInt(8) == 0) {
                this.addMob(random, world, x - 1, y, z + 1);
            }
            if (random.nextInt(8) == 0) {
                this.addMob(random, world, x + 1, y, z - 1);
            }
            if (random.nextInt(40) == 0) {
                BuilderHelper.addSpawner(random, world, x, y - 1, z, this.properties.mobID);
            }
        } else if (random.nextInt(15) == 0) {
            this.addMob(random, world, x, y, z);
        }
    }

    public void addMob(Random random, World world, int x, int y, int z) {
        int lvl = random.nextInt(5);
        if (random.nextInt(5) == 0) {
            lvl += 5;
        }
        if (random.nextInt(5) == 0) {
            lvl += 5;
        }
        world.func_147465_d(x, y, z, ChocolateQuest.spawner, 0, 3);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof BlockMobSpawnerTileEntity) {
            BlockMobSpawnerTileEntity spawner = (BlockMobSpawnerTileEntity)te;
            spawner.mob = this.properties.mobID;
            spawner.metadata = lvl;
        }
    }

    public void addWeaponChest(Random random, World world, int x, int y, int z, int side) {
        BuilderHelper.addWeaponChest(random, world, x, y, z, 2);
    }

    public void placeMap(Random random, World world, int x, int y, int z, int side) {
        ItemStack is = new ItemStack((Item)Items.field_151148_bJ, 1, world.func_72841_b("map"));
        String s = "map_" + is.func_77960_j();
        MapData mapdata = new MapData(s);
        world.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = (byte)random.nextInt(5);
        mapdata.field_76201_a = x;
        mapdata.field_76199_b = z;
        this.placeFrame(random, world, x, y, z, side, is);
    }

    public void placeShied(Random random, World world, int x, int y, int z, int side) {
        DungeonMonstersBase mobType = RegisterDungeonMobs.mobList.get(this.properties.mobID);
        if (mobType != null) {
            this.placeFrame(random, world, x, y, z, side, new ItemStack(ChocolateQuest.shield, 1, mobType.getFlagId()));
        }
    }

    public void placeArmorStand(Random random, World world, int x, int y, int z, int side) {
        int rotation = 0;
        switch (side) {
            case 0: {
                rotation = random.nextInt(360);
            }
            case 1: {
                rotation = -90;
                break;
            }
            case 2: {
                rotation = 90;
                break;
            }
            case 4: {
                rotation = 180;
            }
        }
        world.func_147449_b(x, y, z, ChocolateQuest.armorStand);
        BlockArmorStandTileEntity stand = (BlockArmorStandTileEntity)ChocolateQuest.armorStand.createTileEntity(world, 0);
        if (stand != null) {
            int lvl;
            stand.rotation = rotation;
            for (lvl = 0; lvl < 5 && random.nextInt(Math.max(2, lvl)) == 0; ++lvl) {
            }
            for (int i = 0; i < 4; ++i) {
                stand.cargoItems[i] = EquipementHelper.getArmor(random, i + 1, lvl);
            }
            this.setTileEntity(world, x, y, z, stand);
        }
    }

    public void placeTable(Random random, World world, int x, int y, int z, ItemStack is) {
        world.func_147449_b(x, y, z, ChocolateQuest.table);
        BlockAltarTileEntity table = (BlockAltarTileEntity)ChocolateQuest.table.createTileEntity(world, 0);
        table.item = is;
        this.setTileEntity(world, x, y, z, table);
    }

    public void placeFrame(Random random, World world, int x, int y, int z, int side, ItemStack is) {
        switch (side) {
            case 1: {
                --x;
                side = 3;
                break;
            }
            case 2: {
                ++x;
                side = 1;
                break;
            }
            case 3: {
                --z;
                side = 0;
                break;
            }
            case 4: {
                ++z;
                side = 2;
            }
        }
        EntityItemFrame e = new EntityItemFrame(world, x, y, z, side);
        if (e.func_70518_d()) {
            e.func_82334_a(is);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)e);
            }
        }
    }

    public void placePainting(Random random, World world, int x, int y, int z, int side) {
        switch (side) {
            case 1: {
                --x;
                side = 3;
                break;
            }
            case 2: {
                ++x;
                side = 1;
                break;
            }
            case 3: {
                --z;
                side = 0;
                break;
            }
            case 4: {
                ++z;
                side = 2;
            }
        }
        EntityPainting e = new EntityPainting(world, x, y, z, side);
        if (e.func_70518_d() && !world.field_72995_K) {
            world.func_72838_d((Entity)e);
        }
    }

    public void placeBed(Random random, World world, int x, int y, int z, int side) {
        if (side > 4) {
            return;
        }
        int xo = 0;
        int zo = 0;
        int md = 0;
        switch (side) {
            case 1: {
                xo = 1;
                md = 1;
                break;
            }
            case 2: {
                xo = -1;
                md = 3;
                break;
            }
            case 3: {
                zo = 1;
                md = 2;
                break;
            }
            case 4: {
                zo = -1;
                md = 0;
            }
        }
        world.func_147465_d(x + xo, y, z + zo, Blocks.field_150324_C, md, 3);
        world.func_147465_d(x, y, z, Blocks.field_150324_C, md + 8, 3);
    }

    public void placeCake(Random random, World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, Blocks.field_150344_f, random.nextInt(5), 3);
        int md = random.nextInt(5);
        world.func_147465_d(x, y + 1, z, Blocks.field_150414_aQ, md, 3);
    }

    public void placeFlowerPot(Random random, World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, Blocks.field_150344_f, random.nextInt(5), 3);
        int md = random.nextInt(16);
        world.func_147465_d(x, y + 1, z, Blocks.field_150457_bL, md, 3);
    }

    public void placeFurnace(Random random, World world, int x, int y, int z, int side) {
        world.func_147468_f(x, y, z);
        world.func_147449_b(x, y, z, Blocks.field_150460_al);
        TileEntityFurnace furnace = (TileEntityFurnace)world.func_147438_o(x, y, z);
        if (furnace != null) {
            if (random.nextInt(4) == 0) {
                furnace.func_70299_a(1, new ItemStack(Items.field_151044_h, 1 + random.nextInt(15)));
            } else if (random.nextInt(4) == 0) {
                furnace.func_70299_a(1, new ItemStack(Items.field_151044_h, 1 + random.nextInt(15), 1));
            } else if (random.nextInt(20) == 0) {
                furnace.func_70299_a(1, new ItemStack(Items.field_151129_at, 1, 1));
            }
            if (random.nextInt(5) == 0) {
                furnace.func_70299_a(2, new ItemStack(Items.field_151042_j, 1 + random.nextInt(3)));
            } else if (random.nextInt(7) == 0) {
                furnace.func_70299_a(2, new ItemStack(Items.field_151043_k, 1 + random.nextInt(3)));
            } else if (random.nextInt(15) == 0) {
                furnace.func_70299_a(2, new ItemStack(Items.field_151045_i, 1 + random.nextInt(3)));
            }
        }
    }

    public void placeFoodFurnace(Random random, World world, int x, int y, int z, int side) {
        world.func_147468_f(x, y, z);
        world.func_147465_d(x, y, z, Blocks.field_150460_al, 0, 3);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            TileEntityFurnace furnace = (TileEntityFurnace)te;
            if (random.nextInt(4) == 0) {
                furnace.func_70299_a(1, new ItemStack(Items.field_151044_h, 1 + random.nextInt(15)));
            } else if (random.nextInt(4) == 0) {
                furnace.func_70299_a(1, new ItemStack(Items.field_151044_h, 1 + random.nextInt(15), 1));
            } else if (random.nextInt(20) == 0) {
                furnace.func_70299_a(1, new ItemStack(Items.field_151129_at));
            }
            if (random.nextInt(5) == 0) {
                furnace.func_70299_a(2, new ItemStack(Items.field_151147_al, 1 + random.nextInt(3)));
            } else if (random.nextInt(5) == 0) {
                furnace.func_70299_a(2, new ItemStack(Items.field_151115_aP, 1 + random.nextInt(3)));
            } else if (random.nextInt(5) == 0) {
                furnace.func_70299_a(2, new ItemStack(Items.field_151082_bd, 1 + random.nextInt(3)));
            }
        }
    }

    public void setTileEntity(World world, int x, int y, int z, TileEntity t) {
        world.func_147455_a(x, y, z, t);
    }
}

