/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity;

import com.chocolate.chocolateQuest.entity.ai.AIFollowOwner;
import com.chocolate.chocolateQuest.entity.ai.AITargetOwner;
import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.misc.EnumVoice;
import com.chocolate.chocolateQuest.particles.EffectManager;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntitySummonedUndead
extends EntityCreature
implements IEntityOwnable,
IAnimals {
    public static final byte SKELETON = 0;
    public static final byte GOLEM = 1;
    public static final byte HOUND = 2;
    public static final byte WITHER = 3;
    EntityLivingBase summoner;
    int lifeTime = 0;
    int maxLifeTime = 1200;
    private boolean firstTick = true;

    public EntitySummonedUndead(World par1World) {
        super(par1World);
        this.field_70728_aV = 0;
        this.initTasks();
        for (int i = 0; i < this.field_82174_bp.length; ++i) {
            this.field_82174_bp[i] = 0.0f;
        }
    }

    public EntitySummonedUndead(World world, EntityLivingBase summoner, int lvl) {
        this(world);
        this.summoner = summoner;
        this.setlvl((byte)lvl);
    }

    public EntitySummonedUndead(World world, EntityLivingBase summoner, int lvl, byte type) {
        this(world);
        this.summoner = summoner;
        this.setlvl((byte)lvl);
        this.setType(type);
        if (type == 2) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.33);
        }
    }

    public EntitySummonedUndead(World world, EntityLivingBase summoner, int lvl, float damage, Elements element, byte type) {
        this(world, summoner, lvl);
        this.setElement((byte)element.ordinal());
        this.setType(type);
        if (type == 1) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0 + (double)(lvl * 10) + (double)(damage * 5.0f));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)damage * 0.5);
        } else if (type == 2) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0 + (double)(lvl * 5));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)damage * 1.2);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23 + (double)damage * 0.01 + (double)lvl * 0.025);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0 + (double)(lvl * 5));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)damage);
        }
        this.func_70691_i(100.0f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
    }

    protected void initTasks() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIFollowOwner((EntityLiving)this, 1.0f, 8.0f, 50.0f, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AITargetOwner(this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)-1);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public Elements getElement() {
        byte b = this.field_70180_af.func_75683_a(17);
        if (b < 0) {
            return null;
        }
        return Elements.values()[b];
    }

    public int getType() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setType(byte lvl) {
        this.field_70180_af.func_75692_b(18, (Object)lvl);
    }

    public void setElement(byte lvl) {
        this.field_70180_af.func_75692_b(17, (Object)lvl);
    }

    public int getlvl() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setlvl(byte lvl) {
        this.field_70180_af.func_75692_b(16, (Object)lvl);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70636_d() {
        Elements element;
        if (this.summoner != null) {
            if (this.summoner.field_70128_L) {
                this.func_70106_y();
            }
            if (this.firstTick && this.getType() == 1) {
                double dist = 20.0;
                AxisAlignedBB var3 = this.field_70121_D.func_72314_b(dist, 0.0, dist);
                List list = this.field_70170_p.func_72872_a(EntityLiving.class, var3);
                for (Entity e : list) {
                    if (!(e instanceof EntityLiving)) continue;
                    EntityLiving el = (EntityLiving)e;
                    if (!(el.func_70638_az() != this.getOwner() && el.func_70643_av() != this.getOwner() || this.field_70170_p.field_72995_K)) {
                        el.func_70624_b((EntityLivingBase)this);
                        el.func_70604_c((EntityLivingBase)this);
                    }
                    if (!this.field_70170_p.field_72995_K || e == this.getOwner() || e == this) continue;
                    double x = el.field_70165_t;
                    double y = el.field_70163_u + (double)el.field_70131_O;
                    double z = el.field_70161_v;
                    EffectManager.spawnParticle(8, this.field_70170_p, x + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N, y + (double)(el.field_70131_O / 2.0f), z + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N, this.field_70165_t - x, this.field_70163_u - y, this.field_70161_v - z);
                }
                this.firstTick = false;
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        if (this.lifeTime > this.maxLifeTime) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && (element = this.getElement()) != null) {
            float r = element.getColorX();
            float g = element.getColorY();
            float b = element.getColorZ();
            float x = this.field_70146_Z.nextFloat() - 0.5f;
            float y = this.field_70146_Z.nextFloat() * 2.0f;
            float z = this.field_70146_Z.nextFloat() - 0.5f;
            this.field_70170_p.func_72869_a("mobSpell", this.field_70165_t + (double)x, this.field_70163_u + (double)y, this.field_70161_v + (double)z, (double)r, (double)g, (double)b);
        }
        ++this.lifeTime;
        super.func_70636_d();
    }

    protected String func_70639_aQ() {
        return EnumVoice.SKELETON.say;
    }

    protected String func_70621_aR() {
        return EnumVoice.SKELETON.hurt;
    }

    protected String func_70673_aS() {
        return EnumVoice.SKELETON.death;
    }

    public boolean func_70652_k(Entity entity) {
        boolean b = false;
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        Elements element = this.getElement();
        if (element == null) {
            b = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        } else if (entity instanceof EntityLivingBase) {
            b = element.attackWithElement((EntityLivingBase)entity, (EntityLivingBase)this, damage);
        }
        if (b && !this.field_70170_p.field_72995_K) {
            this.func_71038_i();
            if (this.summoner != null && this.isReanimatedCreature()) {
                EntityBaseBall ball = new EntityBaseBall(this.field_70170_p, this.summoner, 9);
                ball.setlvl(this.getlvl());
                ball.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)ball);
                if (this.getType() == 3 && entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 200));
                }
            }
        }
        return b;
    }

    public boolean isReanimatedCreature() {
        return this.getElement() == null;
    }

    public boolean attackEntityFrom(DamageSource damagesource, int i) {
        if (damagesource.func_76346_g() != this.summoner && super.func_70097_a(damagesource, (float)i)) {
            Entity entity = damagesource.func_76346_g();
            if (this.field_70153_n == entity || this.field_70154_o == entity) {
                return true;
            }
            if (entity instanceof EntityPlayer) {
                this.field_70789_a = entity;
            }
            if (this.func_110143_aJ() <= 0.0f) {
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            for (int r = 0; r < 30; ++r) {
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 2.0f), this.field_70161_v + (double)this.field_70146_Z.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
        }
        super.func_70106_y();
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.getElement() != null) {
            return EnumCreatureAttribute.UNDEFINED;
        }
        return EnumCreatureAttribute.UNDEAD;
    }

    public EntityLivingBase getOwner() {
        return this.summoner;
    }

    public boolean func_70028_i(Entity par1Entity) {
        return this.getOwner() == par1Entity || super.func_70028_i(par1Entity);
    }

    public String func_152113_b() {
        return null;
    }
}

