/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityReferee;
import com.chocolate.chocolateQuest.entity.ai.AIBossAttack;
import com.chocolate.chocolateQuest.entity.ai.AILavaSwim;
import com.chocolate.chocolateQuest.entity.ai.AITargetHurtBy;
import com.chocolate.chocolateQuest.entity.boss.AttackKick;
import com.chocolate.chocolateQuest.entity.boss.AttackPunch;
import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import com.chocolate.chocolateQuest.entity.boss.EntityPart;
import com.chocolate.chocolateQuest.entity.boss.EntityPartRidable;
import com.chocolate.chocolateQuest.packets.PacketAttackToXYZ;
import com.chocolate.chocolateQuest.packets.PacketEntityAnimation;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityGiantBoxer
extends EntityBaseBoss {
    public AttackPunch rightHand;
    public AttackPunch leftHand;
    public AttackKick kickHelper;
    static final byte airSmash = 10;
    public boolean airSmashInProgress = false;
    public boolean airSmashFalling = false;
    public EntityPart head;
    public int attackSpeed = 15;

    public EntityGiantBoxer(World world) {
        super(world);
        this.resize();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23 + (double)(this.size / 70.0f));
        this.kickHelper = new AttackKick(this);
        this.leftHand = new AttackPunch(this, 5);
        this.leftHand.setAngle(-15, -2, 0.4f);
        this.rightHand = new AttackPunch(this, 6);
        this.rightHand.setAngle(15, -2, 0.4f);
        this.xpRatio = 2.0f;
        this.projectileDefense = 40;
        this.blastDefense = 10;
        this.magicDefense = 10;
        this.fireDefense = -30;
    }

    @Override
    protected void scaleAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23 + (double)this.lvl * 0.02);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0 + (double)this.lvl * 0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0 + (double)this.lvl * 360.0);
        this.attackSpeed = (int)(6.0 + (double)this.lvl * 1.8);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void addAITasks() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AILavaSwim(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIBossAttack(this, 1.0f, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AITargetHurtBy(this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true));
    }

    @Override
    protected boolean func_70650_aV() {
        return true;
    }

    @Override
    public void initBody() {
        this.head = new EntityPartRidable(this.field_70170_p, this, 0, 0.0f, this.size / 6.0f, this.size);
        this.head.func_70105_a(this.size / 3.0f, this.size / 3.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)this.head);
        }
        super.initBody();
    }

    @Override
    public void setPart(EntityPart entityPart, int partID) {
        super.setPart(entityPart, partID);
        entityPart.func_70105_a(this.size / 3.0f, this.size / 3.0f);
    }

    public void func_70071_h_() {
        if (!this.field_70128_L) {
            this.leftHand.onUpdate();
            this.rightHand.onUpdate();
            this.kickHelper.onUpdate();
            if (this.airSmashInProgress && this.field_70143_R > 0.0f) {
                this.airSmashFalling = true;
            }
            if (this.airSmashInProgress && this.field_70122_E && this.airSmashFalling) {
                this.airSmashInProgress = false;
                this.airSmashFalling = false;
                if (this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                } else {
                    List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)(1.0f + this.size / 10.0f), 1.0, (double)(1.0f + this.size / 10.0f)));
                    for (Entity e : list) {
                        if (!(e instanceof EntityLivingBase)) continue;
                        this.func_70652_k(e);
                    }
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.func_110143_aJ() < this.func_110138_aP() / 3.0f && this.field_70173_aa % 10 < 2) {
                String part = "largesmoke";
                if (this.size < 5.0f) {
                    part = "smoke";
                }
                float rot = this.field_70759_as * 3.1416f / 180.0f;
                double scale = (double)this.field_70130_N * 1.4;
                float desp = this.field_70130_N * 0.05f;
                double mx = MathHelper.func_76126_a((float)(rot + 0.2f));
                double mz = MathHelper.func_76134_b((float)(rot + 0.2f));
                double posX = this.field_70165_t - mx * scale;
                double posY = this.field_70163_u + (double)this.field_70131_O * 1.05;
                double posZ = this.field_70161_v + mz * scale;
                this.field_70170_p.func_72869_a(part, posX + this.field_70146_Z.nextGaussian() * (double)desp, posY, posZ + this.field_70146_Z.nextGaussian() * (double)desp, -mx / 20.0, -(0.3 + (double)(this.field_70146_Z.nextFloat() * this.size)) / 25.0, mz / 20.0);
                mx = MathHelper.func_76126_a((float)(rot - 0.2f));
                mz = MathHelper.func_76134_b((float)(rot - 0.2f));
                posX = this.field_70165_t - mx * scale;
                posY = this.field_70163_u + (double)this.field_70131_O * 1.05;
                posZ = this.field_70161_v + mz * scale;
                this.field_70170_p.func_72869_a(part, posX + this.field_70146_Z.nextGaussian() * (double)desp, posY, posZ + this.field_70146_Z.nextGaussian() * (double)desp, -mx / 20.0, -(0.3 + (double)(this.field_70146_Z.nextFloat() * this.size)) / 25.0, mz / 20.0);
            }
            if (this.field_70173_aa % 200 < 10) {
                float rot = this.field_70177_z * 3.1416f / 180.0f;
                double scale = (double)this.field_70130_N / 1.6;
                double mx = (double)MathHelper.func_76126_a((float)rot) * scale;
                double mz = (double)MathHelper.func_76134_b((float)rot) * scale;
                double posX = this.field_70165_t + mx;
                double posY = this.field_70163_u + (double)this.field_70131_O * 0.5;
                double posZ = this.field_70161_v - mz;
                float desp = this.field_70130_N * 0.05f;
                this.field_70170_p.func_72869_a("cloud", posX + this.field_70146_Z.nextGaussian() * (double)desp, posY, posZ + this.field_70146_Z.nextGaussian() * (double)desp, mx / 5.0, -0.3 + (double)(this.field_70146_Z.nextFloat() / 4.0f), -mz / 5.0);
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void animationBoss(byte animType) {
        if (!this.field_70170_p.field_72995_K) {
            PacketEntityAnimation packet = new PacketEntityAnimation(this.func_145782_y(), animType);
            ChocolateQuest.channel.sendToAllAround((Entity)this, packet, 64);
        }
        switch (animType) {
            case 10: {
                this.airSmashInProgress = true;
                return;
            }
        }
        this.kickHelper.kick(animType);
    }

    @Override
    public void attackToXYZ(byte arm, double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K) {
            PacketAttackToXYZ packet = new PacketAttackToXYZ(this.func_145782_y(), arm, x, y, z);
            ChocolateQuest.channel.sendToAllAround((Entity)this, packet, 64);
        }
        if (arm == 5) {
            this.leftHand.swingArmTo(x, y, z);
        } else {
            this.rightHand.swingArmTo(x, y, z);
        }
    }

    @Override
    public boolean attackFromPart(DamageSource par1DamageSource, float par2, EntityPart part) {
        if (part == this.head) {
            par2 = par1DamageSource.func_76352_a() ? (par2 *= 2.0f) : (par2 *= this.lvl);
        }
        return super.attackFromPart(par1DamageSource, par2, part);
    }

    @Override
    public void func_70785_a(Entity target, float dist) {
        int angle = (int)MathHelper.func_76138_g((double)(BDHelper.getAngleBetweenEntities((Entity)this, target) - (double)this.field_70177_z));
        if (this.field_70173_aa % this.attackSpeed == 0 && !this.field_70170_p.field_72995_K) {
            double posY = this.field_70163_u + (double)this.size;
            double dx = this.field_70165_t - target.field_70165_t;
            double targetY = target.field_70163_u + (double)target.field_70131_O;
            double dy = this.field_70163_u + (double)this.size - targetY;
            double dz = this.field_70161_v - target.field_70161_v;
            double distToHead = dx * dx + dy * dy + dz * dz - (double)(this.field_70130_N * this.field_70130_N);
            if (distToHead < (this.getArmLength() + 1.0) * (this.getArmLength() + 1.0)) {
                boolean handFlag = this.field_70146_Z.nextBoolean();
                boolean ARM_LEFT = false;
                boolean ARM_RIGHT = true;
                if (!handFlag) {
                    if (this.leftHand.attackInProgress()) {
                        handFlag = true;
                    }
                } else if (this.rightHand.attackInProgress()) {
                    handFlag = false;
                }
                if (angle > -110 && angle < 110) {
                    if (!handFlag && !this.leftHand.attackInProgress()) {
                        this.leftHand.attackTarget(target);
                    } else if (!this.rightHand.attackInProgress()) {
                        this.rightHand.attackTarget(target);
                    }
                }
            }
        }
        if (this.field_70173_aa % 10 == 0 && !this.field_70170_p.field_72995_K && dist < (this.field_70130_N + 3.0f) * (this.field_70130_N + 3.0f)) {
            this.kickHelper.attackTarget(target);
        }
        if (this.field_70173_aa % 10 == 0 && this.field_70122_E && this.field_70146_Z.nextInt(10) == 0 && (dist > (this.field_70130_N + 3.0f) * (this.field_70130_N + 3.0f) && angle > -60 && angle < 60 || angle < -110 || angle > 110)) {
            this.field_70181_x = 1.5 + (double)(this.lvl / 10.0f);
            this.field_70159_w = (target.field_70165_t - this.field_70165_t) / 5.0;
            this.field_70179_y = (target.field_70161_v - this.field_70161_v) / 5.0;
            this.animationBoss((byte)10);
        }
    }

    public double getArmLength() {
        return this.size;
    }

    @Override
    protected void resize() {
        this.func_70105_a(this.size / 3.0f, this.size);
    }

    @Override
    public float getMinSize() {
        return 1.1f;
    }

    @Override
    public float getSizeVariation() {
        return 1.4f;
    }

    @Override
    public boolean func_70686_a(Class par1Class) {
        return EntityGhast.class != par1Class && par1Class != EntityReferee.class;
    }

    protected void func_70069_a(float par1) {
    }

    public boolean func_70028_i(Entity par1Entity) {
        return this == par1Entity || par1Entity == this.head;
    }

    @Override
    public boolean attackInProgress() {
        return this.kickHelper.isAttackInProgress() || this.leftHand.isAttacking || this.rightHand.isAttacking;
    }

    protected String func_70639_aQ() {
        return "chocolatequest:monking_speak";
    }

    protected String func_70621_aR() {
        return "chocolatequest:monking_hurt";
    }

    protected String func_70673_aS() {
        return "chocolatequest:monking_death";
    }

    @Override
    protected int getDropMaterial() {
        return 5;
    }
}

