/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.magic;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.magic.SpellProjectile;
import com.chocolate.chocolateQuest.packets.PacketSpawnParticlesAround;
import com.chocolate.chocolateQuest.utils.HelperPlayer;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SpellTeleport
extends SpellProjectile {
    @Override
    public void onShoot(EntityLivingBase shooter, Elements element, ItemStack is, int chargeTime) {
        World world = shooter.field_70170_p;
        double startX = shooter.field_70165_t;
        double startY = shooter.field_70163_u;
        double startZ = shooter.field_70161_v;
        if (world.field_72995_K) {
            Random random = shooter.func_70681_au();
            for (int i = 0; i < 8; ++i) {
                shooter.field_70170_p.func_72869_a("portal", shooter.field_70165_t + ((double)random.nextFloat() - 0.5), shooter.field_70163_u + ((double)random.nextFloat() - 0.5), shooter.field_70161_v + ((double)random.nextFloat() - 0.5), ((double)random.nextFloat() - 0.5) / 2.0, ((double)random.nextFloat() - 0.5) / 2.0, ((double)random.nextFloat() - 0.5) / 2.0);
            }
        } else if (!world.field_72995_K) {
            PacketSpawnParticlesAround packet = new PacketSpawnParticlesAround(PacketSpawnParticlesAround.getParticleFromName(element.getParticle()), shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v);
            ChocolateQuest.channel.sendToAllAround((Entity)shooter, packet, 64);
        }
        if (shooter instanceof EntityPlayer) {
            int dist = 8 + 10 * this.getExpansion(is) + (int)this.getDamage(is);
            MovingObjectPosition mop = HelperPlayer.getBlockMovingObjectPositionFromPlayerWithSideOffset(shooter.field_70170_p, shooter, dist, true);
            if (mop != null) {
                shooter.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
            } else {
                Vec3 look = shooter.func_70040_Z();
                shooter.func_70107_b(shooter.field_70165_t + look.field_72450_a * (double)dist, shooter.field_70163_u + look.field_72448_b * (double)dist, shooter.field_70161_v + look.field_72449_c * (double)dist);
            }
        } else {
            EntityLivingBase target = shooter;
            EntityLiving shooterLiving = (EntityLiving)shooter;
            if (shooterLiving.func_70638_az() != null) {
                target = shooterLiving.func_70638_az();
            }
            this.damageNearby(world, shooter, element);
            for (int i = 0; i < 6 && !this.castTeleport(shooter, (Entity)target); ++i) {
            }
        }
        shooter.field_70170_p.func_72908_a(startX, startY, startZ, "mob.endermen.portal", 1.0f, 1.0f);
        shooter.field_70170_p.func_72956_a((Entity)shooter, "mob.endermen.portal", 1.0f, 1.0f);
        if (world.field_72995_K) {
            Random random = shooter.func_70681_au();
            for (int i = 0; i < 16; ++i) {
                shooter.field_70170_p.func_72869_a("portal", shooter.field_70165_t + ((double)random.nextFloat() - 0.5), shooter.field_70163_u + (double)random.nextFloat(), shooter.field_70161_v + ((double)random.nextFloat() - 0.5), ((double)random.nextFloat() - 0.5) / 2.0, ((double)random.nextFloat() - 0.5) / 2.0, ((double)random.nextFloat() - 0.5) / 2.0);
            }
        }
    }

    @Override
    public int getCastingTime() {
        return 3;
    }

    protected void damageNearby(World world, EntityLivingBase shooter, Elements element) {
        int dist = 5;
        List list = world.func_72839_b((Entity)shooter, shooter.field_70121_D.func_72314_b((double)dist, 1.0, (double)dist));
        for (Entity e : list) {
            if (!(e instanceof EntityLivingBase) || e == shooter.field_70153_n) continue;
            element.attackWithElement((EntityLivingBase)e, shooter, 1.0f);
        }
    }

    protected boolean castTeleport(EntityLivingBase shooter, Entity target) {
        int k;
        int j;
        World worldObj = shooter.field_70170_p;
        float dist = 16.0f;
        Random rand = shooter.func_70681_au();
        double dX = target.field_70165_t + (rand.nextDouble() - 0.5) * (double)dist;
        double dY = target.field_70163_u;
        double dZ = target.field_70161_v + (rand.nextDouble() - 0.5) * (double)dist;
        double startX = shooter.field_70165_t;
        double startY = shooter.field_70163_u;
        double startZ = shooter.field_70161_v;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)dX);
        if (worldObj.func_72899_e(i, j = MathHelper.func_76128_c((double)dY), k = MathHelper.func_76128_c((double)dZ))) {
            boolean isNonSolidBlock = false;
            while (!isNonSolidBlock && j < 255) {
                Material mat = worldObj.func_147439_a(i, j - 1, k).func_149688_o();
                if (!mat.func_76220_a()) {
                    dY += 1.0;
                    ++j;
                    continue;
                }
                isNonSolidBlock = true;
            }
            if (isNonSolidBlock) {
                shooter.func_70107_b(dX, dY, dZ);
                if (worldObj.func_72945_a((Entity)shooter, shooter.field_70121_D).size() == 0 && !worldObj.func_72953_d(shooter.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            shooter.func_70107_b(startX, startY, startZ);
            return false;
        }
        return true;
    }

    @Override
    public int getCoolDown() {
        return 400;
    }

    @Override
    public int getRange(ItemStack itemstack) {
        return 2;
    }

    @Override
    public float getCost(ItemStack itemstack) {
        return 100.0f;
    }
}

