/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.GuiHandler;
import net.lepko.easycrafting.core.block.TileEntityAutoCrafting;
import net.lepko.easycrafting.core.block.TileEntityEasyCrafting;
import net.lepko.easycrafting.core.inventory.gui.IGuiTile;
import net.lepko.easycrafting.core.recipe.RecipeManager;
import net.lepko.easycrafting.core.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockTable
extends BlockContainer {
    public static String[] names = new String[]{"easy_crafting", "auto_crafting"};
    private IIcon[][] icons = new IIcon[2][4];

    public BlockTable() {
        super(Material.field_151575_d);
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c(Ref.addDomain("table"));
        this.func_149658_d(Ref.addDomain("table"));
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons[0][0] = iconRegister.func_94245_a(Ref.addDomain("easyCraftingTable_bottom"));
        this.icons[0][1] = iconRegister.func_94245_a(Ref.addDomain("easyCraftingTable_top"));
        this.icons[0][2] = iconRegister.func_94245_a(Ref.addDomain("easyCraftingTable_side1"));
        this.icons[0][3] = iconRegister.func_94245_a(Ref.addDomain("easyCraftingTable_side2"));
        this.icons[1][0] = iconRegister.func_94245_a(Ref.addDomain("autoCraftingTable_bottom"));
        this.icons[1][1] = iconRegister.func_94245_a(Ref.addDomain("autoCraftingTable_top"));
        this.icons[1][2] = iconRegister.func_94245_a(Ref.addDomain("autoCraftingTable_side1"));
        this.icons[1][3] = iconRegister.func_94245_a(Ref.addDomain("autoCraftingTable_side2"));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta > this.icons.length) {
            meta = 0;
        }
        switch (side) {
            case 0: {
                return this.icons[meta][0];
            }
            case 1: {
                return this.icons[meta][1];
            }
            case 2: 
            case 3: {
                return this.icons[meta][2];
            }
        }
        return this.icons[meta][3];
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int meta = 0; meta < names.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || player.func_70093_af()) {
            return false;
        }
        if (te instanceof TileEntityEasyCrafting) {
            RecipeManager.scanRecipes();
        }
        if (te instanceof IGuiTile) {
            GuiHandler.openGui(player, world, x, y, z);
            return true;
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityAutoCrafting) {
            InventoryUtils.dropItems(world.func_147438_o(x, y, z), ((TileEntityAutoCrafting)te).SLOTS);
        } else {
            InventoryUtils.dropItems(world.func_147438_o(x, y, z));
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 1: {
                return new TileEntityAutoCrafting();
            }
        }
        return new TileEntityEasyCrafting();
    }
}

