/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.inventory.gui;

import net.lepko.easycrafting.core.block.TileEntityAutoCrafting;
import net.lepko.easycrafting.core.inventory.gui.GuiAutoCrafting;
import net.lepko.easycrafting.core.network.PacketHandler;
import net.lepko.easycrafting.core.network.message.MessageInterfaceChange;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class ButtonMode {
    public final GuiAutoCrafting gui;
    public final int x;
    public final int y;
    public final int w;
    public final int h;
    public final int u;
    public final int v;

    public ButtonMode(GuiAutoCrafting gui, int x, int y, int w, int h, int u, int v) {
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.u = u;
        this.v = v;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + this.w && mouseY >= this.y && mouseY < this.y + this.h;
    }

    public void render(int mouseX, int mouseY, TileEntityAutoCrafting.Mode mode) {
        int modeOrdinal = mode == null ? 4 : mode.ordinal();
        int offsetV = this.isMouseOver(mouseX, mouseY) ? 16 : 0;
        this.gui.func_73729_b(this.x, this.y, this.u, this.v + offsetV, this.w, this.h);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.gui.func_73729_b(this.x, this.y, this.u - 16, modeOrdinal * 16, 16, 16);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void renderTooltip(int mouseX, int mouseY, TileEntityAutoCrafting.Mode mode) {
        if (this.isMouseOver(mouseX, mouseY) && mode != null) {
            this.gui.drawHoverText(I18n.func_135052_a((String)mode.tooltip, (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    public void click(int mouseX, int mouseY, int mouseButton, TileEntityAutoCrafting tileEntity) {
        if (this.isMouseOver(mouseX, mouseY)) {
            tileEntity.cycleModes(mouseButton);
            PacketHandler.INSTANCE.sendToServer(new MessageInterfaceChange(0, tileEntity.getMode().ordinal()));
        }
    }
}

