/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.network.message.AbstractMessage;
import net.lepko.easycrafting.core.network.message.MessageEasyCrafting;
import net.lepko.easycrafting.core.network.message.MessageInterfaceChange;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

public final class PacketHandler
extends FMLIndexedMessageToMessageCodec<AbstractMessage> {
    public static final PacketHandler INSTANCE = new PacketHandler();
    private static final EnumMap<Side, FMLEmbeddedChannel> CHANNELS = NetworkRegistry.INSTANCE.newChannel(Ref.CHANNEL, new ChannelHandler[]{INSTANCE, PacketExecutor.INSTANCE});

    private PacketHandler() {
    }

    public static void init() {
        INSTANCE.addDiscriminator(0, MessageEasyCrafting.class);
        INSTANCE.addDiscriminator(1, MessageInterfaceChange.class);
    }

    public void encodeInto(ChannelHandlerContext ctx, AbstractMessage msg, ByteBuf target) throws Exception {
        msg.write(target);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, AbstractMessage msg) {
        msg.read(source);
    }

    public void sendToAll(AbstractMessage message) {
        CHANNELS.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        CHANNELS.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(AbstractMessage message, EntityPlayerMP player) {
        CHANNELS.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        CHANNELS.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        CHANNELS.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(AbstractMessage message, NetworkRegistry.TargetPoint point) {
        CHANNELS.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        CHANNELS.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        CHANNELS.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(AbstractMessage message, int dimensionId) {
        CHANNELS.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        CHANNELS.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        CHANNELS.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(AbstractMessage message) {
        CHANNELS.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        CHANNELS.get(Side.CLIENT).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    @ChannelHandler.Sharable
    private static class PacketExecutor
    extends SimpleChannelInboundHandler<AbstractMessage> {
        public static final PacketExecutor INSTANCE = new PacketExecutor();

        private PacketExecutor() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, AbstractMessage msg) throws Exception {
            EntityPlayer player;
            Side side = (Side)ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get();
            if (side.isClient()) {
                player = this.getClientPlayer();
            } else {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                player = ((NetHandlerPlayServer)netHandler).field_147369_b;
            }
            msg.run(player, side);
        }

        @SideOnly(value=Side.CLIENT)
        public EntityPlayer getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }
}

