/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.network.message;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.config.ConfigHandler;
import net.lepko.easycrafting.core.network.message.AbstractMessage;
import net.lepko.easycrafting.core.recipe.RecipeHelper;
import net.lepko.easycrafting.core.recipe.RecipeManager;
import net.lepko.easycrafting.core.recipe.WrappedRecipe;
import net.lepko.easycrafting.core.util.InventoryUtils;
import net.lepko.easycrafting.core.util.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MessageEasyCrafting
extends AbstractMessage {
    private ItemStack result;
    private ItemStack[] ingredients;
    private boolean isRightClick = false;
    private boolean isShiftClick = false;

    public MessageEasyCrafting() {
    }

    public MessageEasyCrafting(WrappedRecipe recipe, boolean isRightClick, boolean isShiftClick) {
        this.setRecipe(recipe);
        this.isRightClick = isRightClick;
        this.isShiftClick = isShiftClick;
    }

    private void setRecipe(WrappedRecipe recipe) {
        this.result = recipe.getOutput();
        this.ingredients = new ItemStack[recipe.inputs.size()];
        for (int i = 0; i < recipe.inputs.size(); ++i) {
            if (recipe.inputs.get(i) instanceof ItemStack) {
                this.ingredients[i] = ((ItemStack)recipe.inputs.get(i)).func_77946_l();
                continue;
            }
            if (!(recipe.inputs.get(i) instanceof List)) continue;
            List ingList = (List)recipe.inputs.get(i);
            this.ingredients[i] = ((ItemStack)ingList.get(0)).func_77946_l();
        }
    }

    @Override
    public void write(ByteBuf target) {
        target.writeBoolean(this.isRightClick);
        target.writeShort(Item.func_150891_b((Item)this.result.func_77973_b()));
        target.writeInt(this.result.func_77960_j());
        target.writeByte(this.result.field_77994_a);
        target.writeByte(this.ingredients.length);
        for (ItemStack is : this.ingredients) {
            target.writeShort(Item.func_150891_b((Item)is.func_77973_b()));
            target.writeInt(is.func_77960_j());
            target.writeByte(is.field_77994_a);
        }
        target.writeBoolean(this.isShiftClick);
    }

    @Override
    public void read(ByteBuf source) {
        this.isRightClick = source.readBoolean();
        short id = source.readShort();
        int damage = source.readInt();
        byte size = source.readByte();
        this.result = new ItemStack(Item.func_150899_d((int)id), (int)size, damage);
        int length = source.readByte();
        this.ingredients = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            short _id = source.readShort();
            int _damage = source.readInt();
            byte _size = source.readByte();
            this.ingredients[i] = new ItemStack(Item.func_150899_d((int)_id), (int)_size, _damage);
        }
        this.isShiftClick = source.readBoolean();
    }

    @Override
    public void run(EntityPlayer player, Side side) {
        Ref.LOGGER.trace("Message: " + this.getClass().getName() + " Side: " + side);
        WrappedRecipe recipe = RecipeHelper.getValidRecipe(this.result, this.ingredients);
        if (recipe == null) {
            return;
        }
        ItemStack stack_in_hand = player.field_71071_by.func_70445_o();
        if (RecipeHelper.canCraft(recipe, (IInventory)player.field_71071_by, RecipeManager.getAllRecipes(), false, 1, ConfigHandler.MAX_RECURSION) == 0) {
            return;
        }
        ItemStack return_stack = recipe.handler.getCraftingResult(recipe, recipe.usedIngredients);
        int return_size = 0;
        if (stack_in_hand == null) {
            return_size = return_stack.field_77994_a;
        } else if (StackUtils.canStack(stack_in_hand, return_stack) == 0) {
            return_size = return_stack.field_77994_a + stack_in_hand.field_77994_a;
        }
        if (return_size > 0) {
            if (!this.isRightClick) {
                if (this.isShiftClick) {
                    int maxTimes = RecipeHelper.calculateCraftingMultiplierUntilMaxStack(return_stack, null);
                    int timesCrafted = RecipeHelper.canCraft(recipe, (IInventory)player.field_71071_by, RecipeManager.getAllRecipes(), false, maxTimes, ConfigHandler.MAX_RECURSION);
                    if (timesCrafted > 0) {
                        return_stack.field_77994_a *= timesCrafted;
                        if (InventoryUtils.addItemToInventory((IInventory)player.field_71071_by, return_stack)) {
                            RecipeHelper.canCraft(recipe, (IInventory)player.field_71071_by, RecipeManager.getAllRecipes(), true, maxTimes, ConfigHandler.MAX_RECURSION);
                        }
                    }
                } else if (RecipeHelper.canCraft(recipe, (IInventory)player.field_71071_by, RecipeManager.getAllRecipes(), true, 1, ConfigHandler.MAX_RECURSION) > 0) {
                    return_stack.field_77994_a = return_size;
                    player.field_71071_by.func_70437_b(return_stack);
                }
            } else {
                int maxTimes = RecipeHelper.calculateCraftingMultiplierUntilMaxStack(return_stack, stack_in_hand);
                int timesCrafted = RecipeHelper.canCraft(recipe, (IInventory)player.field_71071_by, RecipeManager.getAllRecipes(), true, maxTimes, ConfigHandler.MAX_RECURSION);
                if (timesCrafted > 0) {
                    return_stack.field_77994_a = return_size + (timesCrafted - 1) * return_stack.field_77994_a;
                    player.field_71071_by.func_70437_b(return_stack);
                }
            }
        }
    }
}

