/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.recipe;

import java.util.LinkedList;
import java.util.List;
import net.lepko.easycrafting.core.recipe.RecipeManager;
import net.lepko.easycrafting.core.recipe.WrappedRecipe;
import net.lepko.easycrafting.core.util.InventoryUtils;
import net.lepko.easycrafting.core.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class RecipeHelper {
    public static boolean canCraft(WrappedRecipe recipe, IInventory inventory) {
        return RecipeHelper.canCraft(recipe, inventory, null, false, 1, 0) > 0;
    }

    public static boolean canCraft(WrappedRecipe recipe, IInventory inventory, List<WrappedRecipe> recipesToCheck, int recursion) {
        return RecipeHelper.canCraft(recipe, inventory, recipesToCheck, false, 1, recursion) > 0;
    }

    public static int canCraft(WrappedRecipe recipe, IInventory inventory, List<WrappedRecipe> recipesToCheck, boolean take, int maxTimes, int recursion) {
        int timesCrafted;
        if (recursion < 0) {
            return 0;
        }
        recipe.usedIngredients.clear();
        int invSize = InventoryUtils.getMainInventorySize(inventory);
        InventoryBasic tmp = new InventoryBasic("tmp", true, invSize);
        InventoryBasic tmp2 = new InventoryBasic("tmp2", true, invSize);
        InventoryUtils.setContents((IInventory)tmp, inventory);
        block0: for (timesCrafted = 0; timesCrafted < maxTimes; ++timesCrafted) {
            block1: for (int ii = 0; ii < recipe.inputs.size(); ++ii) {
                ItemStack usedItemStack;
                ItemStack is;
                List<WrappedRecipe> list;
                int inventoryIndex;
                if (recipe.inputs.get(ii) instanceof ItemStack) {
                    ItemStack ingredient = (ItemStack)recipe.inputs.get(ii);
                    inventoryIndex = RecipeHelper.isItemInInventory(ingredient, recipe, (IInventory)tmp);
                    if (inventoryIndex != -1 && InventoryUtils.consumeItemForCrafting((IInventory)tmp, inventoryIndex, recipe.usedIngredients)) continue;
                    if (recipesToCheck == null || recursion <= 0) break block0;
                    list = RecipeHelper.getRecipesForItemFromList(ingredient, recipe, recipesToCheck);
                    for (WrappedRecipe wr : list) {
                        if (RecipeHelper.canCraft(wr, (IInventory)tmp, recipesToCheck, true, 1, recursion - 1) <= 0) continue;
                        is = wr.handler.getCraftingResult(wr, wr.usedIngredients);
                        --is.field_77994_a;
                        if (is.field_77994_a > 0 && !InventoryUtils.addItemToInventory((IInventory)tmp, is)) break block0;
                        usedItemStack = is.func_77946_l();
                        usedItemStack.field_77994_a = 1;
                        recipe.usedIngredients.add(usedItemStack);
                        continue block1;
                    }
                } else {
                    List ingredients;
                    if (!(recipe.inputs.get(ii) instanceof List) || (inventoryIndex = RecipeHelper.isItemInInventory(ingredients = (List)recipe.inputs.get(ii), recipe, (IInventory)tmp)) != -1 && InventoryUtils.consumeItemForCrafting((IInventory)tmp, inventoryIndex, recipe.usedIngredients)) continue;
                    if (recipesToCheck == null || recursion <= 0) break block0;
                    list = RecipeHelper.getRecipesForItemFromList(ingredients, recipe, recipesToCheck);
                    for (WrappedRecipe wr : list) {
                        if (RecipeHelper.canCraft(wr, (IInventory)tmp, recipesToCheck, true, 1, recursion - 1) <= 0) continue;
                        is = wr.handler.getCraftingResult(wr, wr.usedIngredients);
                        --is.field_77994_a;
                        if (is.field_77994_a > 0 && !InventoryUtils.addItemToInventory((IInventory)tmp, is)) break block0;
                        usedItemStack = is.func_77946_l();
                        usedItemStack.field_77994_a = 1;
                        recipe.usedIngredients.add(usedItemStack);
                        continue block1;
                    }
                }
                break block0;
            }
            InventoryUtils.setContents((IInventory)tmp2, (IInventory)tmp);
        }
        if (timesCrafted > 0 && take) {
            InventoryUtils.setContents(inventory, (IInventory)tmp2);
        }
        return timesCrafted;
    }

    private static int isItemInInventory(ItemStack is, WrappedRecipe recipe, IInventory inv) {
        int size = InventoryUtils.getMainInventorySize(inv);
        for (int i = 0; i < size; ++i) {
            ItemStack candidate = inv.func_70301_a(i);
            if (candidate == null || !recipe.handler.matchItem(is, candidate, recipe)) continue;
            return i;
        }
        return -1;
    }

    private static int isItemInInventory(List<ItemStack> ing, WrappedRecipe recipe, IInventory inv) {
        for (ItemStack is : ing) {
            int slot = RecipeHelper.isItemInInventory(is, recipe, inv);
            if (slot == -1) continue;
            return slot;
        }
        return -1;
    }

    private static List<WrappedRecipe> getRecipesForItemFromList(ItemStack ingredient, WrappedRecipe recipe, List<WrappedRecipe> recipesToCheck) {
        LinkedList<WrappedRecipe> list = new LinkedList<WrappedRecipe>();
        for (WrappedRecipe wr : recipesToCheck) {
            if (!recipe.handler.matchItem(ingredient, wr.getOutput(), recipe)) continue;
            list.add(wr);
        }
        return list;
    }

    private static List<WrappedRecipe> getRecipesForItemFromList(List<ItemStack> ingredients, WrappedRecipe recipe, List<WrappedRecipe> recipesToCheck) {
        LinkedList<WrappedRecipe> list = new LinkedList<WrappedRecipe>();
        for (ItemStack is : ingredients) {
            list.addAll(RecipeHelper.getRecipesForItemFromList(is, recipe, recipesToCheck));
        }
        return list;
    }

    public static WrappedRecipe getValidRecipe(ItemStack result, ItemStack[] ingredients) {
        List<WrappedRecipe> all = RecipeManager.getAllRecipes();
        block0: for (WrappedRecipe wr : all) {
            if (!StackUtils.areEqualNoSizeNoNBT(wr.getOutput(), result) || wr.inputs.size() != ingredients.length) continue;
            block1: for (int i = 0; i < ingredients.length; ++i) {
                if (wr.inputs.get(i) instanceof ItemStack) {
                    ItemStack is = (ItemStack)wr.inputs.get(i);
                    if (StackUtils.areCraftingEquivalent(is, ingredients[i])) continue;
                    continue block0;
                }
                if (!(wr.inputs.get(i) instanceof List)) continue;
                if (ingredients[i].func_77973_b() == null) {
                    return null;
                }
                List ingList = (List)wr.inputs.get(i);
                if (ingList.isEmpty()) {
                    return null;
                }
                for (ItemStack is : ingList) {
                    if (!StackUtils.areCraftingEquivalent(is, ingredients[i])) continue;
                    continue block1;
                }
                continue block0;
            }
            return wr;
        }
        return null;
    }

    public static int calculateCraftingMultiplierUntilMaxStack(ItemStack result, ItemStack inHand) {
        int maxTimes = MathHelper.func_76128_c((double)((double)result.func_77976_d() / (double)result.field_77994_a));
        if (inHand != null) {
            for (int diff = result.func_77976_d() - maxTimes * result.field_77994_a; inHand.field_77994_a > diff; diff += result.field_77994_a) {
                --maxTimes;
            }
        }
        return maxTimes;
    }
}

