/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.recipe.handler;

import cpw.mods.fml.common.Loader;
import ic2.api.item.ElectricItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.recipe.WrappedRecipe;
import net.lepko.easycrafting.core.recipe.handler.IRecipeHandler;
import net.lepko.easycrafting.core.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.IFluidContainerItem;

public class IC2RecipeHandler
implements IRecipeHandler {
    private static Class<? super IRecipe> shapedRecipeClass = null;
    private static Class<? super IRecipe> shapelessRecipeClass = null;
    private static Method expandArray = null;

    @Override
    public List<Object> getInputs(IRecipe recipe) {
        ArrayList<List> ingredients = null;
        Object[] input = null;
        if (shapedRecipeClass != null && shapelessRecipeClass != null && expandArray != null) {
            try {
                if (shapedRecipeClass.isInstance(recipe)) {
                    input = (Object[])shapedRecipeClass.getField("input").get(recipe);
                } else if (shapelessRecipeClass.isInstance(recipe)) {
                    input = (Object[])shapelessRecipeClass.getField("input").get(recipe);
                }
                if (input != null) {
                    List[] expandedInputs = (List[])expandArray.invoke(null, new Object[]{input});
                    ingredients = new ArrayList<List>(Arrays.asList(expandedInputs));
                }
            }
            catch (Exception e) {
                Ref.LOGGER.warn("[IC2 Recipe Scan] " + recipe.getClass().getName() + " failed!", (Throwable)e);
                return null;
            }
        }
        return ingredients;
    }

    @Override
    public boolean matchItem(ItemStack target, ItemStack candidate, WrappedRecipe recipe) {
        if (candidate == null || target == null) {
            return candidate == target;
        }
        if (target.func_77973_b() != candidate.func_77973_b()) {
            return false;
        }
        return target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == candidate.func_77960_j();
    }

    @Override
    public ItemStack getCraftingResult(WrappedRecipe recipe, List<ItemStack> usedIngredients) {
        ItemStack crafted = recipe.getOutput();
        double charge = 0.0;
        for (ItemStack is : usedIngredients) {
            charge += ElectricItem.manager.getCharge(is);
        }
        ElectricItem.manager.charge(crafted, charge, Integer.MAX_VALUE, true, false);
        if (crafted.func_77973_b() instanceof IFluidContainerItem) {
            StackUtils.getOrCreateNBT(crafted);
        }
        return crafted;
    }

    static {
        if (Loader.isModLoaded((String)"IC2")) {
            try {
                shapedRecipeClass = Class.forName("ic2.core.AdvRecipe");
                shapelessRecipeClass = Class.forName("ic2.core.AdvShapelessRecipe");
                expandArray = shapedRecipeClass.getMethod("expandArray", Object[].class);
            }
            catch (Exception e) {
                Ref.LOGGER.warn("[IC2 Recipe Scan] Adv(Shapeless)Recipe.class could not be obtained!", (Throwable)e);
            }
        } else {
            Ref.LOGGER.info("[IC2 Recipe Scan] Disabled.");
        }
    }
}

