/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.util;

import java.util.ArrayList;
import java.util.List;
import net.lepko.easycrafting.core.util.WrappedStack;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StackUtils {
    public static int canStack(ItemStack first, ItemStack second) {
        if (first != null && second != null && first.func_77985_e() && second.func_77985_e() && StackUtils.areEqualNoSize(first, second)) {
            int i = first.field_77994_a + second.field_77994_a - first.func_77976_d();
            return i < 0 ? 0 : i;
        }
        return -1;
    }

    public static boolean areIdentical(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return first == second;
        }
        return StackUtils.areIdenticalNoSize(first, second) && first.field_77994_a == second.field_77994_a;
    }

    public static boolean areIdenticalNoSize(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.func_77973_b() != second.func_77973_b()) {
            return false;
        }
        return StackUtils.rawDamage(first) == StackUtils.rawDamage(second) && StackUtils.areNBTsEqual(first, second);
    }

    public static boolean areEqualNoSizeNoNBT(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.func_77973_b() != second.func_77973_b()) {
            return false;
        }
        return !first.func_77981_g() || first.func_77960_j() == second.func_77960_j();
    }

    public static boolean areEqualNoSize(ItemStack first, ItemStack second) {
        return StackUtils.areEqualNoSizeNoNBT(first, second) && StackUtils.areNBTsEqual(first, second);
    }

    public static boolean areCraftingEquivalent(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.func_77973_b() != second.func_77973_b()) {
            return false;
        }
        return !first.func_77981_g() || StackUtils.isDamageEquivalent(first.func_77960_j(), second.func_77960_j());
    }

    public static boolean isDamageEquivalent(int first, int second) {
        return first == second || first == Short.MAX_VALUE || second == Short.MAX_VALUE;
    }

    public static int rawDamage(ItemStack stack) {
        return Items.field_151032_g.getDamage(stack);
    }

    public static boolean areNBTsEqual(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.field_77990_d == null || first.field_77990_d.func_82582_d()) {
            return second.field_77990_d == null || second.field_77990_d.func_82582_d();
        }
        if (second.field_77990_d == null || second.field_77990_d.func_82582_d()) {
            return false;
        }
        return first.field_77990_d.equals((Object)second.field_77990_d);
    }

    public static String toString(ItemStack stack) {
        if (stack == null) {
            return "ItemStack [null]";
        }
        String name = stack.func_77973_b() == null ? "null" : stack.func_77973_b().func_77667_c(stack);
        String nbt = stack.field_77990_d == null ? "null" : stack.field_77990_d.toString();
        return String.format("ItemStack [item=%s, meta=%d, size=%d, name=%s, nbt=%s]", stack.func_77973_b(), StackUtils.rawDamage(stack), stack.field_77994_a, name, nbt);
    }

    public static List<WrappedStack> collateStacks(List<? extends Object> inputs) {
        ArrayList<WrappedStack> collated = new ArrayList<WrappedStack>();
        block0: for (Object object : inputs) {
            WrappedStack ws = object instanceof List ? new WrappedStack((List)object) : new WrappedStack((ItemStack)object);
            for (WrappedStack stack : collated) {
                if (!stack.equalsNoSize(ws)) continue;
                ++stack.size;
                continue block0;
            }
            collated.add(ws);
        }
        return collated;
    }

    public static ItemStack copyStack(ItemStack stack, int size) {
        if (stack != null) {
            ItemStack stackCopy = stack.func_77946_l();
            stackCopy.field_77994_a = size;
            return stackCopy;
        }
        return null;
    }

    public static NBTTagCompound getOrCreateNBT(ItemStack stack) {
        NBTTagCompound ret = stack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            stack.func_77982_d(ret);
        }
        return ret;
    }
}

