/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.lepko.easycrafting.core.util.StackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WrappedStack {
    public int size;
    public final List<ItemStack> stacks;

    public WrappedStack(ItemStack stack) {
        if (stack == null) {
            throw new IllegalArgumentException("WrappedStack does not accept null ItemStacks!");
        }
        this.stacks = ImmutableList.of((Object)stack);
        this.size = stack.field_77994_a;
    }

    public WrappedStack(List<ItemStack> stacks) {
        if (stacks == null || stacks.isEmpty()) {
            throw new IllegalArgumentException("WrappedStack does not accept null or empty ItemStack Lists!");
        }
        this.stacks = ImmutableList.copyOf(stacks);
        this.size = 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("WrappedStack [");
        for (ItemStack stack : this.stacks) {
            if (stack != this.stacks.get(0)) {
                sb.append(", ");
            }
            sb.append(StackUtils.toString(stack));
        }
        return sb.append("]").toString();
    }

    public int hashCode() {
        int prime = 92821;
        int result = 1;
        for (ItemStack stack : this.stacks) {
            result = 92821 * result + Item.func_150891_b((Item)stack.func_77973_b());
            result = 92821 * result + StackUtils.rawDamage(stack);
            result = 92821 * result + stack.field_77994_a;
            result = 92821 * result + (stack.field_77990_d == null ? 0 : stack.field_77990_d.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WrappedStack other = (WrappedStack)obj;
        if (this.stacks.size() != other.stacks.size()) {
            return false;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (StackUtils.areIdentical(this.stacks.get(i), other.stacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsNoSize(WrappedStack other) {
        if (this == other) {
            return true;
        }
        if (this.stacks.size() != other.stacks.size()) {
            return false;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (StackUtils.areIdenticalNoSize(this.stacks.get(i), other.stacks.get(i))) continue;
            return false;
        }
        return true;
    }
}

