/*
 * Decompiled with CFR 0.152.
 */
package com.nemock.ShowDurability2.core.handler;

import com.nemock.ShowDurability2.ShowDurability2;
import com.nemock.ShowDurability2.lib.States;
import java.io.File;
import java.util.logging.Level;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration config = new Configuration();
    public static String ARMOR_HUD_ACTIVE = "Armor HUD active";
    public static String ARMOR_HUD_LEFT = "Armor HUD Left";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File file) {
        config = new Configuration(file);
        try {
            config.load();
            config.addCustomCategoryComment("Color Settings", "If this is set to true the durability will be colored like the items health bar.");
            States.colorActive = config.get("Color Settings", "Is color activated?", States.colorActive_DEFAULT).getBoolean(States.colorActive_DEFAULT);
            config.addCustomCategoryComment("Flicker Settings", "If 'Deactivate flicker' is set to false the durability display will flicker when the durability reaches critical levels.\nIn 'flickerPercent' and 'flickerValue' you can set the conditions for the mod considering an items durability as critical.");
            States.flickerOn = config.get("Flicker Settings", "Activated flicker", States.flickerOn_DEFAULT).getBoolean(States.flickerOn_DEFAULT);
            States.flickerPercent = (float)config.get("Flicker settings", "Flicker if durability percent at", States.flickerPercent_DEFAULT).getInt(States.flickerPercent_DEFAULT) / 100.0f;
            States.flickerValue = config.get("Flicker Settings", "Flicker if durability at value", States.flickerValue_DEFAULT).getInt(States.flickerValue_DEFAULT);
            config.addCustomCategoryComment("Display Settings", "Here you can edit how the durability is displayed.\nConsider {0} a variable for the uses left, and {1} for the maximum uses.\nExample: '{0} uses left of {1}' will display '23 uses left of 60'.");
            States.durFormat = config.get("Display Settings", "Durability format", States.durFormat_DEFAULT).getString();
            States.isSD1Loaded = config.get("Display Settings", "Mouseover active?", true).getBoolean(true);
            config.addCustomCategoryComment("Armor", "For an activearmor HUD set 'Display armor HUD' true.\nSet 'Is display on the left?' true do display it on the left and false for the right.\nSet 'Display Armor Icons' to false if you want to display Characters instead of Icons.");
            States.armorHUDActive = config.get("Armor", ARMOR_HUD_ACTIVE, true).getBoolean(States.armorHUDActive_DEFAULT);
            States.armorHUDLeft = config.get("Armor", ARMOR_HUD_LEFT, true).getBoolean(States.armorHUDLeft_DEFAULT);
            States.armorIconsOn = config.get("Armor", "Display Armor Icons", States.armorIconsOn_DEFAULT).getBoolean(States.armorIconsOn_DEFAULT);
            States.armorLayout = config.get("Armor", "Armor layout", States.armorLayout_DEFAULT).getInt(States.armorLayout_DEFAULT);
            States.emptyArmorCaption = config.get("Armor", "Empty armor slot caption", States.emptyArmorCaption_DEFAULT).getString();
        }
        catch (Exception e) {
            ShowDurability2.logger.log(Level.SEVERE, "ShowDurability2 has trouble loading the config");
        }
        finally {
            config.save();
        }
    }
}

