/*
 * Decompiled with CFR 0.152.
 */
package com.nemock.ShowDurability2.core.handler;

import com.nemock.ShowDurability2.lib.States;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.text.MessageFormat;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class HUDRenderEventHandler {
    public Minecraft mc;
    int flag;
    int flag2;
    protected static final RenderItem itemRenderer = new RenderItem();

    public HUDRenderEventHandler(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handleItemTooltip(ItemTooltipEvent event) {
        if (!States.isSD1Loaded) {
            if (event.showAdvancedItemTooltips && event.itemStack.func_77973_b().func_77645_m() && event.toolTip.size() > 1) {
                event.toolTip.remove(event.toolTip.size() - 1);
            }
            if (event.itemStack.func_77973_b().func_77645_m()) {
                event.toolTip.add(1, this.generateDurText(event.itemStack));
            }
        }
    }

    private String generateDurText(ItemStack stack) {
        String result = "";
        result = result + this.getCaption();
        result = result + this.getColor(stack);
        result = result + this.getFormatedDurability(stack);
        if (States.armorHUDActive) {
            result = result + EnumChatFormatting.RESET;
        }
        return result;
    }

    private String getCaption() {
        return "Durability: ";
    }

    private String getColor(ItemStack stack) {
        String color = "";
        if (States.colorActive) {
            int maxDmg = stack.func_77958_k() + 1;
            int durability = maxDmg - stack.func_77952_i();
            color = durability > maxDmg / 4 * 3 ? color + EnumChatFormatting.GREEN : (durability > maxDmg / 4 * 2 ? color + EnumChatFormatting.YELLOW : (durability > maxDmg / 4 ? color + EnumChatFormatting.GOLD : color + EnumChatFormatting.RED));
        }
        return color;
    }

    private String getFormatedDurability(ItemStack stack) {
        String result = "";
        int maxDmg = 0;
        int tmpDmg = 0;
        int durability = 0;
        if (this.isTCTool(stack)) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("InfiTool");
            if (tag.func_74764_b("BaseDurability")) {
                maxDmg = tag.func_74762_e("BaseDurability") + 1 + tag.func_74762_e("BonusDurability");
                tmpDmg = tag.func_74762_e("Damage");
            }
        } else {
            maxDmg = stack.func_77958_k() + 1;
            tmpDmg = stack.func_77952_i();
        }
        durability = maxDmg - tmpDmg;
        Object[] stats = new Object[]{Integer.toString(durability), Integer.toString(maxDmg)};
        MessageFormat durString = new MessageFormat(States.durFormat);
        result = durString.format(stats);
        return result;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderHUD(RenderGameOverlayEvent.Text event) {
        EntityClientPlayerMP thePlayer = Minecraft.func_71410_x().field_71439_g;
        this.durabilityBar((EntityPlayer)thePlayer);
        if (States.armorHUDActive) {
            this.armodHUD((EntityPlayer)thePlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderArmorIcons(RenderGameOverlayEvent event) {
        if (States.armorIconsOn) {
            if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
                return;
            }
            EntityClientPlayerMP thePlayer = Minecraft.func_71410_x().field_71439_g;
            if (States.armorHUDActive) {
                this.renderArmorIcons((EntityPlayer)thePlayer);
            }
        }
    }

    private void durabilityBar(EntityPlayer player) {
        if (this.flag <= 30) {
            ItemStack heldItem;
            Item coreItem;
            if (player.func_71045_bC() != null && ((coreItem = (heldItem = player.func_71045_bC()).func_77973_b()).func_77616_k(heldItem) || this.isTCTool(heldItem))) {
                int color;
                NBTTagCompound tag;
                int mxtmp = heldItem.func_77958_k() + 1;
                int dmgtmp = heldItem.func_77952_i();
                boolean broken = false;
                if (this.isTCTool(heldItem) && (tag = heldItem.func_77978_p().func_74775_l("InfiTool")).func_74764_b("BaseDurability")) {
                    mxtmp = tag.func_74762_e("BaseDurability") + 1 + tag.func_74762_e("BonusDurability");
                    dmgtmp = tag.func_74762_e("Damage");
                    broken = tag.func_74767_n("Broken");
                }
                int dur = mxtmp - dmgtmp;
                if (broken) {
                    dur = 0;
                }
                Object[] stats = new Object[]{Integer.toString(dur), Integer.toString(mxtmp)};
                MessageFormat durString = new MessageFormat(States.durFormat);
                String durDisp = durString.format(stats);
                ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                FontRenderer fontRender = this.mc.field_71466_p;
                int width = res.func_78326_a();
                int height = res.func_78328_b();
                this.mc.field_71460_t.func_78478_c();
                int heightAdjustor = 48;
                int widthAdjustor = 91;
                if (player.func_70055_a(Material.field_151586_h)) {
                    heightAdjustor = 58;
                }
                if (player.field_71075_bZ.field_75098_d) {
                    heightAdjustor = player.func_70115_ae() ? 39 : 35;
                }
                if (!player.field_71075_bZ.field_75098_d && player.func_70115_ae()) {
                    widthAdjustor = -90;
                }
                String text = durDisp;
                int x = width / 2 + widthAdjustor - fontRender.func_78256_a(text);
                int y = height - heightAdjustor;
                if (!player.field_71075_bZ.field_75098_d && player.func_70115_ae()) {
                    boolean check;
                    boolean bl = check = player.field_71071_by.field_70460_b[0] != null && player.field_71071_by.field_70460_b[1] != null && player.field_71071_by.field_70460_b[2] != null && player.field_71071_by.field_70460_b[3] != null;
                    if (check) {
                        heightAdjustor = 58;
                        if (player.func_70644_a(Potion.field_76444_x)) {
                            heightAdjustor = 68;
                        }
                    }
                    y = height - heightAdjustor;
                    x = width / 2 - 91;
                }
                if (States.colorActive) {
                    int green = (int)((float)dur / ((float)mxtmp / 100.0f) * 2.55f);
                    int red = 255 - green;
                    color = (green << 8) + (red << 16);
                } else {
                    color = 0xFFFFFF;
                }
                fontRender.func_78261_a(text, x, y, color);
                if ((float)dur <= (float)mxtmp * States.flickerPercent && dur <= States.flickerValue && States.flickerOn) {
                    ++this.flag;
                    ++this.flag2;
                }
            }
        } else if (this.flag2 <= 0) {
            this.flag = this.flag2;
        } else {
            this.flag2 -= 3;
        }
    }

    private void armodHUD(EntityPlayer player) {
        ItemStack[] armor = this.getCompleteArmor(player);
        String[] dispText = this.getArmorDispText(armor);
        ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        FontRenderer fontRender = this.mc.field_71466_p;
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        this.mc.field_71460_t.func_78478_c();
        for (int i = 0; i <= 3; ++i) {
            int color = 0xFFFFFF;
            if (armor[i] != null) {
                if (States.colorActive) {
                    int green = (int)((float)(armor[i].func_77958_k() - armor[i].func_77952_i()) / ((float)armor[i].func_77958_k() / 100.0f) * 2.55f);
                    int red = 255 - green;
                    color = (green << 8) + (red << 16);
                }
            } else {
                color = 0xFFFFFF;
            }
            int heightAdjustor = 10 + this.getHightMultiplicator() * i;
            int x = width / 2 - this.widthAdjustor(armor, fontRender);
            int y = height - heightAdjustor;
            fontRender.func_78261_a(dispText[i], x, y, color);
        }
    }

    private void renderArmorIcons(EntityPlayer player) {
        ItemStack[] armor = this.getCompleteArmor(player);
        ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        FontRenderer fontRender = this.mc.field_71466_p;
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        this.mc.field_71460_t.func_78478_c();
        for (int i = 0; i <= 3; ++i) {
            int[] bumper_x = new int[]{4, 16, 4, 16};
            int[] altbumper_x = new int[]{4, 4, 4, 4};
            if (States.armorLayout == 1) {
                bumper_x = altbumper_x;
            }
            int bumper_y = 4;
            int heightAdjustor = 10 + this.getHightMultiplicator() * i;
            int x = width / 2 - this.widthAdjustor(armor, fontRender);
            int y = height - heightAdjustor;
            if (armor[i] != null) {
                this.drawArmorIcon(armor[i], fontRender, x - bumper_x[i], y - bumper_y);
                continue;
            }
            this.drawEmptyArmorIcon(ItemArmor.func_94602_b((int)(3 - i)), x - bumper_x[i], y - bumper_y);
        }
    }

    private void drawArmorIcon(ItemStack theItem, FontRenderer renderer, int x, int y) {
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110576_c);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        itemRenderer.func_82406_b(renderer, this.mc.func_110434_K(), theItem, x, y);
        RenderHelper.func_74518_a();
    }

    private void drawEmptyArmorIcon(IIcon icon, int x, int y) {
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110576_c);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        itemRenderer.func_94149_a(x, y, icon, 16, 16);
        RenderHelper.func_74518_a();
    }

    private ItemStack[] getCompleteArmor(EntityPlayer player) {
        ItemStack[] armor = new ItemStack[4];
        for (int i = 0; i <= 3; ++i) {
            armor[i] = player.func_82169_q(i);
        }
        return armor;
    }

    private String[] getArmorDispText(ItemStack[] armor) {
        String[] dispText = new String[4];
        String[] type = new String[]{"B: ", "P: ", "C: ", "H: "};
        if (States.armorIconsOn) {
            type = new String[]{"   ", "   ", "   ", "   "};
        }
        for (int i = 0; i <= 3; ++i) {
            if (armor[i] != null) {
                int maxUses = armor[i].func_77958_k() + 1;
                int leftUses = maxUses - armor[i].func_77952_i();
                Object[] stats = new Object[]{Integer.toString(leftUses), Integer.toString(maxUses)};
                MessageFormat statString = new MessageFormat(States.durFormat);
                dispText[i] = type[i] + statString.format(stats);
                continue;
            }
            dispText[i] = type[i] + States.emptyArmorCaption;
        }
        return dispText;
    }

    private int getHightMultiplicator() {
        if (States.armorLayout == 1) {
            if (States.armorIconsOn) {
                return 13;
            }
            return 9;
        }
        return 9;
    }

    private int widthAdjustor(ItemStack[] armor, FontRenderer fontRender) {
        if (States.armorHUDLeft) {
            return 95 + this.getMaxStringWidth(armor, fontRender);
        }
        if (States.armorLayout != 1) {
            return -106;
        }
        return -96;
    }

    private int getMaxStringWidth(ItemStack[] armor, FontRenderer render) {
        String[] toCompare = this.getArmorDispText(armor);
        int comperator = 0;
        for (int i = 0; i <= 3; ++i) {
            if (comperator > render.func_78256_a(toCompare[i])) continue;
            comperator = render.func_78256_a(toCompare[i]);
        }
        return comperator;
    }

    private boolean isTCTool(ItemStack stack) {
        boolean isTCItem = stack.func_77942_o() && stack.field_77990_d.func_74764_b("InfiTool");
        return isTCItem && !stack.func_77985_e();
    }
}

