/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api;

import com.google.common.collect.LinkedHashMultimap;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.api.ClientAPI;
import journeymap.client.api.map.ImageOverlay;
import journeymap.client.api.map.MarkerOverlay;
import journeymap.client.api.map.PolygonOverlay;
import journeymap.client.api.map.WaypointDefinition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientAPIFactory {
    public static final String API_OWNER = "journeymap";
    public static final String API_VERSION = "0.3";
    public static final String API_PROVIDES_API = "journeymap|client-api";
    public static final String API_PROVIDES_MAP = "journeymap|client-api-map";
    public static final String API_PROVIDES_UTIL = "journeymap|client-api-util";
    public static final String API_PROVIDES_IMPL = "journeymap|client-api-impl";
    static final Logger LOGGER = LogManager.getLogger((String)"journeymap-api");
    static final String IMPL_NAME = "JourneyMap ClientAPI v0.3";
    static final String IMPL_CLASS = "journeymap.client.api.impl.ClientAPIImpl";
    static final String STUB_IMPL_CLASS = Stub.class.getName();

    public static boolean isJourneyMapPresent() {
        try {
            return ClientAPIFactory._getInstance(IMPL_CLASS) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static ClientAPI getInstance() {
        try {
            return ClientAPIFactory._getInstance(IMPL_CLASS);
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("JourneyMap ClientAPI v0.3 not found");
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("JourneyMap ClientAPI v0.3 is corrupt, INSTANCE enum missing.", (Throwable)e);
        }
        catch (ClassCastException e) {
            LOGGER.error("JourneyMap ClientAPI v0.3 is corrupt, INSTANCE enum isn't a ClientAPI", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("JourneyMap ClientAPI v0.3 isn't usable.", (Throwable)e);
        }
        return null;
    }

    public static ClientAPI getStub() {
        try {
            return ClientAPIFactory._getInstance(STUB_IMPL_CLASS);
        }
        catch (Throwable e) {
            LOGGER.error(STUB_IMPL_CLASS + " isn't usable!", e);
            return null;
        }
    }

    private static ClientAPI _getInstance(String implClassName) throws ClassNotFoundException, ClassCastException, IllegalArgumentException, IllegalAccessException {
        Class<?> implClass = Class.forName(implClassName);
        return (ClientAPI)Enum.valueOf(implClass, "INSTANCE");
    }

    private static enum Stub implements ClientAPI
    {
        INSTANCE;

        private LinkedHashMultimap<String, String> waypointIds = LinkedHashMultimap.create();
        private LinkedHashMultimap<String, String> imageIds = LinkedHashMultimap.create();
        private LinkedHashMultimap<String, String> markerIds = LinkedHashMultimap.create();
        private LinkedHashMultimap<String, String> polygonIds = LinkedHashMultimap.create();

        @Override
        public boolean getPlayerAcceptsWaypoints(String modId) {
            return true;
        }

        @Override
        public boolean getPlayerAcceptsOverlays(String modId) {
            return true;
        }

        @Override
        public void addWaypoint(String modId, WaypointDefinition waypointDefinition) {
            this.waypointIds.put((Object)modId, (Object)waypointDefinition.getWaypointId());
            this.log("Added waypoint " + waypointDefinition.getWaypointId());
        }

        @Override
        public void removeWaypoint(String modId, String waypointId) {
            this.waypointIds.remove((Object)modId, (Object)waypointId);
            this.log("Removed waypoint " + waypointId);
        }

        @Override
        public boolean getWaypointExists(String modId, String waypointId) {
            return this.waypointIds.containsEntry((Object)modId, (Object)waypointId);
        }

        @Override
        public List<String> getWaypointIds(String modId) {
            return new ArrayList<String>(this.waypointIds.get((Object)modId));
        }

        @Override
        public void addMarker(String modId, MarkerOverlay markerOverlay) {
            this.markerIds.put((Object)modId, (Object)markerOverlay.getMarkerId());
            this.log("Added marker " + markerOverlay.getMarkerId());
        }

        @Override
        public List<String> getMarkerIds(String modId) {
            return new ArrayList<String>(this.markerIds.get((Object)modId));
        }

        @Override
        public void addImage(String modId, ImageOverlay imageOverlay) {
            this.imageIds.put((Object)modId, (Object)imageOverlay.getImageId());
        }

        @Override
        public void removeImage(String modId, String imageId) {
            this.imageIds.remove((Object)modId, (Object)imageId);
        }

        @Override
        public boolean getImageExists(String modId, String imageId) {
            return this.imageIds.containsEntry((Object)modId, (Object)imageId);
        }

        @Override
        public List<String> getImageIds(String modId) {
            return new ArrayList<String>(this.imageIds.get((Object)modId));
        }

        @Override
        public void removeMarker(String modId, String markerId) {
            this.markerIds.remove((Object)modId, (Object)markerId);
            this.log("Removed marker " + markerId);
        }

        @Override
        public boolean getMarkerExists(String modId, String markerId) {
            return this.markerIds.containsEntry((Object)modId, (Object)markerId);
        }

        @Override
        public void addPolygon(String modId, PolygonOverlay polygonOverlay) {
            this.polygonIds.put((Object)modId, (Object)polygonOverlay.getPolygonId());
            this.log("Added polygon " + polygonOverlay.getPolygonId());
        }

        @Override
        public List<String> getPolygonIds(String modId) {
            return new ArrayList<String>(this.polygonIds.get((Object)modId));
        }

        @Override
        public void removePolygon(String modId, String polygonId) {
            this.polygonIds.remove((Object)modId, (Object)polygonId);
            this.log("Removed polygon " + polygonId);
        }

        @Override
        public boolean getPolygonExists(String modId, String polygonId) {
            return this.polygonIds.containsEntry((Object)modId, (Object)polygonId);
        }

        private void log(String message) {
            LOGGER.info(String.format("[%s Stub] %s", ClientAPIFactory.IMPL_NAME, message));
        }
    }
}

