/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.map;

import com.google.common.base.Objects;
import com.google.common.base.Verify;
import journeymap.client.api.map.MapIcon;
import journeymap.client.api.map.MapPoint;
import journeymap.client.api.map.OverlayBase;

public final class ImageOverlay
extends OverlayBase {
    private String imageId;
    private MapPoint northWestPoint;
    private MapPoint southEastPoint;
    private MapIcon image;

    public ImageOverlay(String imageId, MapPoint northWestPoint, MapPoint southEastPoint, MapIcon image) {
        this(imageId, null, northWestPoint, southEastPoint, null, null, image);
    }

    public ImageOverlay(String imageId, String overlayGroupName, MapPoint northWestPoint, MapPoint southEastPoint, String title, String label, MapIcon image) {
        Verify.verifyNotNull((Object)imageId);
        Verify.verifyNotNull((Object)image);
        Verify.verifyNotNull((Object)northWestPoint);
        Verify.verifyNotNull((Object)southEastPoint);
        this.imageId = imageId;
        this.image = image.copyOf();
        this.northWestPoint = northWestPoint.copyOf();
        this.southEastPoint = southEastPoint.copyOf();
        super.setOverlayGroupName(overlayGroupName);
        super.setTitle(title);
        super.setLabel(label);
    }

    public String getImageId() {
        return this.imageId;
    }

    public MapPoint getNorthWestPoint() {
        return this.northWestPoint;
    }

    public MapPoint getSouthEastPoint() {
        return this.southEastPoint;
    }

    public MapIcon getImage() {
        return this.image;
    }

    public ImageOverlay copyOf() {
        ImageOverlay copy = new ImageOverlay(this.imageId, this.overlayGroupName, this.northWestPoint, this.southEastPoint, this.title, this.label, this.image);
        this.copyValuesInto(copy);
        return copy;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("imageId", (Object)this.imageId).add("northWestPoint", (Object)this.northWestPoint).add("southEastPoint", (Object)this.southEastPoint).add("image", (Object)this.image).add("label", (Object)this.label).add("title", (Object)this.title).add("overlayGroupName", (Object)this.overlayGroupName).add("color", this.color).add("inFullscreen", this.inFullscreen).add("inMinimap", this.inMinimap).add("inWebmap", this.inWebmap).add("maxZoom", this.maxZoom).add("minZoom", this.minZoom).add("zIndex", this.zIndex).toString();
    }
}

