/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.map;

import com.google.common.base.Objects;
import com.google.common.base.Verify;

public final class MapIcon {
    private String resourceLocation;
    private int originX;
    private int originY;
    private int width;
    private int height;
    private int color = 0xFFFFFF;
    private float opacity;
    private float anchorX;
    private float anchorY;

    public MapIcon(String resourceLocation, int width, int height) {
        this(resourceLocation, 0, 0, width, height);
    }

    public MapIcon(String resourceLocation, int originX, int originY, int width, int height) {
        Verify.verifyNotNull((Object)resourceLocation);
        this.resourceLocation = resourceLocation;
        this.originX = originX;
        this.originY = originY;
        this.width = width;
        this.height = height;
        this.setAnchor((float)width / 2.0f, (float)height / 2.0f);
    }

    public void setAnchor(float anchorX, float anchorY) {
        this.anchorX = anchorX;
        this.anchorY = anchorY;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = Math.max(0, Math.min(color, 0xFFFFFF));
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = Math.max(0.0f, Math.min(opacity, 1.0f));
    }

    public float getAnchorX() {
        return this.anchorX;
    }

    public float getAnchorY() {
        return this.anchorY;
    }

    public MapIcon copyOf() {
        MapIcon icon = new MapIcon(this.resourceLocation, this.originX, this.originY, this.width, this.height);
        icon.setAnchor(this.anchorX, this.anchorY);
        icon.setColor(this.color);
        icon.setOpacity(this.opacity);
        return icon;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("resourceLocation", (Object)this.resourceLocation).add("anchorX", this.anchorX).add("anchorY", this.anchorY).add("color", this.color).add("opacity", this.opacity).add("height", this.height).add("originX", this.originX).add("originY", this.originY).add("width", this.width).toString();
    }
}

