/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.map;

import com.google.common.base.Objects;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import journeymap.client.api.map.MapPoint;

public final class MapPolygon {
    private ArrayList<MapPoint> points = new ArrayList(4);

    public MapPolygon(List<MapPoint> pointsList) {
        Verify.verifyNotNull(pointsList);
        if (pointsList.size() < 4) {
            throw new IllegalArgumentException("MapPolygon must have at least 4 points.");
        }
        if (!pointsList.get(0).equals(pointsList.get(pointsList.size() - 1))) {
            throw new IllegalArgumentException("MapPolygon must have equal first and last points.");
        }
        for (MapPoint point : pointsList) {
            this.points.add(point.copyOf());
        }
    }

    public Iterator<MapPoint> iterator() {
        return null;
    }

    public MapPolygon copyOf() {
        return new MapPolygon(this.points);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("points", this.points).toString();
    }
}

