/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.map;

import com.google.common.base.Objects;
import com.google.common.base.Verify;
import journeymap.client.api.map.MapIcon;
import journeymap.client.api.map.MapPoint;
import journeymap.client.api.map.OverlayBase;

public final class MarkerOverlay
extends OverlayBase {
    private String markerId;
    private MapPoint point;
    private MapIcon icon;

    public MarkerOverlay(String markerId, MapPoint point, MapIcon icon) {
        this(markerId, null, point, null, null, icon);
    }

    public MarkerOverlay(String markerId, String overlayGroupName, MapPoint point, String title, String label, MapIcon icon) {
        Verify.verifyNotNull((Object)markerId);
        Verify.verifyNotNull((Object)icon);
        Verify.verifyNotNull((Object)point);
        this.markerId = markerId;
        this.icon = icon.copyOf();
        this.point = point.copyOf();
        super.setOverlayGroupName(overlayGroupName);
        super.setTitle(title);
        super.setLabel(label);
    }

    public String getMarkerId() {
        return this.markerId;
    }

    public MapPoint getPoint() {
        return this.point;
    }

    public MapIcon getIcon() {
        return this.icon;
    }

    public MarkerOverlay copyOf() {
        MarkerOverlay copy = new MarkerOverlay(this.markerId, this.overlayGroupName, this.point, this.title, this.label, this.icon);
        this.copyValuesInto(copy);
        return copy;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("markerId", (Object)this.markerId).add("point", (Object)this.point).add("icon", (Object)this.icon).add("label", (Object)this.label).add("title", (Object)this.title).add("overlayGroupName", (Object)this.overlayGroupName).add("color", this.color).add("inFullscreen", this.inFullscreen).add("inMinimap", this.inMinimap).add("inWebmap", this.inWebmap).add("maxZoom", this.maxZoom).add("minZoom", this.minZoom).add("zIndex", this.zIndex).toString();
    }
}

