/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.map;

import com.google.common.base.Objects;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.api.map.MapPolygon;
import journeymap.client.api.map.OverlayBase;

public final class PolygonOverlay
extends OverlayBase {
    private String polygonId;
    private MapPolygon outerArea;
    private List<MapPolygon> holes;
    private float strokeWidth = 2.0f;
    private int strokeColor = 0xFFFFFF;
    private float strokeOpacity = 1.0f;
    private int fillColor = 0;
    private float fillOpacity = 0.5f;

    public PolygonOverlay(String polygonId, String overlayGroupName, MapPolygon outerArea) {
        this(polygonId, overlayGroupName, null, null, outerArea, null);
    }

    public PolygonOverlay(String polygonId, String overlayGroupName, String title, String label, MapPolygon outerArea, List<MapPolygon> holes) {
        Verify.verifyNotNull((Object)polygonId);
        this.polygonId = polygonId;
        Verify.verifyNotNull((Object)polygonId);
        this.outerArea = outerArea.copyOf();
        this.holes = new ArrayList<MapPolygon>(holes.size());
        for (MapPolygon hole : holes) {
            this.holes.add(hole.copyOf());
        }
        super.setOverlayGroupName(overlayGroupName);
        super.setTitle(title);
        super.setLabel(label);
    }

    public void setStyle(float strokeWidth, int strokeColor, float strokeOpacity, int fillColor, float fillOpacity) {
        this.setStrokeWidth(strokeWidth);
        this.setStrokeColor(strokeColor);
        this.setStrokeOpacity(strokeOpacity);
        this.setFillColor(fillColor);
        this.setFillOpacity(fillOpacity);
    }

    public String getPolygonId() {
        return this.polygonId;
    }

    public MapPolygon getOuterArea() {
        return this.outerArea;
    }

    public List<MapPolygon> getHoles() {
        return this.holes;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(int strokeColor) {
        this.strokeColor = Math.max(0, Math.min(strokeColor, 0xFFFFFF));
    }

    public float getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public void setStrokeOpacity(float strokeOpacity) {
        this.strokeOpacity = Math.max(0.0f, Math.min(strokeOpacity, 1.0f));
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = Math.max(0, Math.min(fillColor, 0xFFFFFF));
    }

    public float getFillOpacity() {
        return this.fillOpacity;
    }

    public void setFillOpacity(float fillOpacity) {
        this.fillOpacity = Math.max(0.0f, Math.min(fillOpacity, 1.0f));
    }

    public PolygonOverlay copyOf() {
        PolygonOverlay copy = new PolygonOverlay(this.polygonId, this.overlayGroupName, this.title, this.label, this.outerArea, this.holes);
        copy.setStyle(this.strokeWidth, this.strokeColor, this.strokeOpacity, this.fillColor, this.fillOpacity);
        this.copyValuesInto(copy);
        return copy;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("polygonId", (Object)this.polygonId).add("label", (Object)this.label).add("title", (Object)this.title).add("overlayGroupName", (Object)this.overlayGroupName).add("outerArea", (Object)this.outerArea).add("holes", this.holes).add("fillColor", this.fillColor).add("fillOpacity", this.fillOpacity).add("strokeColor", this.strokeColor).add("strokeOpacity", this.strokeOpacity).add("strokeWidth", this.strokeWidth).add("color", this.color).add("inFullscreen", this.inFullscreen).add("inMinimap", this.inMinimap).add("inWebmap", this.inWebmap).add("maxZoom", this.maxZoom).add("minZoom", this.minZoom).add("zIndex", this.zIndex).toString();
    }
}

