/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.map;

import com.google.common.base.Verify;
import journeymap.client.api.map.MapIcon;
import journeymap.client.api.map.MapPoint;

public final class WaypointDefinition {
    private String waypointId;
    private String waypointGroupName;
    private String waypointName;
    private MapPoint point;
    private int[] dimensions;
    private int color;
    private MapIcon icon;

    public WaypointDefinition(String waypointId, String waypointGroupName, String waypointName, MapPoint point, MapIcon icon, int color, int[] dimensions) {
        Verify.verifyNotNull((Object)waypointId);
        Verify.verifyNotNull((Object)waypointName);
        Verify.verifyNotNull((Object)point);
        Verify.verifyNotNull((Object)icon);
        this.waypointId = waypointId;
        this.waypointGroupName = waypointGroupName;
        this.waypointName = waypointName;
        this.point = point.copyOf();
        this.icon = icon.copyOf();
        this.color = Math.max(0, Math.min(color, 0xFFFFFF));
        this.dimensions = dimensions;
    }

    public String getWaypointId() {
        return this.waypointId;
    }

    public String getWaypointGroupName() {
        return this.waypointGroupName;
    }

    public String getWaypointName() {
        return this.waypointName;
    }

    public MapPoint getPoint() {
        return this.point;
    }

    public int getColor() {
        return this.color;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public MapIcon getIcon() {
        return this.icon;
    }

    public WaypointDefinition copyOf() {
        WaypointDefinition copy = new WaypointDefinition(this.waypointId, this.waypointGroupName, this.waypointName, this.point, this.icon, this.color, this.dimensions);
        return copy;
    }
}

