/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import java.io.IOException;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.apache.logging.log4j.Logger;

public class ChunkLoader {
    private static Logger logger = Journeymap.getLogger();

    public static ChunkMD getChunkMD(AnvilChunkLoader loader, Minecraft mc, ChunkCoordIntPair coord, boolean forceRetain) {
        try {
            if (RegionLoader.getRegionFile(mc, coord.field_77276_a, coord.field_77275_b).exists()) {
                if (loader.chunkExists((World)mc.field_71441_e, coord.field_77276_a, coord.field_77275_b)) {
                    Chunk chunk = loader.func_75815_a((World)mc.field_71441_e, coord.field_77276_a, coord.field_77275_b);
                    if (chunk != null) {
                        chunk.func_76603_b();
                        return new ChunkMD(chunk, forceRetain);
                    }
                    logger.warn("AnvilChunkLoader returned null for chunk: " + coord);
                }
            } else {
                logger.warn("Region doesn't exist for chunk: " + coord);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ChunkMD getChunkMdFromMemory(World world, int chunkX, int chunkZ) {
        Chunk theChunk;
        if (world.func_72863_F().func_73149_a(chunkX, chunkZ) && ForgeHelper.INSTANCE.hasChunkData(theChunk = world.func_72964_e(chunkX, chunkZ))) {
            return new ChunkMD(theChunk);
        }
        return null;
    }
}

