/*
 * Decompiled with CFR 0.152.
 */
package rowautomation;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.world.WorldEvent;
import net.row.stock.core.RoWRollingStock;
import rowautomation.ROWAM;

public class Chunkloader
implements ForgeChunkManager.LoadingCallback {
    private Entity stock;
    private String stockName;
    private Map<Entity, ForgeChunkManager.Ticket> stockTickets = Maps.newHashMap();
    private static Map<Block, ForgeChunkManager.Ticket> blockTickets = Maps.newHashMap();
    public static List<Entity> stockList = new ArrayList<Entity>();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket modTicket : tickets) {
            if (!modTicket.getModId().equals("rowam")) continue;
            modTicket.setChunkListDepth(1);
            if (modTicket.getType().equals((Object)ForgeChunkManager.Type.ENTITY)) {
                this.stockTickets.put(modTicket.getEntity(), modTicket);
                continue;
            }
            int[] blockPos = modTicket.getModData().func_74759_k("blockPos");
            if (blockPos.length != 0) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)modTicket, (ChunkCoordIntPair)world.func_72938_d(blockPos[0], blockPos[2]).func_76632_l());
                blockTickets.put(world.func_147439_a(blockPos[0], blockPos[1], blockPos[2]), modTicket);
                continue;
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)modTicket);
        }
    }

    private void setStockTicket(Entity stock, World world) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)ROWAM.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        ticket.setChunkListDepth(1);
        ticket.bindEntity(stock);
        this.stockTickets.put(stock, ticket);
    }

    public static void addBlockTicket(Block block, World world, int x, int y, int z) {
        ForgeChunkManager.Ticket blockTicket = ForgeChunkManager.requestTicket((Object)ROWAM.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        blockTicket.setChunkListDepth(1);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)blockTicket, (ChunkCoordIntPair)world.func_72938_d(x, z).func_76632_l());
        blockTicket.getModData().func_74783_a("blockPos", new int[]{x, y, z});
        blockTickets.put(block, blockTicket);
    }

    public static void removeBlockTicket(Block block) {
        if (blockTickets.containsKey(block)) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)blockTickets.get(block));
            blockTickets.remove(block);
        }
    }

    @SubscribeEvent
    public void onWorldUnloadEvent(WorldEvent.Unload event) {
        this.stockTickets.clear();
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        stockList.clear();
        for (int i = 0; i < event.world.field_72996_f.size(); ++i) {
            this.stock = (Entity)event.world.field_72996_f.get(i);
            if (!(this.stock instanceof RoWRollingStock)) continue;
            stockList.add(this.stock);
            if (event.world.field_72995_K) continue;
            if (!this.stockTickets.containsKey(this.stock)) {
                this.setStockTicket(this.stock, event.world);
                continue;
            }
            if (this.stock.field_70128_L) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.stockTickets.get(this.stock));
                this.stockTickets.remove(this.stock);
                continue;
            }
            ForgeChunkManager.Ticket stockTicket = this.stockTickets.get(this.stock);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)stockTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(stockTicket.getEntity().field_70176_ah, stockTicket.getEntity().field_70164_aj));
            this.stockTickets.put(this.stock, stockTicket);
        }
    }
}

