/*
 * Decompiled with CFR 0.152.
 */
package rowautomation.tileentities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.row.entity.EntityCartRider;
import net.row.stock.cart.CartIII2L12;
import net.row.stock.cart.CartNTV;
import net.row.stock.core.RoWLocomotive;
import net.row.stock.core.RoWRollingStock;
import net.row.stock.core.plugin.RegulatorA;
import rowautomation.tileentities.TileEntityBase;

public class TileEntityStation
extends TileEntityBase {
    public int opMode = 1;
    public int reverseSet = 5;
    public int regulatorSet = 5;
    public int ticks = 1;
    public int tickDelay = 500;
    public int whistleMode = 1;
    public int loadingOps = 0;
    public int unloadingOps = 100;
    public float whistleVolume = 1.0f;
    public float whistlePitch = 1.0f;
    public long scheduledTime = 0L;
    public String locoLabel = "";

    public void func_145845_h() {
        this.changeOpStatus(false);
        RoWLocomotive locomotive = (RoWLocomotive)this.getNearbyStock(RoWLocomotive.class, this.range);
        if (locomotive == null) {
            return;
        }
        if (locomotive.reverse != 0) {
            return;
        }
        if (!this.locoLabel.equals("") && !locomotive.label.equals(this.locoLabel)) {
            return;
        }
        this.changeOpStatus(true);
        if (!locomotive.isBrakeOn) {
            locomotive.isBrakeOn = true;
            if (!this.field_145850_b.field_72995_K) {
                this.unmountEntities();
            }
            if (this.whistleMode == 2 || this.whistleMode == 4) {
                this.blowWhistle(locomotive);
            }
        }
        if (this.opMode == 1) {
            ++this.ticks;
            if (this.ticks < this.tickDelay) {
                return;
            }
        }
        if (this.opMode == 2 && this.field_145850_b.func_72820_D() % 24000L != this.scheduledTime) {
            return;
        }
        if (this.opMode == 3 && this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 0) {
            return;
        }
        locomotive.reverse = (int)((float)this.reverseSet / 100.0f * 300.0f);
        if (locomotive instanceof RegulatorA) {
            RegulatorA locoReg = (RegulatorA)locomotive;
            locoReg.setRegulator(locoReg.getRegulatorMax() * this.regulatorSet / 100);
        }
        locomotive.isBrakeOn = false;
        if (!this.field_145850_b.field_72995_K) {
            this.mountEntities();
        }
        if (this.whistleMode == 3 || this.whistleMode == 4) {
            this.blowWhistle(locomotive);
        }
        this.changeOpStatus(false);
        this.ticks = 1;
    }

    private void blowWhistle(RoWLocomotive locomotive) {
        this.field_145850_b.func_72980_b(locomotive.field_70165_t, locomotive.field_70163_u, locomotive.field_70161_v, "row:" + locomotive.hornSound, this.whistleVolume, this.whistlePitch, true);
    }

    private void mountEntities() {
        List<RoWRollingStock> stockList = this.getAllNearbyStock(RoWRollingStock.class, this.stationCartRange);
        for (int i = 0; i < stockList.size(); ++i) {
            RoWRollingStock stock = stockList.get(i);
            if (!this.isValidMountingStock((Entity)stock, this.loadingOps) || !(stock.field_70159_w < 1.0) || !(stock.field_70179_y < 1.0)) continue;
            double[] mountingOffset = this.getMountingOffset((Entity)stock, this.loadingOps);
            AxisAlignedBB loadingArea = mountingOffset[0] == 0.0 ? stock.field_70121_D.func_72314_b(5.0, 5.0, 5.0) : stock.field_70121_D.func_72317_d(mountingOffset[0], mountingOffset[1], mountingOffset[2]).func_72314_b(2.0, 2.0, 2.0);
            List entityList = this.field_145850_b.func_72839_b((Entity)stock, loadingArea);
            for (int j = 0; j < entityList.size(); ++j) {
                Entity testEntity = (Entity)entityList.get(j);
                if (!this.isValidMountingEntity(testEntity, this.loadingOps)) continue;
                EntityCartRider seat = new EntityCartRider(stock);
                this.field_145850_b.func_72838_d((Entity)seat);
                testEntity.func_70078_a((Entity)seat);
            }
        }
    }

    private void unmountEntities() {
        List<RoWRollingStock> stockList = this.getAllNearbyStock(RoWRollingStock.class, this.stationCartRange);
        for (int i = 0; i < stockList.size(); ++i) {
            RoWRollingStock stock = stockList.get(i);
            if (!(stock.field_70159_w < 10.0) || !(stock.field_70179_y < 10.0) || !this.isValidMountingStock((Entity)stock, this.unloadingOps)) continue;
            List seatEntites = this.field_145850_b.func_72872_a(EntityCartRider.class, stock.field_70121_D.func_72314_b(5.0, 5.0, 5.0));
            for (int j = 0; j < seatEntites.size(); ++j) {
                Entity ridingEntity;
                EntityCartRider seat = (EntityCartRider)seatEntites.get(j);
                if (seat.field_70153_n == null || !stock.UUID.equals(seat.parentUUID) || !this.isValidMountingEntity(ridingEntity = seat.field_70153_n, this.unloadingOps)) continue;
                ridingEntity.func_70078_a(null);
                double[] mountingOffset = this.getMountingOffset((Entity)stock, this.unloadingOps);
                ridingEntity.func_70091_d(mountingOffset[0], mountingOffset[1], mountingOffset[2]);
                ridingEntity.field_70143_R = 0.0f;
            }
        }
    }

    private boolean isValidMountingEntity(Entity entity, int ops) {
        return ops % 10 >= 5 ? entity.getClass().equals(EntityChicken.class) : (ops % 10 >= 4 ? entity.getClass().equals(EntityPig.class) : (ops % 10 >= 3 ? entity.getClass().equals(EntitySheep.class) : (ops % 10 >= 2 ? entity.getClass().equals(EntityCow.class) : (ops % 10 >= 1 ? entity.getClass().equals(EntityHorse.class) : ops % 10 >= 0 && entity.getClass().equals(EntityVillager.class)))));
    }

    private boolean isValidMountingStock(Entity stock, int ops) {
        if (ops % 100 >= 30) {
            return stock instanceof RoWLocomotive;
        }
        if (ops % 100 >= 20) {
            return stock instanceof CartIII2L12;
        }
        if (ops % 100 >= 10) {
            return stock instanceof CartNTV;
        }
        if (ops % 100 >= 0) {
            return stock instanceof RoWLocomotive || stock instanceof CartIII2L12 || stock instanceof CartNTV;
        }
        return false;
    }

    private double[] getMountingOffset(Entity stock, int ops) {
        double xOffset = 3.0 * Math.cos(Math.toRadians(stock.field_70177_z));
        double zOffset = 3.0 * Math.sin(Math.toRadians(stock.field_70177_z));
        if (ops % 1000 >= 200) {
            return new double[]{xOffset, -1.0, zOffset};
        }
        if (ops % 1000 >= 100) {
            return new double[]{xOffset * -1.0, -1.0, zOffset * -1.0};
        }
        return new double[]{0.0, -1.0, 0.0};
    }

    @Override
    public void func_145839_a(NBTTagCompound tagcompound) {
        super.func_145839_a(tagcompound);
        this.opMode = tagcompound.func_74762_e("opMode");
        this.ticks = tagcompound.func_74762_e("ticks");
        this.tickDelay = tagcompound.func_74762_e("tickDelay");
        this.reverseSet = tagcompound.func_74762_e("reverseSet");
        this.regulatorSet = tagcompound.func_74762_e("regulatorSet");
        this.whistleMode = tagcompound.func_74762_e("whistleMode");
        this.loadingOps = tagcompound.func_74762_e("loadingOps");
        this.unloadingOps = tagcompound.func_74762_e("unloadingOps");
        this.whistleVolume = tagcompound.func_74760_g("whistleVolume");
        this.whistlePitch = tagcompound.func_74760_g("whistlePitch");
        this.scheduledTime = tagcompound.func_74763_f("scheduledTime");
        this.locoLabel = tagcompound.func_74779_i("locoLabel");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagcompound) {
        super.func_145841_b(tagcompound);
        tagcompound.func_74768_a("opMode", this.opMode);
        tagcompound.func_74768_a("ticks", this.ticks);
        tagcompound.func_74768_a("tickDelay", this.tickDelay);
        tagcompound.func_74768_a("reverseSet", this.reverseSet);
        tagcompound.func_74768_a("regulatorSet", this.regulatorSet);
        tagcompound.func_74768_a("whistleMode", this.whistleMode);
        tagcompound.func_74768_a("loadingOps", this.loadingOps);
        tagcompound.func_74768_a("unloadingOps", this.unloadingOps);
        tagcompound.func_74776_a("whistleVolume", this.whistleVolume);
        tagcompound.func_74776_a("whistlePitch", this.whistlePitch);
        tagcompound.func_74772_a("scheduledTime", this.scheduledTime);
        tagcompound.func_74778_a("locoLabel", this.locoLabel);
    }
}

