/*
 * Decompiled with CFR 0.152.
 */
package rowautomation.tileentities;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.row.RoW;
import net.row.network.PacketFuel;
import net.row.stock.cart.CartNT;
import rowautomation.tileentities.TileEntityBase;

public class TileEntityTank
extends TileEntityBase {
    public boolean drain = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) return;
        if (this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            return;
        }
        boolean foundTank = false;
        this.changeOpStatus(false);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection tankDirection = ForgeDirection.getOrientation((int)i);
            TileEntity testTileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + tankDirection.offsetX, this.field_145848_d + tankDirection.offsetY, this.field_145849_e + tankDirection.offsetZ);
            if (testTileEntity == null || !IFluidHandler.class.isAssignableFrom(testTileEntity.getClass())) continue;
            IFluidHandler tankContainer = (IFluidHandler)testTileEntity;
            CartNT tankCart = (CartNT)this.getNearbyStock(CartNT.class, this.range);
            if (tankCart == null) {
                return;
            }
            if (this.drain) {
                if (tankCart.fuel == 0) {
                    return;
                }
                FluidStack fluidToDrain = new FluidStack(tankCart.fuelType, Math.min(tankCart.fuel, 100));
                if (!tankContainer.canFill(tankDirection.getOpposite(), fluidToDrain.getFluid())) return;
                tankContainer.fill(tankDirection.getOpposite(), fluidToDrain, true);
                tankCart.fuel -= fluidToDrain.amount;
            } else {
                if (tankCart.fuel >= 96000) {
                    return;
                }
                FluidStack tankFluidData = tankContainer.drain(tankDirection.getOpposite(), 1, false);
                if (tankFluidData == null) {
                    return;
                }
                if (tankCart.fuel == 0) {
                    this.setCartColor(tankFluidData.getFluid(), tankCart);
                    tankCart.fuelType = tankFluidData.getFluidID();
                } else if (tankCart.fuelType != tankFluidData.getFluidID()) {
                    return;
                }
                FluidStack fluidToFill = new FluidStack(tankCart.fuelType, Math.min(96000 - tankCart.fuel, 100));
                if (!tankContainer.canDrain(tankDirection.getOpposite(), fluidToFill.getFluid())) return;
                fluidToFill = tankContainer.drain(tankDirection.getOpposite(), fluidToFill.amount, true);
                if (fluidToFill == null) {
                    return;
                }
                tankCart.fuel += fluidToFill.amount;
                RoW.network.sendToAll((IMessage)new PacketFuel(tankCart.func_145782_y(), tankCart.fuel));
            }
            this.changeOpStatus(true);
        }
    }

    private void setCartColor(Fluid tankFluid, CartNT cart) {
        cart.colourPrimary = tankFluid.getName().equals("water") ? 2437522 : (tankFluid.getName().equals("lava") ? 0xFF0000 : (tankFluid.getName().equals("oil") ? 0x303030 : (tankFluid.getName().equals("fuel") ? 14602026 : tankFluid.getColor())));
        cart.sendUpdateToClient();
    }

    @Override
    public void func_145839_a(NBTTagCompound tagcompound) {
        super.func_145839_a(tagcompound);
        this.drain = tagcompound.func_74767_n("drain");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagcompound) {
        super.func_145841_b(tagcompound);
        tagcompound.func_74757_a("drain", this.drain);
    }
}

