/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismAPI;
import mekanism.api.Pos3D;
import mekanism.client.render.particle.EntityJetpackFlameFX;
import mekanism.client.render.particle.EntityJetpackSmokeFX;
import mekanism.client.render.particle.EntityScubaBubbleFX;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class RenderTickHandler {
    public Random rand = new Random();
    public Minecraft mc = Minecraft.func_71410_x();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.mc.field_71439_g != null && this.mc.field_71441_e != null && !this.mc.func_147113_T()) {
            Pos3D playerPos;
            EntityPlayer p;
            EntityClientPlayerMP player = this.mc.field_71439_g;
            World world = this.mc.field_71439_g.field_70170_p;
            FontRenderer font = this.mc.field_71466_p;
            MovingObjectPosition pos = player.func_70614_a(40.0, 1.0f);
            if (pos != null) {
                int x = MathHelper.func_76128_c((double)pos.field_72311_b);
                int y = MathHelper.func_76128_c((double)pos.field_72312_c);
                int z = MathHelper.func_76128_c((double)pos.field_72309_d);
                Coord4D obj = new Coord4D(x, y, z, world.field_73011_w.field_76574_g);
                if (MekanismAPI.debug && this.mc.field_71462_r == null && !this.mc.field_71474_y.field_74330_P) {
                    String tileDisplay = "";
                    if (obj.getTileEntity((IBlockAccess)world) != null && obj.getTileEntity((IBlockAccess)world).getClass() != null) {
                        tileDisplay = obj.getTileEntity((IBlockAccess)world).getClass().getSimpleName();
                    }
                    font.func_78261_a("Block: " + obj.getBlock((IBlockAccess)world).func_149739_a(), 1, 1, 0x404040);
                    font.func_78261_a("Metadata: " + obj.getMetadata((IBlockAccess)world), 1, 10, 0x404040);
                    font.func_78261_a("Location: " + MekanismUtils.getCoordDisplay(obj), 1, 19, 0x404040);
                    font.func_78261_a("TileEntity: " + tileDisplay, 1, 28, 0x404040);
                    font.func_78261_a("Side: " + pos.field_72310_e, 1, 37, 0x404040);
                }
            }
            if (player != null && this.mc.field_71462_r == null && player.func_71124_b(3) != null) {
                ItemStack stack = player.func_71124_b(3);
                ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                int x = scaledresolution.func_78326_a();
                int y = scaledresolution.func_78328_b();
                if (stack.func_77973_b() instanceof ItemJetpack) {
                    ItemJetpack jetpack = (ItemJetpack)stack.func_77973_b();
                    font.func_78261_a("Mode: " + jetpack.getMode(stack).getName(), 1, y - 20, 0x404040);
                    font.func_78261_a("Hydrogen: " + jetpack.getStored(stack), 1, y - 11, 0x404040);
                } else if (stack.func_77973_b() instanceof ItemScubaTank) {
                    ItemScubaTank scubaTank = (ItemScubaTank)stack.func_77973_b();
                    String state = scubaTank.getFlowing(stack) ? (Object)((Object)EnumColor.DARK_GREEN) + "On" : (Object)((Object)EnumColor.DARK_RED) + "Off";
                    font.func_78261_a("Mode: " + state, 1, y - 20, 0x404040);
                    font.func_78261_a("Oxygen: " + scubaTank.getStored(stack), 1, y - 11, 0x404040);
                }
            }
            Object object = Mekanism.jetpackOn;
            synchronized (object) {
                for (String s : Mekanism.jetpackOn) {
                    p = this.mc.field_71441_e.func_72924_a(s);
                    if (p == null) continue;
                    playerPos = new Pos3D((Entity)p);
                    if (p != this.mc.field_71439_g) {
                        playerPos.translate(0.0, 1.7, 0.0);
                    }
                    float random = (this.rand.nextFloat() - 0.5f) * 0.1f;
                    Pos3D vLeft = new Pos3D();
                    vLeft.xPos -= 0.43;
                    vLeft.yPos -= 0.55;
                    vLeft.zPos -= 0.54;
                    vLeft.rotatePitch(p.func_70093_af() ? 25.0 : 0.0);
                    vLeft.rotateYaw(p.field_70761_aq);
                    Pos3D vRight = new Pos3D();
                    vRight.xPos += 0.43;
                    vRight.yPos -= 0.55;
                    vRight.zPos -= 0.54;
                    vRight.rotatePitch(p.func_70093_af() ? 25.0 : 0.0);
                    vRight.rotateYaw(p.field_70761_aq);
                    Pos3D vCenter = new Pos3D();
                    vCenter.xPos = (this.rand.nextFloat() - 0.5f) * 0.4f;
                    vCenter.yPos -= 0.86;
                    vCenter.zPos -= 0.3;
                    vCenter.rotatePitch(p.func_70093_af() ? 25.0 : 0.0);
                    vCenter.rotateYaw(p.field_70761_aq);
                    Pos3D rLeft = vLeft.clone().scale(random);
                    Pos3D rRight = vRight.clone().scale(random);
                    Pos3D mLeft = vLeft.clone().scale(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                    Pos3D mRight = vRight.clone().scale(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                    Pos3D mCenter = vCenter.clone().scale(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                    mLeft.translate(rLeft);
                    mRight.translate(rRight);
                    Pos3D v = playerPos.clone().translate(vLeft);
                    this.spawnAndSetParticle("flame", world, v.xPos, v.yPos, v.zPos, mLeft.xPos, mLeft.yPos, mLeft.zPos);
                    this.spawnAndSetParticle("smoke", world, v.xPos, v.yPos, v.zPos, mLeft.xPos, mLeft.yPos, mLeft.zPos);
                    v = playerPos.clone().translate(vRight);
                    this.spawnAndSetParticle("flame", world, v.xPos, v.yPos, v.zPos, mRight.xPos, mRight.yPos, mRight.zPos);
                    this.spawnAndSetParticle("smoke", world, v.xPos, v.yPos, v.zPos, mRight.xPos, mRight.yPos, mRight.zPos);
                    v = playerPos.clone().translate(vCenter);
                    this.spawnAndSetParticle("flame", world, v.xPos, v.yPos, v.zPos, mCenter.xPos, mCenter.yPos, mCenter.zPos);
                    this.spawnAndSetParticle("smoke", world, v.xPos, v.yPos, v.zPos, mCenter.xPos, mCenter.yPos, mCenter.zPos);
                }
            }
            object = Mekanism.gasmaskOn;
            synchronized (object) {
                if (world.func_72820_D() % 4L == 0L) {
                    for (String s : Mekanism.gasmaskOn) {
                        p = this.mc.field_71441_e.func_72924_a(s);
                        if (p == null || !p.func_70090_H()) continue;
                        playerPos = new Pos3D((Entity)p);
                        if (p != this.mc.field_71439_g) {
                            playerPos.translate(0.0, 1.7, 0.0);
                        }
                        float xRand = (this.rand.nextFloat() - 0.5f) * 0.08f;
                        float yRand = (this.rand.nextFloat() - 0.5f) * 0.05f;
                        Pos3D vec = new Pos3D(0.4, 0.4, 0.4).multiply(new Pos3D(p.func_70676_i(90.0f))).translate(0.0, -0.2, 0.0);
                        Pos3D motion = vec.clone().scale(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                        Pos3D v = playerPos.clone().translate(vec);
                        this.spawnAndSetParticle("bubble", world, v.xPos, v.yPos, v.zPos, motion.xPos, motion.yPos + 0.2, motion.zPos);
                    }
                }
            }
            if (world.func_72820_D() % 4L == 0L) {
                for (EntityPlayer p2 : world.field_73010_i) {
                    if (Mekanism.flamethrowerActive.contains(p2.func_70005_c_()) || p2.field_82175_bq || p2.func_71045_bC() == null || !(p2.func_71045_bC().func_77973_b() instanceof ItemFlamethrower) || ((ItemFlamethrower)p2.func_71045_bC().func_77973_b()).getGas(p2.func_71045_bC()) == null) continue;
                    Pos3D playerPos2 = new Pos3D((Entity)p2);
                    Pos3D flameVec = new Pos3D();
                    if (p2.func_70093_af()) {
                        flameVec.yPos -= (double)0.35f;
                        flameVec.zPos -= (double)0.15f;
                    }
                    Pos3D flameMotion = new Pos3D(p2.field_70159_w, p2.field_70122_E ? 0.0 : p2.field_70181_x, p2.field_70179_y);
                    if (player == p2 && this.mc.field_71474_y.field_74320_O == 0) {
                        flameVec = new Pos3D(0.8, 0.8, 0.8);
                        flameVec.multiply(new Pos3D(p2.func_70676_i(90.0f)));
                        flameVec.rotateYaw(15.0);
                    } else {
                        flameVec.xPos -= (double)0.45f;
                        flameVec.yPos = player == p2 ? (flameVec.yPos -= 0.5) : (flameVec.yPos += 1.0);
                        flameVec.zPos += (double)1.05f;
                        flameVec.rotateYaw(p2.field_70761_aq);
                    }
                    Pos3D mergedVec = playerPos2.clone().translate(flameVec);
                    this.spawnAndSetParticle("flame", world, mergedVec.xPos, mergedVec.yPos, mergedVec.zPos, flameMotion.xPos, flameMotion.yPos, flameMotion.zPos);
                }
            }
        }
    }

    public void spawnAndSetParticle(String s, World world, double x, double y, double z, double velX, double velY, double velZ) {
        Object fx = null;
        if (s.equals("flame")) {
            fx = new EntityJetpackFlameFX(world, x, y, z, velX, velY, velZ);
        } else if (s.equals("smoke")) {
            fx = new EntityJetpackSmokeFX(world, x, y, z, velX, velY, velZ);
        } else if (s.equals("bubble")) {
            fx = new EntityScubaBubbleFX(world, x, y, z, velX, velY, velZ);
        }
        this.mc.field_71452_i.func_78873_a((EntityFX)fx);
    }
}

