/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.eydamos.backpack.helper.GuiHelper;
import de.eydamos.backpack.inventory.InventoryBackpack;
import de.eydamos.backpack.item.ItemsBackpack;
import de.eydamos.backpack.misc.ConfigurationBackpack;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.backpack.util.BackpackUtil;
import de.eydamos.backpack.util.NBTItemStackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemBackpackBase
extends Item {
    public ItemBackpackBase() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ItemsBackpack.tabBackpacks);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        if (item == ItemsBackpack.backpack) {
            for (int tier = 0; tier < 3; ++tier) {
                for (int i = 0; i < 17; ++i) {
                    subItems.add(new ItemStack(item, 1, tier * 100 + i));
                }
            }
            subItems.add(new ItemStack(item, 1, 31999));
        } else if (item == ItemsBackpack.workbenchBackpack) {
            subItems.add(new ItemStack(item, 1, 17));
            subItems.add(new ItemStack(item, 1, 217));
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World worldObj, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (null == itemStack.func_77978_p()) {
            this.func_77622_d(itemStack, world, entityPlayer);
        }
        if (!BackpackUtil.isServerSide(world)) {
            if (entityPlayer.func_70093_af() && !BackpackUtil.isEnderBackpack(itemStack)) {
                GuiHelper.displayRenameGui();
            }
            return itemStack;
        }
        if (!entityPlayer.func_70093_af() && !ConfigurationBackpack.OPEN_ONLY_PERSONAL_BACKPACK) {
            GuiHelper.displayBackpack(new BackpackSave(itemStack), ItemBackpackBase.getInventory(itemStack, entityPlayer), (EntityPlayerMP)entityPlayer);
        }
        return itemStack;
    }

    public String func_77667_c(ItemStack itemStack) {
        String name = super.func_77658_a();
        int damage = itemStack.func_77960_j();
        int tier = damage / 100 < 3 ? damage / 100 : 0;
        int meta = damage % 100;
        name = name + (tier == 0 ? "" : Character.valueOf('.')) + ItemsBackpack.BACKPACK_TIERS[tier];
        if (meta > 0 && meta < 17) {
            name = name + (tier == 0 ? (char)'.' : '_') + ItemsBackpack.BACKPACK_COLORS[damage % 100];
        }
        if (meta == 99) {
            name = name + (tier == 0 ? (char)'.' : '_') + ItemsBackpack.BACKPACK_COLORS[17];
        }
        return name;
    }

    public String func_77653_i(ItemStack itemStack) {
        if (NBTItemStackUtil.hasTag(itemStack, "customName")) {
            return NBTItemStackUtil.getString(itemStack, "customName");
        }
        return StatCollector.func_74838_a((String)(this.func_77667_c(itemStack) + ".name"));
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        new BackpackSave(itemStack, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List information, boolean advancedTooltip) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            if (itemStack.func_77960_j() != 31999) {
                information.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"tooltip.tier") + " " + (itemStack.func_77960_j() / 100 + 1));
                BackpackSave backpackSave = new BackpackSave(itemStack);
                NBTTagList itemList = backpackSave.getInventory("backpack");
                int used = itemList.func_74745_c();
                int size = backpackSave.getSize();
                information.add(used + "/" + size + ' ' + StatCollector.func_74838_a((String)"tooltip.slots_used"));
            }
        } else {
            information.add(StatCollector.func_74838_a((String)"tooltip.more_information"));
        }
    }

    public static IInventory getInventory(ItemStack itemStack, EntityPlayer entityPlayer) {
        if (BackpackUtil.isEnderBackpack(itemStack)) {
            return entityPlayer.func_71005_bN();
        }
        String defaultName = NBTItemStackUtil.getString(itemStack, "name");
        String customName = NBTItemStackUtil.getString(itemStack, "customName");
        InventoryBackpack inventory = new InventoryBackpack(defaultName, customName);
        return inventory;
    }
}

