/*
 * Decompiled with CFR 0.152.
 */
package mods.eln;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.channel.ChannelHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.client.ClientProxy;
import mods.eln.misc.Coordinate;
import mods.eln.misc.IConfigSharing;
import mods.eln.misc.Utils;
import mods.eln.node.INodeEntity;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeManager;
import mods.eln.server.PlayerManager;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sound.SoundClient;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.TileEntity;

@ChannelHandler.Sharable
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u0016\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lmods/eln/PacketHandler;", "", "()V", "onServerPacket", "", "event", "Lcpw/mods/fml/common/network/FMLNetworkEvent$ServerCustomPacketEvent;", "packetDestroyUuid", "stream", "Ljava/io/DataInputStream;", "manager", "Lnet/minecraft/network/NetworkManager;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "packetForClientNode", "packetForNode", "packetNewClient", "packetNodeSingleSerialized", "packetOpenLocalGui", "packetPlaySound", "packetPlayerKey", "packetRx", "packetServerInfo", "Eln"})
public final class PacketHandler {
    public PacketHandler() {
        Eln.eventChannel.register((Object)this);
    }

    @SubscribeEvent
    public final void onServerPacket(@NotNull FMLNetworkEvent.ServerCustomPacketEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        FMLProxyPacket packet = event.packet;
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(packet.payload().array()));
        NetworkManager manager = event.manager;
        INetHandler iNetHandler = event.handler;
        Intrinsics.checkNotNull(iNetHandler, "null cannot be cast to non-null type net.minecraft.network.NetHandlerPlayServer");
        EntityPlayerMP entityPlayerMP = ((NetHandlerPlayServer)iNetHandler).field_147369_b;
        Intrinsics.checkNotNullExpressionValue(entityPlayerMP, "event.handler as NetHand\u2026rPlayServer).playerEntity");
        EntityPlayer player = (EntityPlayer)entityPlayerMP;
        Intrinsics.checkNotNullExpressionValue(manager, "manager");
        this.packetRx(stream, manager, player);
    }

    public final void packetRx(@NotNull DataInputStream stream, @NotNull NetworkManager manager, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(manager, "manager");
        Intrinsics.checkNotNullParameter(player, "player");
        try {
            byte by = stream.readByte();
            if (by == 14) {
                this.packetPlayerKey(stream, manager, player);
            } else if (by == 15) {
                this.packetNodeSingleSerialized(stream, manager, player);
            } else if (by == 16) {
                this.packetForNode(stream, manager, player);
            } else if (by == 18) {
                this.packetForClientNode(stream, manager, player);
            } else if (by == 17) {
                this.packetOpenLocalGui(stream, manager, player);
            } else if (by == 19) {
                this.packetPlaySound(stream, manager, player);
            } else if (by == 20) {
                this.packetDestroyUuid(stream, manager, player);
            } else if (by == 21) {
                this.packetNewClient(manager, player);
            } else if (by == 22) {
                this.packetServerInfo(stream, manager, player);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void packetNewClient(NetworkManager manager, EntityPlayer player) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream stream = new DataOutputStream(bos);
        try {
            stream.writeByte(22);
            for (IConfigSharing c : Eln.instance.configShared) {
                c.serializeConfig(stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Intrinsics.checkNotNull(player, "null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
        Utils.sendPacketToClient(bos, (EntityPlayerMP)player);
    }

    private final void packetServerInfo(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        for (IConfigSharing c : Eln.instance.configShared) {
            try {
                c.deserialize(stream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private final void packetDestroyUuid(DataInputStream stream, NetworkManager manager, EntityPlayer player) {
        try {
            ClientProxy.uuidManager.kill(stream.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void packetPlaySound(@NotNull DataInputStream stream, @NotNull NetworkManager manager, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(manager, "manager");
        Intrinsics.checkNotNullParameter(player, "player");
        try {
            if (stream.readByte() != player.field_71093_bK) {
                return;
            }
            SoundClient.play(SoundCommand.fromStream(stream, player.field_70170_p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void packetOpenLocalGui(@NotNull DataInputStream stream, @NotNull NetworkManager manager, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(manager, "manager");
        Intrinsics.checkNotNullParameter(player, "player");
        try {
            player.openGui((Object)Eln.instance, stream.readInt(), player.field_70170_p, stream.readInt(), stream.readInt(), stream.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void packetForNode(@NotNull DataInputStream stream, @NotNull NetworkManager manager, @Nullable EntityPlayer player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(manager, "manager");
        try {
            Coordinate coordinate = new Coordinate(stream.readInt(), stream.readInt(), stream.readInt(), stream.readByte());
            NodeManager nodeManager = NodeManager.instance;
            Intrinsics.checkNotNull((Object)nodeManager);
            NodeBase node = nodeManager.getNodeFromCoordonate(coordinate);
            if (node != null && Intrinsics.areEqual(node.getNodeUuid(), stream.readUTF())) {
                node.networkUnserialize(stream, (EntityPlayerMP)player);
            } else {
                Utils.println("packetForNode node found");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void packetForClientNode(@NotNull DataInputStream stream, @NotNull NetworkManager manager, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(manager, "manager");
        Intrinsics.checkNotNullParameter(player, "player");
        try {
            int x = stream.readInt();
            int y = stream.readInt();
            int z = stream.readInt();
            byte dimension = stream.readByte();
            if (player.field_71093_bK == dimension) {
                TileEntity entity = player.field_70170_p.func_147438_o(x, y, z);
                if (entity != null && entity instanceof INodeEntity) {
                    INodeEntity node = (INodeEntity)entity;
                    if (Intrinsics.areEqual(node.getNodeUuid(), stream.readUTF())) {
                        node.serverPacketUnserialize(stream);
                        if (stream.available() != 0) {
                            Utils.println("0 != stream.available()");
                        }
                    } else {
                        Utils.println("Wrong node UUID warning");
                        int dataSkipLength = stream.readByte();
                        for (int idx = 0; idx < dataSkipLength; ++idx) {
                            stream.readByte();
                        }
                    }
                }
            } else {
                Utils.println("No node found for " + x + ' ' + y + ' ' + z);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void packetNodeSingleSerialized(@NotNull DataInputStream stream, @NotNull NetworkManager manager, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(manager, "manager");
        Intrinsics.checkNotNullParameter(player, "player");
        try {
            int x = stream.readInt();
            int y = stream.readInt();
            int z = stream.readInt();
            byte dimension = stream.readByte();
            if (player.field_71093_bK == dimension) {
                TileEntity entity = player.field_70170_p.func_147438_o(x, y, z);
                if (entity != null && entity instanceof INodeEntity) {
                    INodeEntity node = (INodeEntity)entity;
                    if (Intrinsics.areEqual(node.getNodeUuid(), stream.readUTF())) {
                        node.serverPublishUnserialize(stream);
                        if (stream.available() != 0) {
                            Utils.println("0 != stream.available()");
                        }
                    } else {
                        Utils.println("Wrong node UUID warning");
                        int dataSkipLength = stream.readByte();
                        for (int idx = 0; idx < dataSkipLength; ++idx) {
                            stream.readByte();
                        }
                    }
                } else {
                    Utils.println("No node found for " + x + ' ' + y + ' ' + z);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void packetPlayerKey(@NotNull DataInputStream stream, @NotNull NetworkManager manager, @Nullable EntityPlayer player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(manager, "manager");
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        byte id = 0;
        try {
            id = stream.readByte();
            boolean state = stream.readBoolean();
            if (id == 1) {
                PlayerManager.PlayerMetadata metadata;
                EntityPlayerMP entityPlayerMP = playerMP;
                Intrinsics.checkNotNull(entityPlayerMP);
                PlayerManager.PlayerMetadata playerMetadata = metadata = Eln.playerManager.get(entityPlayerMP);
                Intrinsics.checkNotNull(playerMetadata);
                playerMetadata.setInteractEnable(state);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

