/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.IOException;
import java.net.URL;
import mods.eln.Eln;
import mods.eln.misc.FC;
import mods.eln.misc.Version;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.commons.io.IOUtils;

public class VersionCheckerHandler {
    private static final String URL = "http://eln.ja13.org/modinfo.json";
    private static VersionCheckerHandler instance;
    private boolean ready = false;
    private String versionMsg = "";

    public static VersionCheckerHandler getInstance() {
        if (instance == null) {
            instance = new VersionCheckerHandler();
        }
        return instance;
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (!this.ready || event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft m = FMLClientHandler.instance().getClient();
        WorldClient world = m.field_71441_e;
        if (m == null || world == null) {
            return;
        }
        if (!this.ready) {
            return;
        }
        if (Eln.versionCheckEnabled) {
            System.out.println(Version.printColor());
            String elnVers = "Electrical Age";
            m.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(elnVers));
            m.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(this.versionMsg));
        }
        FMLCommonHandler.instance().bus().unregister((Object)this);
        this.ready = false;
    }

    private VersionCheckerHandler() {
        Thread versionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String msg = "";
                try {
                    int currentUniqueVersion;
                    String urlSrc = IOUtils.toString((URL)new URL(VersionCheckerHandler.URL));
                    JsonObject j = new JsonParser().parse(urlSrc).getAsJsonObject();
                    int manifestVersion = j.get("manifest_version").getAsInt();
                    if (manifestVersion != 1) {
                        throw new IOException();
                    }
                    JsonObject stable = j.get("stable").getAsJsonObject();
                    int uniqueVersion = 1000000 * stable.get("version_major").getAsInt() + 1000 * stable.get("version_minor").getAsInt() + stable.get("version_revision").getAsInt();
                    if (uniqueVersion > (currentUniqueVersion = Version.UNIQUE_VERSION)) {
                        int major = stable.get("version_major").getAsInt();
                        int minor = stable.get("version_minor").getAsInt();
                        int revision = stable.get("version_revision").getAsInt();
                        msg = String.format(FC.GREEN + "> New stable version available: %d.%d.%d - please upgrade !", major, minor, revision);
                    } else {
                        msg = uniqueVersion == currentUniqueVersion ? "> No update available (last stable version)" : FC.RED + "> Warning: this is a version under test !";
                    }
                }
                catch (Exception e) {
                    String error = "Unable to check the latest available version.";
                    System.err.println("Unable to check the latest available version.");
                    msg = FC.RED + "> " + "Unable to check the latest available version.";
                    e.printStackTrace();
                }
                VersionCheckerHandler.getInstance().versionMsg = msg;
                VersionCheckerHandler.getInstance().ready = true;
            }
        });
        versionThread.start();
    }
}

