/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.entity;

import java.util.ArrayList;
import java.util.Random;
import mods.eln.Eln;
import mods.eln.entity.ReplicatorEntity;
import mods.eln.misc.Coordinate;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeManager;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalConnection;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ITimeRemoverObserver;
import mods.eln.sim.TimeRemover;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.electricalcable.ElectricalCableElement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;

public class ReplicatorCableAI
extends EntityAIBase
implements ITimeRemoverObserver {
    ReplicatorEntity entity;
    public Coordinate cableCoordinate = null;
    Random rand = new Random();
    int lookingPerUpdate = 20;
    ElectricalLoad load = new ElectricalLoad();
    ElectricalLoad cableLoad;
    Resistor resistorLoad = new Resistor(this.load, null);
    ElectricalConnection connection;
    TimeRemover timeRemover = new TimeRemover(this);
    double moveTimeOut;
    double moveTimeOutReset = 20.0;
    double resetTimeout;
    double resetTimeoutReset = 120.0;
    PreSimCheck preSimCheck;

    public ReplicatorCableAI(ReplicatorEntity entity) {
        this.load.setAsPrivate();
        this.entity = entity;
        Eln.instance.highVoltageCableDescriptor.applyTo(this.load);
        this.load.setSerialResistance(this.load.getSerialResistance() * 10.0);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        assert (NodeManager.instance != null);
        ArrayList<NodeBase> nodes = NodeManager.instance.getNodes();
        if (nodes.isEmpty()) {
            return false;
        }
        for (int idx = 0; idx < this.lookingPerUpdate; ++idx) {
            NodeBase node = (NodeBase)nodes.get(this.rand.nextInt(nodes.size()));
            double distance = node.coordinate.distanceTo((Entity)this.entity);
            if (distance > 15.0 || !(node instanceof SixNode)) continue;
            SixNode sixNode = (SixNode)node;
            for (SixNodeElement e : sixNode.sideElementList) {
                PathEntity path;
                ElectricalCableElement cable;
                if (e == null || !(e instanceof ElectricalCableElement) || !this.isElectricalCableInteresting(cable = (ElectricalCableElement)e) || (path = this.entity.func_70661_as().func_75488_a((double)node.coordinate.x, (double)node.coordinate.y, (double)node.coordinate.z)) == null) continue;
                this.entity.func_70661_as().func_75484_a(path, 1.0);
                this.cableCoordinate = node.coordinate;
                this.moveTimeOut = this.moveTimeOutReset;
                this.resistorLoad.highImpedance();
                this.resetTimeout = this.resetTimeoutReset * (0.8 + Math.random() * 0.4);
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.cableCoordinate != null;
    }

    public void func_75246_d() {
        this.moveTimeOut -= 0.05;
        this.resetTimeout -= 0.05;
        ElectricalCableElement cable = this.getCable();
        if (cable == null) {
            this.cableCoordinate = null;
            return;
        }
        this.cableLoad = cable.electricalLoad;
        double distance = this.cableCoordinate.distanceTo((Entity)this.entity);
        if (distance > 2.0 && (this.entity.func_70661_as().func_75505_d() == null || this.entity.func_70661_as().func_75505_d().func_75879_b())) {
            this.entity.func_70661_as().func_75492_a((double)this.cableCoordinate.x, (double)this.cableCoordinate.y, (double)this.cableCoordinate.z, 1.0);
        }
        if (distance < 2.0) {
            double u = cable.electricalLoad.getVoltage();
            double nextRp = Math.pow(u / 50.0, -0.3) * u * u / 50.0;
            if (this.resistorLoad.getResistance() < 0.8 * nextRp) {
                this.entity.func_70097_a(DamageSource.field_76376_m, 5.0f);
            } else {
                this.entity.eatElectricity(this.resistorLoad.getPower() * 0.05);
            }
            this.resistorLoad.setResistance(nextRp);
            this.timeRemover.setTimeout(0.16);
            this.moveTimeOut = this.moveTimeOutReset;
        } else {
            this.resistorLoad.highImpedance();
        }
        if (this.moveTimeOut < 0.0 || this.resetTimeout < 0.0) {
            this.cableCoordinate = null;
        }
    }

    boolean isElectricalCableInteresting(ElectricalCableElement c) {
        return !c.descriptor.signalWire && !(c.electricalLoad.getVoltage() < 30.0);
    }

    ElectricalCableElement getCable() {
        if (this.cableCoordinate == null) {
            return null;
        }
        assert (NodeManager.instance != null);
        NodeBase node = NodeManager.instance.getNodeFromCoordonate(this.cableCoordinate);
        if (node == null) {
            return null;
        }
        if (node instanceof SixNode) {
            SixNode sixNode = (SixNode)node;
            for (SixNodeElement e : sixNode.sideElementList) {
                ElectricalCableElement cable;
                if (e == null || !(e instanceof ElectricalCableElement) || !this.isElectricalCableInteresting(cable = (ElectricalCableElement)e)) continue;
                return cable;
            }
        }
        return null;
    }

    @Override
    public void timeRemoverRemove() {
        Eln.simulator.removeElectricalLoad(this.load);
        Eln.simulator.removeElectricalComponent(this.connection);
        Eln.simulator.removeElectricalComponent(this.resistorLoad);
        Eln.simulator.removeSlowPreProcess(this.preSimCheck);
        this.connection = null;
    }

    @Override
    public void timeRemoverAdd() {
        Eln.simulator.addElectricalLoad(this.load);
        this.connection = new ElectricalConnection(this.load, this.cableLoad);
        Eln.simulator.addElectricalComponent(this.connection);
        Eln.simulator.addElectricalComponent(this.resistorLoad);
        this.preSimCheck = new PreSimCheck();
        Eln.simulator.addSlowPreProcess(this.preSimCheck);
    }

    class PreSimCheck
    implements IProcess {
        PreSimCheck() {
        }

        @Override
        public void process(double time) {
            if (!ReplicatorCableAI.this.timeRemover.isArmed()) {
                return;
            }
            if (!Eln.simulator.isRegistred(ReplicatorCableAI.this.cableLoad)) {
                ReplicatorCableAI.this.timeRemover.shot();
            }
        }
    }
}

