/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.fluid;

import mods.eln.fluid.FuelRegistry;
import mods.eln.misc.INBTTReady;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ElementFluidHandler
implements IFluidHandler,
INBTTReady {
    private Fluid[] whitelist;
    private float fluid_heat_mb = 0.0f;
    public FluidTank tank;

    public ElementFluidHandler(int tankSize) {
        this.tank = new FluidTank(tankSize);
    }

    public void setFilter(Fluid[] whitelist) {
        assert (whitelist != null);
        this.whitelist = whitelist;
    }

    public float getHeatEnergyPerMilliBucket() {
        if (this.fluid_heat_mb == 0.0f && this.tank.getFluid() != null) {
            this.setHeatEnergyPerMilliBucket(this.tank.getFluid().getFluid());
        }
        return this.fluid_heat_mb;
    }

    private void setHeatEnergyPerMilliBucket(Fluid fluid) {
        this.fluid_heat_mb = (float)FuelRegistry.INSTANCE.heatEnergyPerMilliBucket(fluid);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.tank.getFluidAmount() > 0) {
            return this.tank.fill(resource, doFill);
        }
        if (this.whitelist == null) {
            this.setHeatEnergyPerMilliBucket(resource.getFluid());
            return this.tank.fill(resource, doFill);
        }
        int resourceId = resource.getFluidID();
        for (int i = 0; i < this.whitelist.length; ++i) {
            if (this.whitelist[i].getID() != resourceId) continue;
            this.setHeatEnergyPerMilliBucket(resource.getFluid());
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource.isFluidEqual(this.tank.getFluid())) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        int fluidId = fluid.getID();
        if (this.tank.getFluidAmount() > 0) {
            return this.tank.getFluid().getFluidID() == fluidId;
        }
        for (int i = 0; i < this.whitelist.length; ++i) {
            if (this.whitelist[i].getID() != fluidId) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.tank.readFromNBT(nbt.func_74775_l(str + "tank"));
        this.fluid_heat_mb = nbt.func_74760_g(str + "fhm");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        NBTTagCompound t = new NBTTagCompound();
        this.tank.writeToNBT(t);
        nbt.func_74782_a(str + "tank", (NBTBase)t);
        nbt.func_74776_a(str + "fhm", this.fluid_heat_mb);
    }
}

