/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.fluid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mods.eln.fluid.TankData;
import mods.eln.misc.INBTTReady;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0016J\u001c\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0016J$\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J&\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J$\u0010\u001e\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020!J\u000e\u0010#\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010%\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0005J\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001c\u0010/\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001300J\u0018\u00101\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00062"}, d2={"Lmods/eln/fluid/ElementSidedFluidHandler;", "Lnet/minecraftforge/fluids/IFluidHandler;", "Lmods/eln/misc/INBTTReady;", "tankData", "", "Lnet/minecraftforge/common/util/ForgeDirection;", "Lmods/eln/fluid/TankData;", "(Ljava/util/Map;)V", "tankSizeMb", "", "(I)V", "tanks", "", "getTanks", "()Ljava/util/Map;", "addFluidWhitelist", "", "direction", "fluidWhitelist", "Lnet/minecraftforge/fluids/Fluid;", "canDrain", "", "from", "fluid", "canFill", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxDrain", "doDrain", "resource", "fill", "doFill", "fractionalDrain", "", "demand", "getCapacity", "getFluidAmount", "getFluidType", "getTankInfo", "", "Lnet/minecraftforge/fluids/FluidTankInfo;", "(Lnet/minecraftforge/common/util/ForgeDirection;)[Lnet/minecraftforge/fluids/FluidTankInfo;", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "setFluidWhitelist", "", "writeToNBT", "Eln"})
@SourceDebugExtension(value={"SMAP\nElementSidedFluidHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementSidedFluidHandler.kt\nmods/eln/fluid/ElementSidedFluidHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,182:1\n13579#2,2:183\n13579#2,2:191\n13579#2,2:198\n1855#3,2:185\n1549#3:187\n1620#3,3:188\n1864#3,3:195\n215#4,2:193\n*S KotlinDebug\n*F\n+ 1 ElementSidedFluidHandler.kt\nmods/eln/fluid/ElementSidedFluidHandler\n*L\n30#1:183,2\n153#1:191,2\n175#1:198,2\n84#1:185,2\n100#1:187\n100#1:188,3\n171#1:195,3\n165#1:193,2\n*E\n"})
public class ElementSidedFluidHandler
implements IFluidHandler,
INBTTReady {
    @NotNull
    private final Map<ForgeDirection, TankData> tanks;

    @NotNull
    protected final Map<ForgeDirection, TankData> getTanks() {
        return this.tanks;
    }

    public ElementSidedFluidHandler(@NotNull Map<ForgeDirection, TankData> tankData) {
        Intrinsics.checkNotNullParameter(tankData, "tankData");
        this.tanks = new LinkedHashMap();
        for (Map.Entry<ForgeDirection, TankData> entry : tankData.entrySet()) {
            this.tanks.put(entry.getKey(), entry.getValue());
        }
    }

    public ElementSidedFluidHandler(int tankSizeMb) {
        this.tanks = new LinkedHashMap();
        TankData tank = new TankData(new FluidTank(tankSizeMb), new ArrayList(), 0.0, 4, null);
        Intrinsics.checkNotNullExpressionValue(ForgeDirection.VALID_DIRECTIONS, "VALID_DIRECTIONS");
        Object[] $this$forEach$iv = ForgeDirection.VALID_DIRECTIONS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForgeDirection it = (ForgeDirection)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.tanks.put(it, tank);
        }
    }

    public final void setFluidWhitelist(@NotNull ForgeDirection direction, @NotNull List<? extends Fluid> fluidWhitelist) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        Intrinsics.checkNotNullParameter(fluidWhitelist, "fluidWhitelist");
        TankData tank = this.tanks.get(direction);
        if (tank != null) {
            tank.getFluidWhitelist().clear();
            tank.getFluidWhitelist().addAll((Collection<Fluid>)fluidWhitelist);
        }
    }

    public final void addFluidWhitelist(@NotNull ForgeDirection direction, @NotNull Fluid fluidWhitelist) {
        block0: {
            Intrinsics.checkNotNullParameter(direction, "direction");
            Intrinsics.checkNotNullParameter(fluidWhitelist, "fluidWhitelist");
            TankData tank = this.tanks.get(direction);
            Object object = tank;
            if (object == null || (object = ((TankData)object).getFluidWhitelist()) == null) break block0;
            object.add(fluidWhitelist);
        }
    }

    @Nullable
    public final Fluid getFluidType(@NotNull ForgeDirection direction) {
        Fluid fluid;
        Intrinsics.checkNotNullParameter(direction, "direction");
        try {
            TankData tankData = this.tanks.get(direction);
            fluid = tankData != null && (tankData = tankData.getTank()) != null && (tankData = tankData.getFluid()) != null ? tankData.getFluid() : null;
        }
        catch (Exception e) {
            fluid = null;
        }
        return fluid;
    }

    public final int getCapacity(@NotNull ForgeDirection direction) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        try {
            TankData tank = this.tanks.get(direction);
            TankData tankData = tank;
            return tankData != null && (tankData = tankData.getTank()) != null ? tankData.getCapacity() : 0;
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
    }

    public final int getFluidAmount(@NotNull ForgeDirection direction) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        try {
            TankData tank = this.tanks.get(direction);
            TankData tankData = tank;
            return tankData != null && (tankData = tankData.getTank()) != null ? tankData.getFluidAmount() : 0;
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
    }

    public int fill(@Nullable ForgeDirection from, @Nullable FluidStack resource, boolean doFill) {
        if (from == null || resource == null) {
            return 0;
        }
        TankData tankData = this.tanks.get(from);
        if (tankData == null) {
            return 0;
        }
        TankData tank = tankData;
        if (tank.getTank().getFluidAmount() <= 0 && !tank.getFluidWhitelist().isEmpty()) {
            int resourceId = resource.getFluidID();
            Iterable $this$forEach$iv = tank.getFluidWhitelist();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Fluid it = (Fluid)element$iv;
                boolean bl = false;
                if (it.getID() != resourceId) continue;
                return tank.getTank().fill(resource, doFill);
            }
            return 0;
        }
        return tank.getTank().fill(resource, doFill);
    }

    /*
     * WARNING - void declaration
     */
    public boolean canFill(@Nullable ForgeDirection from, @Nullable Fluid fluid) {
        boolean bl;
        if (from == null || fluid == null) {
            return false;
        }
        TankData tankData = this.tanks.get(from);
        if (tankData == null) {
            return false;
        }
        TankData tank = tankData;
        if (tank.getTank().getFluidAmount() > 0) {
            return tank.getTank().getFluid().getFluid().getID() == fluid.getID();
        }
        if (tank.getFluidWhitelist().size() > 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = tank.getFluidWhitelist();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Fluid fluid2 = (Fluid)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getID());
            }
            bl = ((List)destination$iv$iv).contains(fluid.getID());
        } else {
            bl = true;
        }
        return bl;
    }

    @NotNull
    public FluidTankInfo[] getTankInfo(@Nullable ForgeDirection from) {
        if (from == null) {
            return new FluidTankInfo[0];
        }
        TankData tankData = this.tanks.get(from);
        if (tankData == null) {
            return new FluidTankInfo[0];
        }
        TankData tank = tankData;
        FluidTankInfo[] fluidTankInfoArray = new FluidTankInfo[1];
        Intrinsics.checkNotNullExpressionValue(tank.getTank().getInfo(), "tank.tank.info");
        return fluidTankInfoArray;
    }

    @Nullable
    public FluidStack drain(@Nullable ForgeDirection from, @Nullable FluidStack resource, boolean doDrain) {
        if (from == null || resource == null) {
            return null;
        }
        TankData tankData = this.tanks.get(from);
        if (tankData == null) {
            return null;
        }
        TankData tank = tankData;
        return tank.getTank().drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(@Nullable ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == null) {
            return null;
        }
        TankData tankData = this.tanks.get(from);
        if (tankData == null) {
            return null;
        }
        TankData tank = tankData;
        return tank.getTank().drain(maxDrain, doDrain);
    }

    public final double fractionalDrain(@NotNull ForgeDirection from, double demand) {
        Intrinsics.checkNotNullParameter(from, "from");
        TankData tankData = this.tanks.get(from);
        if (tankData == null) {
            return 0.0;
        }
        TankData tank = tankData;
        double drain = Math.ceil(demand - tank.getFractionalDemandMb());
        FluidStack fluidStack = this.drain(from, (int)drain, true);
        double drained = fluidStack != null ? (double)fluidStack.amount : 0.0;
        double available = tank.getFractionalDemandMb() + drained;
        double actual = Math.min(demand, available);
        tank.setFractionalDemandMb(Math.max(0.0, available - demand));
        return actual;
    }

    public boolean canDrain(@Nullable ForgeDirection from, @Nullable Fluid fluid) {
        if (from == null || fluid == null) {
            return false;
        }
        TankData tankData = this.tanks.get(from);
        if (tankData == null) {
            return false;
        }
        TankData tank = tankData;
        return tank.getTank().getFluid().getFluid().getID() == fluid.getID();
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        List tankList = new ArrayList();
        int numTanks = nbt.func_74762_e(str + "numTanks");
        int idx = 0;
        if (idx <= numTanks) {
            while (true) {
                TankData tank = new TankData(new FluidTank(0), new ArrayList(), 0.0, 4, null);
                tank.readFromNBT(nbt, str + "tank" + idx);
                tankList.add(tank);
                if (idx == numTanks) break;
                ++idx;
            }
        }
        this.tanks.clear();
        Intrinsics.checkNotNullExpressionValue(ForgeDirection.VALID_DIRECTIONS, "VALID_DIRECTIONS");
        Object[] $this$forEach$iv = ForgeDirection.VALID_DIRECTIONS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForgeDirection it = (ForgeDirection)element$iv;
            boolean bl = false;
            int tankRef = nbt.func_74762_e(str + it.name() + "tankRef");
            if (tankRef == -1 || numTanks == 0) continue;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.tanks.put(it, (TankData)tankList.get(tankRef));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        int n;
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        List tanksList = new ArrayList();
        Object[] $this$forEach$iv = this.tanks;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ForgeDirection, TankData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ForgeDirection, TankData> element$iv;
            Map.Entry<ForgeDirection, TankData> it = element$iv = iterator2.next();
            n = 0;
            if (tanksList.contains(it.getValue())) continue;
            tanksList.add(it.getValue());
        }
        nbt.func_74768_a(str + "numTanks", tanksList.size());
        Iterable $this$forEachIndexed$iv = tanksList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void tank;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TankData tankData = (TankData)item$iv;
            int idx = n;
            boolean bl = false;
            tank.writeToNBT(nbt, str + "tank" + idx);
        }
        Intrinsics.checkNotNullExpressionValue(ForgeDirection.VALID_DIRECTIONS, "VALID_DIRECTIONS");
        $this$forEach$iv = ForgeDirection.VALID_DIRECTIONS;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForgeDirection it = (ForgeDirection)element$iv;
            boolean bl = false;
            TankData tank = this.tanks.get(it);
            int tankRef = CollectionsKt.indexOf(tanksList, tank);
            nbt.func_74768_a(str + it.name() + "tankRef", tankRef);
        }
    }
}

