/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.fluid;

import mods.eln.fluid.ElementFluidHandler;
import mods.eln.fluid.FuelRegistry;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmods/eln/fluid/PreciseElementFluidHandler;", "Lmods/eln/fluid/ElementFluidHandler;", "tankSize", "", "(I)V", "fixup", "", "drain", "demand", "drainEnergy", "energy", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "", "writeToNBT", "Eln"})
public final class PreciseElementFluidHandler
extends ElementFluidHandler {
    private double fixup;

    public PreciseElementFluidHandler(int tankSize) {
        super(tankSize);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        super.readFromNBT(nbt, str);
        this.fixup = nbt.func_74769_h(str + "fixup");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        super.writeToNBT(nbt, str);
        nbt.func_74780_a(str + "fixup", this.fixup);
    }

    public final double drain(double demand) {
        double drain = Math.ceil(demand - this.fixup);
        FluidStack fluidStack = this.drain(ForgeDirection.DOWN, (int)drain, true);
        double drained = fluidStack != null ? (double)fluidStack.amount : 0.0;
        double available = this.fixup + drained;
        double actual = Math.min(demand, available);
        this.fixup = Math.max(0.0, available - demand);
        return actual;
    }

    public final double drainEnergy(double energy) {
        FluidStack fluidStack = this.tank.getFluid();
        double heatValue = FuelRegistry.INSTANCE.heatEnergyPerMilliBucket((Fluid)(fluidStack != null ? fluidStack.getFluid() : null));
        return heatValue > 0.0 ? heatValue * this.drain(energy / heatValue) : 0.0;
    }
}

